/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.comm;

import com.sun.cldc.io.Waiter;
import com.sun.midp.io.BufferedConnectionAdapter;
import com.sun.midp.main.Configuration;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.CommConnection;

public class Protocol
extends BufferedConnectionAdapter
implements CommConnection {
    private int handle = -1;
    protected static int bufferSize = 256;
    private static final int serSettingsFlagStopBits1 = 0;
    private static final int serSettingsFlagStopBits2 = 1;
    private static final int serSettingsFlagParityOddM = 2;
    private static final int serSettingsFlagParityEvenM = 4;
    private static final int serSettingsFlagRTSAutoM = 16;
    private static final int serSettingsFlagCTSAutoM = 32;
    private static final int serSettingsFlagBitsPerChar7 = 128;
    private static final int serSettingsFlagBitsPerChar8 = 192;
    private int bbc = 192;
    private int stop = 0;
    private int parity = 0;
    private int rts = 16;
    private int cts = 32;
    private int baud = 19200;
    private boolean blocking = true;
    private boolean permissionChecked;
    private static final String protocol = "comm";

    public Protocol() {
        super(bufferSize);
    }

    protected final void checkForPermission(SecurityToken token, String name) throws InterruptedIOException {
        if (this.permissionChecked) {
            return;
        }
        this.checkForPermission(token, 9, name, protocol);
        this.permissionChecked = true;
    }

    private void parseParameter(String parm, int start, int end) {
        if ((parm = parm.substring(start, end)).equals("baudrate=110")) {
            this.baud = 110;
        } else if (parm.equals("baudrate=300")) {
            this.baud = 300;
        } else if (parm.equals("baudrate=600")) {
            this.baud = 600;
        } else if (parm.equals("baudrate=1200")) {
            this.baud = 1200;
        } else if (parm.equals("baudrate=2400")) {
            this.baud = 2400;
        } else if (parm.equals("baudrate=4800")) {
            this.baud = 4800;
        } else if (parm.equals("baudrate=9600")) {
            this.baud = 9600;
        } else if (parm.equals("baudrate=14400")) {
            this.baud = 14400;
        } else if (parm.equals("baudrate=19200")) {
            this.baud = 19200;
        } else if (parm.equals("baudrate=38400")) {
            this.baud = 38400;
        } else if (parm.equals("baudrate=56000")) {
            this.baud = 56000;
        } else if (parm.equals("baudrate=57600")) {
            this.baud = 57600;
        } else if (parm.equals("baudrate=115200")) {
            this.baud = 115200;
        } else if (parm.equals("baudrate=128000")) {
            this.baud = 128000;
        } else if (parm.equals("baudrate=256000")) {
            this.baud = 256000;
        } else if (parm.equals("bitsperchar=7")) {
            this.bbc = 128;
        } else if (parm.equals("bitsperchar=8")) {
            this.bbc = 192;
        } else if (parm.equals("stopbits=1")) {
            this.stop = 0;
        } else if (parm.equals("stopbits=2")) {
            this.stop = 1;
        } else if (parm.equals("parity=none")) {
            this.parity = 0;
        } else if (parm.equals("parity=odd")) {
            this.parity = 2;
        } else if (parm.equals("parity=even")) {
            this.parity = 4;
        } else if (parm.equals("autorts=off")) {
            this.rts = 0;
        } else if (parm.equals("autorts=on")) {
            this.rts = 16;
        } else if (parm.equals("autocts=off")) {
            this.cts = 0;
        } else if (parm.equals("autocts=on")) {
            this.cts = 32;
        } else if (parm.equals("blocking=off")) {
            this.blocking = false;
        } else if (parm.equals("blocking=on")) {
            this.blocking = true;
        } else {
            throw new IllegalArgumentException("Bad parameter");
        }
    }

    public void connect(String name, int mode, boolean timeouts) throws IOException {
        int portNumber = 0;
        String deviceName = null;
        int start = 0;
        int pos = 0;
        if (!this.permissionChecked) {
            throw new SecurityException("The permission check was bypassed");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Missing port ID");
        }
        if (Character.isDigit(name.charAt(0))) {
            portNumber = Integer.parseInt(name.substring(0, 1));
            ++pos;
        } else {
            pos = name.indexOf(";");
            if (pos < 0) {
                deviceName = name;
                pos = name.length();
            } else {
                deviceName = name.substring(0, pos);
            }
        }
        block0: while (name.length() > pos) {
            if (name.charAt(pos) != ';') {
                throw new IllegalArgumentException("missing parameter delimiter");
            }
            start = ++pos;
            while (true) {
                if (pos == name.length()) {
                    this.parseParameter(name, start, pos);
                    continue block0;
                }
                if (name.charAt(pos) == ';') {
                    this.parseParameter(name, start, pos);
                    continue block0;
                }
                ++pos;
            }
        }
        this.handle = deviceName != null ? Protocol.native_openByName(deviceName, this.baud, this.bbc | this.stop | this.parity | this.rts | this.cts) : Protocol.native_openByNumber(portNumber, this.baud, this.bbc | this.stop | this.parity | this.rts | this.cts);
        this.registerCleanup();
    }

    public int getBaudRate() {
        return this.baud;
    }

    public int setBaudRate(int baudrate) {
        int temp = this.baud;
        baudrate = baudrate < 299 ? 110 : (baudrate < 599 ? 300 : (baudrate < 1199 ? 600 : (baudrate < 2399 ? 1200 : (baudrate < 4799 ? 2400 : (baudrate < 9599 ? 4800 : (baudrate < 14399 ? 9600 : (baudrate < 19199 ? 14400 : (baudrate < 38399 ? 19200 : (baudrate < 55999 ? 38400 : (baudrate < 57599 ? 56000 : (baudrate < 115199 ? 57600 : (baudrate < 127999 ? 115200 : (baudrate < 255999 ? 128000 : 256000)))))))))))));
        try {
            Protocol.native_configurePort(this.handle, baudrate, this.bbc | this.stop | this.parity | this.rts | this.cts);
            this.baud = baudrate;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws IOException {
        try {
            Protocol.native_close(this.handle);
        }
        finally {
            this.handle = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nonBufferedRead(byte[] b, int off, int len) throws IOException {
        while (true) {
            int bytesRead;
            try {
                bytesRead = Protocol.native_readBytes(this.handle, b, off, len);
            }
            finally {
                if (this.iStreams == 0) {
                    throw new InterruptedIOException("Stream closed");
                }
            }
            if (bytesRead == -1) {
                this.eof = true;
                return -1;
            }
            if (bytesRead != 0 || !this.blocking) {
                return bytesRead;
            }
            Waiter.waitForIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readBytesNonBlocking(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        try {
            bytesRead = Protocol.native_readBytes(this.handle, b, off, len);
        }
        finally {
            if (this.iStreams == 0) {
                throw new InterruptedIOException("Stream closed");
            }
        }
        if (bytesRead == -1) {
            this.eof = true;
        }
        return bytesRead;
    }

    public int writeBytes(byte[] b, int off, int len) throws IOException {
        return Protocol.native_writeBytes(this.handle, b, off, len);
    }

    private static native int native_openByNumber(int var0, int var1, int var2) throws IOException;

    private static native int native_openByName(String var0, int var1, int var2) throws IOException;

    private static native void native_configurePort(int var0, int var1, int var2) throws IOException;

    private static native void native_close(int var0) throws IOException;

    private native void registerCleanup();

    private static native int native_readBytes(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native int native_writeBytes(int var0, byte[] var1, int var2, int var3) throws IOException;

    private native void finalize();

    static {
        String size = Configuration.getProperty("com.sun.midp.io.j2me.comm.buffersize");
        if (size != null) {
            try {
                bufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

