/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.io.BaseInputStream;
import com.sun.midp.io.BaseOutputStream;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public abstract class ConnectionBaseAdapter
implements ConnectionBaseInterface,
StreamConnection {
    protected boolean connectionOpen = false;
    protected int iStreams = 0;
    protected int maxIStreams = 1;
    protected int oStreams = 0;
    protected int maxOStreams = 1;

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        this.checkForPermission(null, name);
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        this.connect(name, mode, timeouts);
        this.connectionOpen = true;
        return this;
    }

    protected void checkForPermission(SecurityToken token, String name) throws SecurityException, InterruptedIOException {
        throw new SecurityException("Permission not granted");
    }

    protected final void checkForPermission(SecurityToken token, int requiredPermission, String name, String protocol) throws InterruptedIOException {
        if (token != null) {
            token.checkIfPermissionAllowed(requiredPermission);
            return;
        }
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        if (midletSuite == null) {
            return;
        }
        if (protocol != null) {
            name = protocol + ":" + name;
        }
        try {
            midletSuite.checkForPermission(requiredPermission, name);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
    }

    public Connection openPrim(SecurityToken token, String name, int mode, boolean timeouts) throws IOException {
        this.checkForPermission(token, name);
        return this.openPrim(name, mode, timeouts);
    }

    public Connection openPrim(SecurityToken token, String name) throws IOException {
        return this.openPrim(token, name, 3, false);
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.maxIStreams == 0) {
            throw new IOException("no more input streams available");
        }
        BaseInputStream i = new BaseInputStream(this);
        --this.maxIStreams;
        ++this.iStreams;
        return i;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if (this.maxOStreams == 0) {
            throw new IOException("no more output streams available");
        }
        BaseOutputStream o = new BaseOutputStream(this);
        --this.maxOStreams;
        ++this.oStreams;
        return o;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        if (this.connectionOpen) {
            this.connectionOpen = false;
            this.closeCommon();
        }
    }

    protected void closeInputStream() throws IOException {
        --this.iStreams;
        this.closeCommon();
    }

    protected void closeOutputStream() throws IOException {
        --this.oStreams;
        this.closeCommon();
    }

    void closeCommon() throws IOException {
        if (!this.connectionOpen && this.iStreams == 0 && this.oStreams == 0) {
            this.disconnect();
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection closed");
        }
    }

    protected abstract void connect(String var1, int var2, boolean var3) throws IOException;

    protected abstract void disconnect() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int available() throws IOException {
        return 0;
    }

    protected abstract int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected void flush() throws IOException {
    }
}

