/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import com.sun.midp.dev.GraphicalInstaller;
import com.sun.midp.dev.RadioButtonSet;
import com.sun.midp.io.j2me.push.PushRegistryImpl;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.security.Permissions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Manager
extends MIDlet
implements CommandListener,
ItemStateListener {
    private static final String SMALL_COPYRIGHT = Resource.getString("Copyright \u00a9 2003 Sun Microsystems, Inc. All rights reserved.\nSUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.\n");
    private static final String COPYRIGHT = Resource.getString("Copyright \u00a9 2003 Sun Microsystems, Inc.  All rights reserved.\nUnpublished - rights reserved under the Copyright Laws of the United States.Sun Microsystems, Inc. has intellectual property rights relating to technology embodied in the product that is described in this document. In particular, and without limitation, these intellectual property rights may include one or more of the U.S. patents listed at http://www.sun.com/patents and one or more additional patents or pending patent applications in the U.S. and in other countries.SUN PROPRIETARY/CONFIDENTIAL. U.S. Government Rights  - Commercial software.  Government users are subject to the Sun Microsystems, Inc. standard license agreement and applicable provisions of the FAR and its supplements.  Use is subject to license terms.  This distribution may include materials developed by third parties.Sun, Sun Microsystems, the Sun logo, Java and Jini are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S. and other countries.\n");
    private static final int AIRTIME_CHOICE = 0;
    private static final int MESSAGING_CHOICE = 1;
    private static final int COMM_CHOICE = 2;
    private static final int INTERRUPT_CHOICE = 3;
    private static final int RECORDING_CHOICE = 4;
    private static final int READ_USER_DATA_CHOICE = 5;
    private static final int WRITE_USER_DATA_CHOICE = 6;
    private static Image suiteIcon;
    private static Image emptyIcon;
    private static Image singleSuiteIcon;
    private static Image javaLogo;
    private static Image homeScreenGraphic;
    static boolean colorDisplay;
    private static boolean first;
    private Installer installer;
    private List mlist;
    private Display display;
    private long lastDisplayChange;
    private int mcount;
    private MIDletSuiteInfo[] minfo;
    private int selectedSuite;
    static final int CANCELLED = -1;
    private static final String BLANKET_ANSWER = "Just do it and don't ask.";
    private static final String SESSION_ANSWER = "Ask once per application use.";
    private static final String ONESHOT_ANSWER = "Ask every time.";
    private static final String CANCEL_ANSWER = "Not this time. Ask me next time.";
    private static final String DENY_ANSWER = "Don't %3 and don't ask.";
    private Form settings;
    private int displayedSettingID;
    private int lastPopupChoice;
    private RadioButtonSet initialSetting;
    private int numberOfSettings;
    private RadioButtonSet settingsPopup;
    private RadioButtonSet pushSetting;
    private RadioButtonSet netSetting;
    private RadioButtonSet messagingSetting;
    private RadioButtonSet recordingSetting;
    private RadioButtonSet commSetting;
    private RadioButtonSet readUserDataSetting;
    private RadioButtonSet writeUserDataSetting;
    private Command appsCmd = new Command(Resource.getString("Apps"), 1, 1);
    private Command launchCmd = new Command(Resource.getString("Launch"), 8, 1);
    private Command infoCmd = new Command(Resource.getString("Info"), 8, 2);
    private Command removeCmd = new Command(Resource.getString("Remove"), 8, 3);
    private Command updateCmd = new Command(Resource.getString("Update"), 8, 4);
    private Command appSettingsCmd = new Command(Resource.getString("Application Settings"), 8, 5);
    private Command aboutCmd = new Command(Resource.getString("About"), 5, 1);
    private Command saveAppSettingsCmd = new Command(Resource.getString("Save"), 4, 1);
    private Command backCmd = new Command(Resource.getString("Back"), 2, 1);
    private Command cancelCmd = new Command(Resource.getString("Cancel"), 3, 1);
    private Command removeOkCmd = new Command(Resource.getString("Remove"), 1, 1);

    private static Image getSuiteIcon() {
        if (suiteIcon != null) {
            return suiteIcon;
        }
        suiteIcon = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_suite_8.png" : "_suite_2.png");
        return suiteIcon;
    }

    private static Image getEmptyIcon() {
        if (emptyIcon != null) {
            return emptyIcon;
        }
        emptyIcon = GraphicalInstaller.getIconFromStorage("_empty.png");
        return emptyIcon;
    }

    private static Image getSingleSuiteIcon() {
        if (singleSuiteIcon != null) {
            return singleSuiteIcon;
        }
        singleSuiteIcon = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_single8.png" : "_single2.png");
        return singleSuiteIcon;
    }

    private static Image getJavaLogo() {
        if (javaLogo != null) {
            return javaLogo;
        }
        javaLogo = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_logo_8.png" : "_logo_2.png");
        return javaLogo;
    }

    private static Image getHomeScreenGraphic() {
        if (homeScreenGraphic != null) {
            return homeScreenGraphic;
        }
        homeScreenGraphic = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_home_8.png" : "_home_4.png");
        return homeScreenGraphic;
    }

    public Manager() {
        this.installer = Installer.getInstaller();
        this.display = Display.getDisplay(this);
        colorDisplay = this.display.isColor();
        this.mcount = 0;
        this.minfo = new MIDletSuiteInfo[20];
        this.readMIDletSuiteInfo();
        first = this.getAppProperty("logo-displayed").equals("F");
        GraphicalInstaller.initSettings();
        this.setupList();
        if (this.mcount > 0) {
            this.mlist.addCommand(this.infoCmd);
            this.mlist.addCommand(this.removeCmd);
            this.mlist.addCommand(this.updateCmd);
            this.mlist.addCommand(this.appSettingsCmd);
        }
        this.mlist.addCommand(this.launchCmd);
        this.mlist.addCommand(this.backCmd);
        this.mlist.addCommand(this.aboutCmd);
        this.mlist.setCommandListener(this);
        String runMessage = this.getAppProperty("run-message");
        if (runMessage != null) {
            Alert error = new Alert(null);
            error.setString(runMessage);
            this.display.setCurrent(error, this.mlist);
        } else if (first) {
            first = false;
            this.displayHomeScreen();
        } else {
            this.display.setCurrent(this.mlist);
        }
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.resetSettings();
    }

    private void resetSettings() {
        GraphicalInstaller.saveSettings(null, "");
    }

    private void displayHomeScreen() {
        Form home = new Form("");
        this.mlist.setSelectedIndex(0, true);
        home.append(new ImageItem(null, Manager.getJavaLogo(), 771, null));
        home.append(new ImageItem(null, Manager.getHomeScreenGraphic(), 771, null));
        home.addCommand(this.appsCmd);
        home.setCommandListener(this);
        this.display.setCurrent(home);
    }

    private void readMIDletSuiteInfo() {
        String[] suiteNames = this.installer.list();
        for (int i = 0; i < suiteNames.length; ++i) {
            int lowest = i;
            for (int k = i + 1; k < suiteNames.length; ++k) {
                if (suiteNames[k].compareTo(suiteNames[lowest]) >= 0) continue;
                lowest = k;
            }
            try {
                MIDletSuite midletSuite = this.installer.getMIDletSuite(suiteNames[lowest]);
                int numberOfMidlets = midletSuite.getNumberOfMIDlets();
                if (numberOfMidlets == 1) {
                    String attr = midletSuite.getProperty("MIDlet-1");
                    this.addMIDletSuite(new MIDletSuiteInfo(suiteNames[lowest], midletSuite, attr));
                    this.minfo[this.mcount - 1].singleMidlet = true;
                    this.minfo[this.mcount - 1].icon = Manager.getSingleSuiteIcon();
                } else {
                    this.addMIDletSuite(new MIDletSuiteInfo(suiteNames[lowest], midletSuite));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            suiteNames[lowest] = suiteNames[i];
        }
    }

    private void addMIDletSuite(MIDletSuiteInfo info) {
        if (this.mcount >= this.minfo.length) {
            MIDletSuiteInfo[] n = new MIDletSuiteInfo[this.mcount + 4];
            System.arraycopy(this.minfo, 0, n, 0, this.mcount);
            this.minfo = n;
        }
        this.minfo[this.mcount++] = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectedMIDlet() {
        RecordStore settings = null;
        String ret = null;
        try {
            byte[] data;
            settings = RecordStore.openRecordStore("settings", false);
            if (settings.getNumRecords() > 0 && (data = settings.getRecord(2)) != null) {
                ByteArrayInputStream bas = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bas);
                ret = dis.readUTF();
            }
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (settings != null) {
                try {
                    settings.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
        return ret;
    }

    private void setupList() {
        if (this.mlist == null) {
            this.mlist = new List(Resource.getString("Applications"), 3);
            this.mlist.append(" " + Resource.getString("Install Application"), Manager.getSingleSuiteIcon());
            String curMIDlet = this.getSelectedMIDlet();
            for (int i = 0; i < this.mcount; ++i) {
                this.mlist.append(" " + this.minfo[i].displayName, this.minfo[i].icon);
                if (!this.minfo[i].storageName.equals(curMIDlet)) continue;
                this.mlist.setSelectedIndex(i + 1, true);
            }
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.aboutCmd) {
            Alert a = new Alert(null);
            a.setImage(Manager.getJavaLogo());
            a.setString(COPYRIGHT);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        if (s == this.mlist) {
            if (c == this.backCmd) {
                this.displayHomeScreen();
                return;
            }
            this.selectedSuite = this.mlist.getSelectedIndex();
            --this.selectedSuite;
            if (c == List.SELECT_COMMAND || c == this.launchCmd) {
                if (this.selectedSuite == -1) {
                    this.installSuite();
                    return;
                }
                this.launchSuite(this.minfo[this.selectedSuite]);
                return;
            }
            if (this.selectedSuite == -1) {
                this.displayInstallAppWarning();
                return;
            }
            if (c == this.infoCmd) {
                this.displaySuiteInfo(this.minfo[this.selectedSuite]);
                return;
            }
            if (c == this.removeCmd) {
                this.confirmRemove(this.minfo[this.selectedSuite]);
                return;
            }
            if (c == this.updateCmd) {
                this.updateSuite(this.minfo[this.selectedSuite]);
                return;
            }
            if (c == this.appSettingsCmd) {
                this.getApplicationSettings(this.minfo[this.selectedSuite]);
                return;
            }
        }
        if (c == this.removeOkCmd) {
            this.removeSuite(this.minfo[this.selectedSuite]);
            return;
        }
        if (c == this.saveAppSettingsCmd) {
            this.saveApplicationSettings(this.minfo[this.selectedSuite]);
            return;
        }
        if (c == this.appsCmd || c == this.backCmd || c == this.cancelCmd) {
            this.display.setCurrent(this.mlist);
            return;
        }
    }

    private void launchSuite(MIDletSuiteInfo suiteInfo) {
        try {
            if (this.installer.execute(suiteInfo.storageName, null)) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else {
                this.notifyPaused();
                this.resumeRequest();
            }
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(suiteInfo.displayName);
            sb.append("\n");
            sb.append(Resource.getString("Error"));
            sb.append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot start: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
        }
    }

    private void displaySuiteInfo(MIDletSuiteInfo suiteInfo) {
        Form infoForm;
        StringBuffer label = new StringBuffer(40);
        StringBuffer value = new StringBuffer(40);
        try {
            Image icon;
            String name;
            infoForm = new Form(null);
            if (suiteInfo.singleMidlet) {
                name = suiteInfo.displayName;
                icon = suiteInfo.icon;
            } else {
                name = suiteInfo.midletSuite.getProperty("MIDlet-Name");
                icon = Manager.getSuiteIcon();
            }
            label.append(Resource.getString("Info"));
            label.append(": ");
            label.append(name);
            infoForm.setTitle(label.toString());
            infoForm.append(new ImageItem(null, icon, 771, null));
            label.setLength(0);
            label.append(Resource.getString("Size"));
            label.append(": ");
            value.append(Integer.toString((suiteInfo.midletSuite.getStorageUsed() + 1023) / 1024));
            value.append(" K");
            StringItem item = new StringItem(label.toString(), value.toString());
            item.setLayout(16896);
            infoForm.append(item);
            label.setLength(0);
            label.append(Resource.getString("Version"));
            label.append(": ");
            item = new StringItem(label.toString(), suiteInfo.midletSuite.getProperty("MIDlet-Version"));
            item.setLayout(16896);
            infoForm.append(item);
            label.setLength(0);
            String temp = suiteInfo.midletSuite.isTrusted() ? "Authorized Vendor" : "Vendor";
            label.append(Resource.getString(temp));
            label.append(": ");
            item = new StringItem(label.toString(), suiteInfo.midletSuite.getProperty("MIDlet-Vendor"));
            item.setLayout(16896);
            infoForm.append(item);
            temp = suiteInfo.midletSuite.getProperty("MIDlet-Description");
            if (temp != null) {
                label.setLength(0);
                label.append(Resource.getString("Description"));
                label.append(": ");
                item = new StringItem(label.toString(), temp);
                item.setLayout(16896);
                infoForm.append(item);
            }
            if (!suiteInfo.singleMidlet) {
                label.setLength(0);
                label.append(Resource.getString("Contents"));
                label.append(":");
                item = new StringItem(label.toString(), "");
                item.setLayout(16896);
                infoForm.append(item);
                this.appendMIDletsToForm(suiteInfo.midletSuite, infoForm);
            }
            label.setLength(0);
            label.append(Resource.getString("Website"));
            label.append(": ");
            item = new StringItem(label.toString(), suiteInfo.midletSuite.getDownloadUrl());
            item.setLayout(16896);
            infoForm.append(item);
            label.setLength(0);
            label.append(Resource.getString("Advanced"));
            label.append(": ");
            item = new StringItem(label.toString(), "");
            item.setLayout(16896);
            infoForm.append(item);
            if (suiteInfo.midletSuite.isTrusted()) {
                infoForm.append(new ImageItem(null, DisplayManagerFactory.getDisplayManager().getTrustedMIDletIcon(), 0, null));
                temp = "Trusted";
            } else {
                temp = "Untrusted";
            }
            item = new StringItem(null, Resource.getString(temp));
            item.setLayout(16896);
            infoForm.append(item);
            temp = suiteInfo.midletSuite.getCA();
            if (temp != null) {
                label.setLength(0);
                label.append(Resource.getString("Authorized by"));
                label.append(": ");
                item = new StringItem(label.toString(), temp);
                item.setLayout(16896);
                infoForm.append(item);
            }
            if ((temp = PushRegistryImpl.listConnections(suiteInfo.midletSuite.getStorageName(), false)) != null) {
                label.setLength(0);
                label.append(Resource.getString("Auto start connections"));
                label.append(": ");
                item = new StringItem(label.toString(), temp);
                item.setLayout(16896);
                infoForm.append(item);
            }
        }
        catch (Exception ex) {
            value.setLength(0);
            value.append(suiteInfo.displayName);
            value.append("\n");
            value.append(Resource.getString("Exception"));
            value.append(": ");
            value.append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), value.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        infoForm.addCommand(this.backCmd);
        infoForm.setCommandListener(this);
        this.display.setCurrent(infoForm);
    }

    private void getApplicationSettings(MIDletSuiteInfo suiteInfo) {
        MIDletSuite midletSuite = suiteInfo.midletSuite;
        byte[][] ApiPermissions = suiteInfo.getPermissions();
        byte[] maxLevels = ApiPermissions[0];
        byte[] curLevels = ApiPermissions[1];
        String[] values = new String[1];
        this.initialSetting = null;
        this.numberOfSettings = 0;
        try {
            this.settings = new Form(Resource.getString("Settings"));
            this.settingsPopup = new RadioButtonSet(7, Resource.getString("Preferences"), true);
            suiteInfo.reloadSuite(this.installer);
            String name = suiteInfo.singleMidlet ? suiteInfo.displayName : suiteInfo.midletSuite.getProperty("MIDlet-Name");
            values[0] = name;
            int maxLevel = maxLevels[10] == 1 ? 4 : maxLevels[10];
            this.pushSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Interrupt", 3, "How often should %1 ask for permission to interrupt? The interrupted application will exit.", maxLevel, new byte[]{suiteInfo.getPushInterruptSetting()}, new int[]{0}, name, "Don't interrupt and don't ask");
            this.netSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Airtime", 0, "How often should %1 ask for permission to use airtime ? Using airtime may result in charges.", maxLevels[2], curLevels, Permissions.netAccessGroup, name, "Don't use airtime and don't ask");
            this.messagingSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Messaging", 1, "How often should %1 ask for permission before sending or receiving text messages? ", maxLevels[13], curLevels, Permissions.messagingGroup, name, "Don't send or receive messages and don't ask");
            this.recordingSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Recording", 4, "How often should %1 ask for permission to record audio and images? This will use space on your phone.", maxLevels[16], curLevels, Permissions.multimediaRecordingGroup, name, "Don't record and don't ask");
            this.commSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Computer Connection", 2, "How often should %1 ask for permission to connect to a computer? This may require a data cable that came with your phone.", maxLevels[9], curLevels, Permissions.localConnGroup, name, "Don't connect and don't ask");
            this.readUserDataSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Read User Access", 5, "How often should %1 ask for permission to access user data for reading? ", maxLevels[25], curLevels, Permissions.readUserDataGroup, name, "Don't access and don't ask");
            this.writeUserDataSetting = this.newPermissionChoiceSetting(this.settings, this.settingsPopup, "Write User Access", 6, "How often should %1 ask for permission to access user data for writing? ", maxLevels[26], curLevels, Permissions.writeUserDataGroup, name, "Don't access and don't ask");
            if (this.numberOfSettings > 1) {
                this.settings.append(this.settingsPopup);
            }
            if (this.initialSetting != null) {
                this.displayedSettingID = this.settings.append(this.initialSetting);
            }
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer();
            sb.append(suiteInfo.displayName);
            sb.append("\n");
            sb.append(Resource.getString("Exception"));
            sb.append(": ");
            sb.append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), sb.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        this.settings.addCommand(this.saveAppSettingsCmd);
        this.settings.addCommand(this.cancelCmd);
        this.settings.setCommandListener(this);
        this.settings.setItemStateListener(this);
        this.display.setCurrent(this.settings);
    }

    private void saveApplicationSettings(MIDletSuiteInfo suiteInfo) {
        MIDletSuite midletSuite = suiteInfo.midletSuite;
        byte[][] ApiPermissions = suiteInfo.getPermissions();
        byte[] maxLevels = ApiPermissions[0];
        byte[] curLevels = ApiPermissions[1];
        byte interruptSetting = this.getNewPermissionLevel(this.pushSetting, suiteInfo.getPushInterruptSetting());
        suiteInfo.setPushInterruptSetting(interruptSetting);
        Permissions.setPermissionGroup(curLevels, 10, this.getNewPermissionLevel(this.pushSetting, curLevels[10]));
        Permissions.setPermissionGroup(curLevels, 2, this.getNewPermissionLevel(this.netSetting, curLevels[2]));
        Permissions.setPermissionGroup(curLevels, 9, this.getNewPermissionLevel(this.commSetting, curLevels[9]));
        Permissions.setPermissionGroup(curLevels, 13, this.getNewPermissionLevel(this.messagingSetting, curLevels[13]));
        Permissions.setPermissionGroup(curLevels, 16, this.getNewPermissionLevel(this.recordingSetting, curLevels[16]));
        Permissions.setPermissionGroup(curLevels, 25, this.getNewPermissionLevel(this.readUserDataSetting, curLevels[25]));
        Permissions.setPermissionGroup(curLevels, 26, this.getNewPermissionLevel(this.writeUserDataSetting, curLevels[26]));
        try {
            Installer.saveSuiteSettings(suiteInfo.midletSuite.getStorageRoot(), suiteInfo.getPushInterruptSetting(), ApiPermissions, suiteInfo.midletSuite.isTrusted());
            this.displaySuccessMessage(Resource.getString("Saved!"));
        }
        catch (Exception ex) {
            Alert a = new Alert(Resource.getString("Exception"), ex.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
        }
    }

    byte getNewPermissionLevel(RadioButtonSet choice, int current) {
        if (choice == null) {
            return (byte)current;
        }
        return (byte)choice.getSelectedButton();
    }

    private void confirmRemove(MIDletSuiteInfo suiteInfo) {
        Form confirmForm;
        StringBuffer temp = new StringBuffer(40);
        String[] values = new String[1];
        try {
            confirmForm = new Form(null);
            confirmForm.setTitle(Resource.getString("Confirmation"));
            values[0] = suiteInfo.singleMidlet ? suiteInfo.displayName : suiteInfo.midletSuite.getProperty("MIDlet-Name");
            StringItem item = new StringItem(null, Resource.getString("Are you sure you want to remove %1?", values));
            item.setLayout(16896);
            confirmForm.append(item);
            String extraConfirmMsg = suiteInfo.midletSuite.getProperty("MIDlet-Delete-Confirm");
            if (extraConfirmMsg != null) {
                temp.setLength(0);
                temp.append(" \n");
                temp.append(extraConfirmMsg);
                item = new StringItem(null, temp.toString());
                item.setLayout(16896);
                confirmForm.append(item);
            }
            if (!suiteInfo.singleMidlet) {
                temp.setLength(0);
                temp.append(Resource.getString("This suite contains"));
                temp.append(": ");
                item = new StringItem(temp.toString(), "");
                item.setLayout(16896);
                confirmForm.append(item);
                this.appendMIDletsToForm(suiteInfo.midletSuite, confirmForm);
            }
            temp.setLength(0);
            temp.append(" \n");
            temp.append(Resource.getString("Once removed, %1 will have to be reinstalled.", values));
            item = new StringItem("", temp.toString());
            confirmForm.append(item);
        }
        catch (Exception ex) {
            temp.setLength(0);
            temp.append(suiteInfo.displayName);
            temp.append("\n");
            temp.append(Resource.getString("Exception"));
            temp.append(": ");
            temp.append(ex.toString());
            Alert a = new Alert(Resource.getString("Cannot access: "), temp.toString(), null, AlertType.ERROR);
            a.setTimeout(-2);
            this.display.setCurrent(a, this.mlist);
            return;
        }
        confirmForm.addCommand(this.cancelCmd);
        confirmForm.addCommand(this.removeOkCmd);
        confirmForm.setCommandListener(this);
        this.display.setCurrent(confirmForm);
    }

    private void appendMIDletsToForm(MIDletSuite midletSuite, Form form) {
        int numberOfMidlets = midletSuite.getNumberOfMIDlets();
        for (int i = 1; i <= numberOfMidlets; ++i) {
            MIDletInfo midletInfo = new MIDletInfo(midletSuite.getProperty("MIDlet-" + i));
            StringItem item = new StringItem(null, midletInfo.name);
            item.setLayout(16896);
            form.append(item);
        }
    }

    private void removeSuite(MIDletSuiteInfo suiteInfo) {
        this.installer.remove(suiteInfo.storageName);
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void updateSuite(MIDletSuiteInfo suiteInfo) {
        Scheduler.getScheduler().getMIDletSuite().addProperty("storageName", suiteInfo.midletSuite.getStorageName());
        this.installSuite();
    }

    private void installSuite() {
        Scheduler.getScheduler().scheduleMIDlet(new GraphicalInstaller());
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void displaySuccessMessage(String successMessage) {
        Image icon = GraphicalInstaller.getIconFromStorage(colorDisplay ? "_dukeok8.png" : "_dukeok2.png");
        Alert successAlert = new Alert(null, successMessage, icon, null);
        successAlert.setTimeout(1250);
        while (System.currentTimeMillis() - this.lastDisplayChange < 1250L) {
        }
        this.display.setCurrent(successAlert, this.mlist);
        this.lastDisplayChange = System.currentTimeMillis();
    }

    private void displayInstallAppWarning() {
        Alert a = new Alert(null, Resource.getString("This operation does not apply to Install Application because Install Application is part of the system on this device. Use Install Application to find and install applications."), null, AlertType.INFO);
        a.setTimeout(4000);
        this.display.setCurrent(a, this.mlist);
    }

    private RadioButtonSet newPermissionChoiceSetting(Form form, RadioButtonSet popup, String groupName, int groupID, String question, int maxLevel, byte[] curLevels, int[] functionGroup, String name, String denyAnswer) {
        int initValue;
        String[] values = new String[]{name};
        if (maxLevel == 1 || maxLevel == 0) {
            return null;
        }
        RadioButtonSet choice = new RadioButtonSet(4, Resource.getString(question, values), false);
        this.settingsPopup.append(Resource.getString(groupName), groupID);
        switch (maxLevel) {
            case 4: {
                choice.append(Resource.getString(BLANKET_ANSWER), 2);
            }
            case 8: {
                choice.append(Resource.getString(SESSION_ANSWER), 8);
            }
        }
        choice.append(Resource.getString(ONESHOT_ANSWER), 16);
        choice.append(Resource.getString(denyAnswer), -128);
        switch (this.getCurLevel(curLevels, functionGroup)) {
            case 2: 
            case 4: {
                initValue = 2;
                break;
            }
            case 8: 
            case 32: {
                initValue = 8;
                break;
            }
            case 16: 
            case 64: {
                initValue = 16;
                break;
            }
            default: {
                initValue = -128;
            }
        }
        try {
            choice.setDefaultButton(initValue);
        }
        catch (IndexOutOfBoundsException e) {
            choice.setDefaultButton(-128);
        }
        choice.setPreferredSize(form.getWidth(), -1);
        if (this.initialSetting == null) {
            this.initialSetting = choice;
            this.lastPopupChoice = groupID;
        }
        ++this.numberOfSettings;
        return choice;
    }

    private int getCurLevel(byte[] curLevels, int[] functionGroup) {
        int ret = 0;
        for (int i = 0; i < functionGroup.length; ++i) {
            if (curLevels[functionGroup[i]] == 0) continue;
            ret = curLevels[functionGroup[i]];
            break;
        }
        return ret;
    }

    public void itemStateChanged(Item item) {
        if (item != this.settingsPopup) {
            return;
        }
        int selected = this.settingsPopup.getSelectedButton();
        if (selected == this.lastPopupChoice) {
            return;
        }
        this.lastPopupChoice = selected;
        this.settings.delete(this.displayedSettingID);
        switch (selected) {
            case 0: {
                this.displayedSettingID = this.settings.append(this.netSetting);
                break;
            }
            case 1: {
                this.displayedSettingID = this.settings.append(this.messagingSetting);
                break;
            }
            case 2: {
                this.displayedSettingID = this.settings.append(this.commSetting);
                break;
            }
            case 3: {
                this.displayedSettingID = this.settings.append(this.pushSetting);
                break;
            }
            case 4: {
                this.displayedSettingID = this.settings.append(this.recordingSetting);
                break;
            }
            case 5: {
                this.displayedSettingID = this.settings.append(this.readUserDataSetting);
                break;
            }
            case 6: {
                this.displayedSettingID = this.settings.append(this.writeUserDataSetting);
            }
        }
    }

    static {
        first = true;
    }

    private class MIDletSuiteInfo {
        MIDletSuite midletSuite;
        String storageName;
        String displayName;
        String midletToRun;
        Image icon;
        boolean singleMidlet = false;
        private byte[][] permissions;
        private byte pushInterruptSetting = (byte)-1;

        MIDletSuiteInfo(String theStorageName, MIDletSuite theMidletSuite) {
            this.midletSuite = theMidletSuite;
            this.displayName = this.midletSuite.getProperty("MIDlet-Name");
            if (this.displayName == null) {
                this.displayName = theStorageName;
            }
            this.icon = Manager.getSuiteIcon();
            this.storageName = theStorageName;
        }

        MIDletSuiteInfo(String theStorageName, MIDletSuite theMidletSuite, String attr) {
            this(theStorageName, theMidletSuite);
            if (attr != null) {
                MIDletInfo midletInfo = new MIDletInfo(attr);
                if (midletInfo.name != null) {
                    this.displayName = midletInfo.name;
                }
            }
        }

        public void reloadSuite(Installer installer) {
            this.midletSuite = installer.getMIDletSuite(this.midletSuite.getStorageName());
            this.permissions = null;
            this.pushInterruptSetting = (byte)-1;
        }

        public byte[][] getPermissions() {
            if (this.permissions == null) {
                this.permissions = this.midletSuite.getPermissions();
            }
            return this.permissions;
        }

        public void setPushInterruptSetting(byte setting) {
            this.pushInterruptSetting = setting;
        }

        public byte getPushInterruptSetting() {
            if (this.pushInterruptSetting == -1) {
                this.pushInterruptSetting = (byte)this.midletSuite.getPushInterruptSetting();
            }
            return this.pushInterruptSetting;
        }
    }
}

