/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim.formats;

import com.sun.kvem.midp.pim.ContactImpl;
import com.sun.kvem.midp.pim.LineReader;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.PIMHandler;
import com.sun.kvem.midp.pim.UnsupportedPIMFormatException;
import com.sun.kvem.midp.pim.formats.Base64Encoding;
import com.sun.kvem.midp.pim.formats.EndMatcher;
import com.sun.kvem.midp.pim.formats.FormatSupport;
import com.sun.kvem.midp.pim.formats.VCardSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.microedition.pim.Contact;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

public abstract class VCardFormat
extends EndMatcher
implements PIMFormat {
    protected abstract String getVersion();

    protected abstract String getCategoryProperty();

    protected abstract String getClassProperty();

    protected abstract int parseAttributes(String[] var1);

    protected abstract String getBinaryEncodingName();

    public VCardFormat() {
        super("VCARD");
    }

    public String getName() {
        return "VCARD/" + this.getVersion();
    }

    public boolean isTypeSupported(int pimListType) {
        return pimListType == 1;
    }

    public void encode(OutputStream out, String encoding, PIMItem pimItem) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, encoding);
        w.write("BEGIN:VCARD\r\n");
        w.write("VERSION:");
        w.write(this.getVersion());
        w.write("\r\n");
        int[] fields = pimItem.getFields();
        FormatSupport.sort(fields);
        PIMList list = pimItem.getPIMList();
        for (int i = 0; i < fields.length; ++i) {
            int valueCount = pimItem.countValues(fields[i]);
            for (int j = 0; j < valueCount; ++j) {
                this.writeValue(w, pimItem, fields[i], j);
            }
        }
        String categories = FormatSupport.join(pimItem.getCategories(), ",");
        if (categories.length() > 0) {
            w.write(this.getCategoryProperty());
            w.write(":");
            w.write(categories);
            w.write("\r\n");
        }
        w.write("END:VCARD\r\n");
        ((Writer)w).flush();
    }

    protected void writeValue(Writer w, PIMItem item, int field, int index) throws IOException {
        String label = VCardSupport.getFieldLabel(field);
        switch (field) {
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                String sValue = item.getString(field, index);
                if (sValue == null) break;
                w.write(label);
                this.writeAttributes(w, item.getAttributes(field, index));
                w.write(":");
                w.write(sValue);
                w.write("\r\n");
                break;
            }
            case 100: 
            case 106: {
                String[] aValue = item.getStringArray(field, index);
                if (aValue == null) break;
                w.write(label);
                this.writeAttributes(w, item.getAttributes(field, index));
                w.write(":");
                this.writeStringArray(w, aValue);
                w.write("\r\n");
                break;
            }
            case 110: 
            case 112: {
                byte[] bValue = item.getBinary(field, index);
                if (bValue == null) break;
                w.write(label);
                w.write(";ENCODING=");
                w.write(this.getBinaryEncodingName());
                this.writeAttributes(w, item.getAttributes(field, index));
                w.write(":\r\n    ");
                w.write(Base64Encoding.toBase64(bValue, 76, 4));
                w.write("\r\n");
                break;
            }
            case 101: 
            case 114: {
                w.write(label);
                this.writeAttributes(w, item.getAttributes(field, index));
                w.write(":");
                this.writeDate(w, item.getDate(field, index));
                w.write("\r\n");
                break;
            }
            case 102: {
                int iValue = item.getInt(field, index);
                String sValue = VCardSupport.getClassType(iValue);
                if (sValue == null) break;
                w.write(this.getClassProperty());
                this.writeAttributes(w, item.getAttributes(field, index));
                w.write(":");
                w.write(sValue);
                w.write("\r\n");
                break;
            }
        }
    }

    protected void writeStringArray(Writer w, String[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null) {
                w.write(data[i]);
            }
            if (i == data.length - 1) continue;
            w.write(59);
        }
    }

    protected void writeDate(Writer w, long date) throws IOException {
        w.write(PIMHandler.getInstance().composeDate(date));
    }

    protected abstract void writeAttributes(Writer var1, int var2) throws IOException;

    public PIMItem[] decode(InputStream in, String encoding, PIMList list) throws IOException {
        LineReader r = new LineReader(in, encoding, (LineReader.Matcher)this);
        ContactImpl contact = this.decode(r);
        if (contact == null) {
            return null;
        }
        return new ContactImpl[]{contact};
    }

    private ContactImpl decode(LineReader in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            return null;
        }
        if (!line.toUpperCase().equals("BEGIN:VCARD")) {
            throw new UnsupportedPIMFormatException("Not a vCard :'" + line + "'");
        }
        String categoryProperty = this.getCategoryProperty();
        ContactImpl contact = new ContactImpl(null);
        while ((line = in.readLine()) != null) {
            FormatSupport.DataElement element = FormatSupport.parseObjectLine(line);
            if (element.propertyName.equals("END")) {
                return contact;
            }
            if (element.propertyName.equals("VERSION")) {
                if (element.data.equals(this.getVersion())) continue;
                throw new UnsupportedPIMFormatException("Version " + element.data + " not supported");
            }
            if (element.propertyName.equals(categoryProperty)) {
                String[] categories = FormatSupport.split(element.data, ',', 0);
                for (int j = 0; j < categories.length; ++j) {
                    try {
                        contact.addToCategory(categories[j]);
                        continue;
                    }
                    catch (PIMException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            this.importData(contact, element.propertyName, element.attributes, element.data);
        }
        throw new IOException("Unterminated vCard");
    }

    private void importData(Contact contact, String prefix, String[] attributes, String data) {
        int attr = this.parseAttributes(attributes);
        int field = VCardSupport.getFieldCode(prefix);
        if (field == -1 && prefix.equals(this.getClassProperty())) {
            field = 102;
        }
        if (!PIMHandler.getInstance().isSupportedField(1, field)) {
            return;
        }
        switch (field) {
            case 103: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                String sdata = FormatSupport.parseString(attributes, data);
                contact.addString(field, attr, sdata);
                break;
            }
            case 100: 
            case 106: {
                String[] elements = FormatSupport.parseStringArray(attributes, data);
                int elementCount = PIMHandler.getInstance().getStringArraySize(1, field);
                if (elements.length != elementCount) {
                    String[] a = new String[elementCount];
                    System.arraycopy(elements, 0, a, 0, Math.min(elements.length, elementCount));
                    elements = a;
                }
                contact.addStringArray(field, attr, elements);
                break;
            }
            case 101: 
            case 114: {
                long date = PIMHandler.getInstance().parseDate(data);
                contact.addDate(field, attr, date);
                break;
            }
            case 110: {
                String valueType = FormatSupport.getAttributeValue(attributes, "VALUE=", null);
                if (valueType == null) {
                    byte[] bdata = FormatSupport.parseBinary(attributes, data);
                    if (bdata.length == 0) break;
                    contact.addBinary(110, attr, bdata, 0, bdata.length);
                    break;
                }
                if (!valueType.equals("URL")) break;
                String sdata = FormatSupport.parseString(attributes, data);
                contact.addString(111, attr, sdata);
                break;
            }
            case 112: {
                String encoding = FormatSupport.getEncoding(attributes);
                if (encoding.equals("PLAIN_TEXT")) {
                    String sdata = FormatSupport.parseString(attributes, data);
                    contact.addString(113, attr, sdata);
                    break;
                }
                byte[] bdata = FormatSupport.parseBinary(attributes, data);
                if (bdata.length == 0) break;
                contact.addBinary(112, attr, bdata, 0, bdata.length);
                break;
            }
            case 102: {
                int i = VCardSupport.getClassCode(data);
                if (i == -1) break;
                contact.addInt(102, 0, i);
                break;
            }
        }
    }
}

