/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMItem;
import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.ToDoListImpl;
import com.sun.kvem.midp.pim.formats.VCalendar10Format;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.ToDo;

public class ToDoImpl
extends AbstractPIMItem
implements ToDo {
    public ToDoImpl(ToDoListImpl list) {
        super((AbstractPIMList)list, 3);
    }

    ToDoImpl(ToDoListImpl list, ToDo base) {
        super((AbstractPIMList)list, (PIMItem)base);
    }

    PIMFormat getEncodingFormat() {
        return new VCalendar10Format();
    }

    static boolean isValidPIMField(int field) {
        switch (field) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public void addInt(int field, int attributes, int value) {
        switch (field) {
            case 100: {
                this.validateClass(value);
                break;
            }
            case 105: {
                this.validatePriority(value);
            }
        }
        super.addInt(field, attributes, value);
    }

    public void setInt(int field, int index, int attributes, int value) {
        switch (field) {
            case 100: {
                this.validateClass(value);
                break;
            }
            case 105: {
                this.validatePriority(value);
            }
        }
        super.setInt(field, index, attributes, value);
    }

    private void validateClass(int value) {
        switch (value) {
            case 200: 
            case 201: 
            case 202: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid CLASS value: " + value);
    }

    private void validatePriority(int value) {
        if (value < 0 || value > 9) {
            throw new IllegalArgumentException("Invalid PRIORITY value: " + value);
        }
    }

    protected int getRevisionField() {
        return 106;
    }

    protected int getUIDField() {
        return 108;
    }

    protected String toDisplayableString() {
        return "ToDo[" + this.formatData() + "]";
    }
}

