/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ObexAuth;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.obex.HeaderSet;

public class HeaderSetImpl
implements HeaderSet {
    private static final boolean DEBUG = false;
    public static final int OWNER_SERVER = 1;
    public static final int OWNER_CLIENT = 2;
    public static final int OWNER_SERVER_USER = 3;
    public static final int OWNER_CLIENT_USER = 4;
    static final int TYPE_UNICODE = 0;
    static final int TYPE_BYTEARRAY = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_LONG = 3;
    static final int TYPE_SPECIAL_TIME_4 = 4;
    static final int TYPE_SPECIAL_TIME_ISO = 5;
    static final int TYPE_SPECIAL_TYPE = 6;
    static final int TYPE_UNSUPPORTED = 7;
    static final int TYPE_AUTH_CHALLENGE = 8;
    static final int TYPE_AUTH_RESPONSE = 9;
    int owner;
    int packetType;
    private Hashtable headers;
    Vector challenges = new Vector();

    public HeaderSetImpl(int owner) {
        this.owner = owner;
        this.headers = new Hashtable(5);
    }

    void merge(HeaderSetImpl h) {
        int[] idList = h.getHeaderList();
        if (idList == null) {
            return;
        }
        block5: for (int i = 0; i < idList.length; ++i) {
            int id = idList[i];
            Object val = h.getHeader(id);
            int type = HeaderSetImpl.internalType(id);
            switch (type) {
                case 0: 
                case 2: 
                case 3: 
                case 6: {
                    this.setHeader(id, val);
                    continue block5;
                }
                case 1: {
                    byte[] array = (byte[])val;
                    byte[] copy = new byte[array.length];
                    System.arraycopy(array, 0, copy, 0, array.length);
                    this.setHeader(id, copy);
                    continue block5;
                }
                case 4: 
                case 5: {
                    Calendar cal = (Calendar)val;
                    Calendar calCopy = Calendar.getInstance();
                    calCopy.setTime(cal.getTime());
                    this.setHeader(id, calCopy);
                    continue block5;
                }
            }
        }
    }

    HeaderSetImpl(HeaderSetImpl h) {
        this.packetType = h.packetType;
        this.owner = h.owner;
        this.headers = new Hashtable(5);
        this.merge(h);
    }

    boolean isSendable() {
        return this.owner >= 3;
    }

    public void createAuthenticationChallenge(String realm, boolean userID, boolean access) {
        ObexAuth auth = ObexAuth.createChallenge(realm, userID, access);
        this.challenges.addElement(auth);
    }

    public Object getHeader(int headerID) {
        Object value = this.headers.get(new Integer(headerID));
        if (value != null) {
            return value;
        }
        int type = HeaderSetImpl.internalType(headerID);
        if (type >= 7) {
            throw new IllegalArgumentException("bad header id");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHeaderList() {
        Hashtable hashtable = this.headers;
        synchronized (hashtable) {
            if (this.headers.isEmpty()) {
                return null;
            }
            Enumeration keys = this.headers.keys();
            int[] ids = new int[this.headers.size()];
            int i = 0;
            while (keys.hasMoreElements()) {
                Object obj = keys.nextElement();
                ids[i++] = (Integer)obj;
            }
            return ids;
        }
    }

    public int getResponseCode() throws IOException {
        if (this.owner != 2) {
            throw new IOException("invalid use");
        }
        if (this.packetType == 144) {
            throw new IOException("operation not finished");
        }
        return this.packetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(int headerID, Object headerValue) {
        int type = HeaderSetImpl.internalType(headerID);
        String errormsg = "incompatible header object";
        if (type >= 7) {
            throw new IllegalArgumentException("bad header id");
        }
        if (headerValue == null) {
            Hashtable hashtable = this.headers;
            synchronized (hashtable) {
                this.headers.remove(new Integer(headerID));
            }
            return;
        }
        boolean fail = false;
        switch (type) {
            case 0: {
                if (headerValue instanceof String) break;
                fail = true;
                break;
            }
            case 1: {
                if (headerValue instanceof byte[]) break;
                fail = true;
                break;
            }
            case 2: {
                if (headerValue instanceof Byte) break;
                fail = true;
                break;
            }
            case 3: {
                if (!(headerValue instanceof Long)) {
                    fail = true;
                    break;
                }
                long value = (Long)headerValue;
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                errormsg = "long value out of range 0 .. 0xFFFFFFFF";
                fail = true;
                break;
            }
            case 4: {
                if (headerValue instanceof Calendar) break;
                fail = true;
                break;
            }
            case 5: {
                if (headerValue instanceof Calendar) break;
                fail = true;
                break;
            }
            case 6: {
                if (headerValue instanceof String) break;
                fail = true;
            }
        }
        if (fail) {
            throw new IllegalArgumentException(errormsg);
        }
        Hashtable hashtable = this.headers;
        synchronized (hashtable) {
            this.headers.put(new Integer(headerID), headerValue);
        }
    }

    static final int internalType(int headerID) {
        if ((headerID & 0xFFFFFF00) != 0) {
            return 7;
        }
        if ((headerID & 0x30) == 48) {
            return headerID >> 6;
        }
        switch (headerID) {
            case 68: {
                return 5;
            }
            case 196: {
                return 4;
            }
            case 66: {
                return 6;
            }
            case 192: 
            case 195: {
                return 3;
            }
            case 1: 
            case 5: {
                return 0;
            }
            case 70: 
            case 71: 
            case 74: 
            case 76: 
            case 79: {
                return 1;
            }
            case 77: {
                return 8;
            }
            case 78: {
                return 9;
            }
        }
        return 7;
    }
}

