/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import java.io.IOException;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;

class SecurityState {
    private static final boolean DEBUG = false;
    private int lock;
    private int waitingRequests;
    private RemoteDeviceImpl remoteDevice;
    private int encryptedConn;
    private int numConn;
    private boolean isAuthenticated;
    private boolean isEncrypted;
    private boolean forceMaster;
    private boolean master;
    private static Hashtable table = new Hashtable();
    private static final int STATE_IDLE = 0;
    private static final int STATE_REQUEST = 1;
    private static final int STATE_REQUEST_FAILED = 2;
    private BluetoothController control;

    SecurityState(RemoteDeviceImpl remoteDevice) {
        String localAddr;
        try {
            localAddr = LocalDevice.getLocalDevice().getBluetoothAddress();
        }
        catch (BluetoothStateException e) {
            localAddr = "";
        }
        String remoteAddr = remoteDevice.getBluetoothAddress();
        this.master = localAddr.compareTo(remoteAddr) > 0;
        this.remoteDevice = remoteDevice;
        this.control = BluetoothController.getInstance();
    }

    public static synchronized SecurityState getSecurityState(RemoteDeviceImpl remoteDevice) {
        SecurityState sstate = (SecurityState)table.get((Object)remoteDevice);
        if (sstate == null) {
            sstate = new SecurityState(remoteDevice);
            table.put(remoteDevice, sstate);
        }
        return sstate;
    }

    public void addConnection(BluetoothConnection conn) {
        ++this.numConn;
    }

    public void removeConnection(BluetoothConnection conn) {
        --this.numConn;
    }

    private synchronized void startRequest() {
        SecurityState.msg("startRequest()");
        ++this.waitingRequests;
        while (this.lock != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lock = 1;
        --this.waitingRequests;
        SecurityState.msg("startRequest(): started");
    }

    private synchronized boolean resetRequest() {
        SecurityState.msg("resetRequest()");
        if (this.master) {
            if (this.lock == 0) {
                SecurityState.msg("resetRequest(): true");
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SecurityState.msg("resetRequest(): false");
            return false;
        }
        if (this.lock == 1) {
            this.lock = 2;
            this.notifyAll();
        }
        SecurityState.msg("resetRequest(): true");
        return true;
    }

    private synchronized boolean endRequest() {
        SecurityState.msg("endRequest()");
        if (this.lock == 2) {
            this.lock = 0;
            SecurityState.msg("endRequest(): false");
            return false;
        }
        this.lock = 0;
        this.notifyAll();
        SecurityState.msg("endRequest(): true");
        return true;
    }

    synchronized void waitSecurityExchange() {
        while (this.lock != 0 && this.waitingRequests == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        SecurityState.msg("waitSecurityExchange(): done");
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate() throws IOException {
        while (true) {
            boolean authenticated;
            if (this.numConn == 0) {
                throw new IOException("no active connections to the device");
            }
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                authenticated = this.isAuthenticated;
            }
            if (authenticated) {
                this.endRequest();
                return true;
            }
            try {
                authenticated = SecurityListener.sendCommand(this.remoteDevice, 2, true);
            }
            catch (BluetoothStateException e) {
                this.endRequest();
                continue;
            }
            catch (IOException e) {
                this.endRequest();
                throw e;
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    this.isAuthenticated = authenticated;
                    return this.isAuthenticated;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encrypt(BluetoothConnection btconn, boolean on) throws IOException {
        if (this.control.forceNoEncrypt) {
            return !on;
        }
        if (on && !this.authenticate()) {
            return false;
        }
        while (true) {
            int encryptedConn;
            boolean encrypted;
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                encrypted = this.isEncrypted;
                encryptedConn = this.encryptedConn;
            }
            if (btconn.isEncrypted() == on) {
                this.endRequest();
                return true;
            }
            btconn.setEncrypted(on);
            encryptedConn = on ? ++encryptedConn : --encryptedConn;
            if (encrypted == (encryptedConn != 0)) {
                securityState = this;
                synchronized (securityState) {
                    if (this.endRequest()) {
                        this.encryptedConn = encryptedConn;
                        return true;
                    }
                    btconn.setEncrypted(!on);
                }
            }
            try {
                encrypted = SecurityListener.sendCommand(this.remoteDevice, 1, on);
            }
            catch (BluetoothStateException e) {
                btconn.setEncrypted(!on);
                this.endRequest();
                continue;
            }
            catch (IOException e) {
                btconn.setEncrypted(!on);
                this.endRequest();
                throw e;
            }
            if (encrypted == on) {
                securityState = this;
                synchronized (securityState) {
                    if (this.endRequest()) {
                        this.encryptedConn = encryptedConn;
                        this.isEncrypted = encrypted;
                        return true;
                    }
                    btconn.setEncrypted(!on);
                }
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    if (on) {
                        btconn.setEncrypted(false);
                    } else {
                        this.encryptedConn = encryptedConn;
                    }
                    return false;
                }
                btconn.setEncrypted(!on);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMaster() throws IOException {
        while (true) {
            boolean forceMaster;
            SecurityState securityState = this;
            synchronized (securityState) {
                this.startRequest();
                forceMaster = this.forceMaster;
            }
            if (forceMaster) {
                this.endRequest();
                return true;
            }
            try {
                forceMaster = SecurityListener.sendCommand(this.remoteDevice, 3, true);
            }
            catch (BluetoothStateException e) {
                this.endRequest();
                continue;
            }
            catch (IOException e) {
                this.endRequest();
                throw e;
            }
            securityState = this;
            synchronized (securityState) {
                if (this.endRequest()) {
                    this.forceMaster = forceMaster;
                    return forceMaster;
                }
            }
        }
    }

    synchronized boolean remoteRequestForEncrypt(boolean enable) throws BluetoothStateException {
        if (this.resetRequest()) {
            this.isEncrypted = !this.control.forceNoEncrypt && (enable || this.control.forceEncrypt || this.encryptedConn != 0);
            return this.isEncrypted;
        }
        throw new BluetoothStateException("request ignored");
    }

    synchronized boolean remoteRequestForAuthenticate(byte[] remotePinCode) throws BluetoothStateException {
        if (this.resetRequest()) {
            if (this.isAuthenticated) {
                return true;
            }
            byte[] pinCode = this.control.getDevicePinCode();
            if (pinCode.length != remotePinCode.length) {
                return false;
            }
            for (int i = 0; i < pinCode.length; ++i) {
                if (pinCode[i] == remotePinCode[i]) continue;
                return false;
            }
            this.isAuthenticated = true;
            return true;
        }
        throw new BluetoothStateException("request ignored");
    }

    synchronized boolean remoteRequestForMaster() throws BluetoothStateException {
        if (this.resetRequest()) {
            return !this.forceMaster;
        }
        throw new BluetoothStateException("request ignored");
    }

    private static final void msg(String msg) {
    }
}

