/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public final class NetmonBluetooth {
    private static native void updateServiceRecord(int var0, byte[] var1, int var2, int var3);

    public static void notifierUpdateServiceRecord(int netmonId, ServiceRecord rec) {
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(o);
            int[] ids = rec.getAttributeIDs();
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                out.writeInt(id);
                NetmonBluetooth.write(out, rec.getAttributeValue(id));
            }
            byte[] array = o.toByteArray();
            NetmonBluetooth.updateServiceRecord(netmonId, array, 0, array.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void write(DataOutputStream out, DataElement el) throws IOException {
        int type = el.getDataType();
        out.writeInt(type);
        switch (type) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                out.writeLong(el.getLong());
                break;
            }
            case 40: {
                out.writeBoolean(el.getBoolean());
                break;
            }
            case 11: 
            case 12: 
            case 20: {
                byte[] data = (byte[])el.getValue();
                out.write(data);
                break;
            }
            case 0: {
                break;
            }
            case 32: 
            case 64: {
                out.writeUTF((String)el.getValue());
                break;
            }
            case 24: {
                out.writeUTF(((UUID)el.getValue()).toString());
                break;
            }
            case 48: 
            case 56: {
                Enumeration e = (Enumeration)el.getValue();
                while (e.hasMoreElements()) {
                    NetmonBluetooth.write(out, (DataElement)e.nextElement());
                }
                out.writeInt(-1);
            }
        }
    }
}

