/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTHandlerBase;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.DataElement;
import javax.bluetooth.UUID;

public abstract class BTNotifierBase
extends BTHandlerBase
implements BluetoothNotifier {
    protected static final DataElement DE_L2CAP_UUID = new DataElement(24, (Object)new UUID(256L));
    protected static final DataElement DE_RFCOMM_UUID = new DataElement(24, (Object)new UUID(3L));
    protected static final DataElement DE_OBEX_UUID = new DataElement(24, (Object)new UUID(8L));
    protected static final DataElement DE_SERIAL_PORT_UUID = new DataElement(24, (Object)new UUID(4353L));
    protected static final int SERVICE_HANDLE_ATTR_ID = 0;
    protected static final int SERVICE_CLASS_ATTR_ID = 1;
    protected static final int PROTOCOL_ATTR_ID = 4;
    protected static final int NAME_ATTR_ID = 256;
    protected UUID serverUUID;
    protected ServiceRecordImpl serRec;
    protected Object serRecLock = new Object();
    protected DataElement protocolListMC;
    protected JSR082Notifier notif;
    protected boolean master;
    protected boolean authorize;
    protected boolean authenticate;
    protected boolean encrypt;
    protected boolean isSystemUse;

    protected static void checkRecord(ServiceRecordImpl rec, DataElement sample) {
        String msg = null;
        if (rec.getAttributeValue(0) == null) {
            msg = "missed service handle attribue";
            throw new IllegalArgumentException(msg);
        }
        if (rec.getAttributeValue(1) == null) {
            msg = "missed service class attribue";
            throw new IllegalArgumentException(msg);
        }
        DataElement proto = rec.getAttributeValue(4);
        if (proto == null) {
            msg = "missed protocol description list attribue";
            throw new IllegalArgumentException(msg);
        }
        msg = "wrong protocol description list attribue";
        if (proto.getDataType() != 48) {
            throw new IllegalArgumentException(msg);
        }
        Vector protoVec = BTNotifierBase.enum2vector(null, (Enumeration)proto.getValue());
        Enumeration sampleEnum = (Enumeration)sample.getValue();
        while (sampleEnum.hasMoreElements()) {
            DataElement de = (DataElement)sampleEnum.nextElement();
            if (BTNotifierBase.checkContains(de, protoVec)) continue;
            msg = "wrong protocol description list attribue";
            throw new IllegalArgumentException(msg);
        }
    }

    protected static ServiceRecordImpl copyRecord(BTNotifierBase parent, ServiceRecordImpl src) {
        ServiceRecordImpl dst = new ServiceRecordImpl(parent, src.getHandle());
        dst.setDeviceServiceClasses(src.getDeviceServiceClasses());
        int[] attrIDs = src.getAttributeIDs();
        for (int i = 0; i < attrIDs.length; ++i) {
            if (attrIDs[i] == 0) continue;
            DataElement value = src.getAttributeValue(attrIDs[i]);
            dst.setAttributeValue(attrIDs[i], value);
        }
        return dst;
    }

    private static boolean checkContains(DataElement sample, Vector main) {
        if (sample.getDataType() != 48) {
            return main.removeElement(sample);
        }
        Enumeration sampleEnum = (Enumeration)sample.getValue();
        Vector tmpVector = new Vector();
        while (sampleEnum.hasMoreElements()) {
            boolean res = false;
            DataElement childDE = (DataElement)sampleEnum.nextElement();
            for (int i = 0; i < main.size(); ++i) {
                DataElement de = (DataElement)main.elementAt(i);
                if (de.getDataType() != 48) continue;
                BTNotifierBase.enum2vector(tmpVector, (Enumeration)de.getValue());
                if (!BTNotifierBase.checkContains(childDE, tmpVector)) continue;
                res = true;
                break;
            }
            if (res) continue;
            return false;
        }
        return true;
    }

    private static Vector enum2vector(Vector dst, Enumeration src) {
        if (dst == null) {
            dst = new Vector();
        } else {
            dst.removeAllElements();
        }
        while (src.hasMoreElements()) {
            dst.addElement(src.nextElement());
        }
        return dst;
    }

    protected abstract void initServerNotifier(JSR082Notifier var1, int var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7) throws IOException, BluetoothConnectionException;
}

