/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.Utilites;
import java.io.IOException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;

class BTDeviceDiscoverer
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String cn = "BTDeviceDiscoverer";
    private static final int DISCOVERING_RETRY_TIME = 50;
    private static final int STATE_READY = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_CANCELED = 4;
    private int state = 1;
    private DiscoveryAgentImpl agent;
    private DiscoveryListener listener;
    private int accessCode;
    private int discoveryTimeout;

    BTDeviceDiscoverer() {
    }

    public void run() {
        String addrsStr;
        block12: {
            long start_time = System.currentTimeMillis();
            StringBuffer args = new StringBuffer("discoverBTDevices");
            args.append('\n').append(Integer.toString(this.accessCode)).append('\n');
            addrsStr = null;
            do {
                try {
                    addrsStr = JSR082Controller.processCommand(2, args.toString());
                }
                catch (IOException e) {
                    this.notifyDone(7);
                    return;
                }
                if (this.checkCanceled()) {
                    return;
                }
                if (addrsStr != null) break block12;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - start_time < (long)this.discoveryTimeout);
            this.notifyDone(0);
            return;
        }
        String[] addrsArr = Utilites.splitString(addrsStr, ',');
        for (int i = 0; i < addrsArr.length; ++i) {
            if (this.checkCanceled()) {
                return;
            }
            RemoteDeviceImpl rem_dev = null;
            DeviceClass rem_rec = null;
            try {
                int index = addrsArr[i].indexOf(58);
                String addr = addrsArr[i].substring(0, index);
                rem_dev = this.agent.getRemoteDevice(addr);
                int rec = Integer.parseInt(addrsArr[i].substring(index + 1));
                rem_rec = new DeviceClass(rec);
            }
            catch (Throwable e) {
                System.err.println("Internal Error: wrong dev disc information: " + addrsArr[i]);
                this.notifyDone(7);
                return;
            }
            try {
                this.listener.deviceDiscovered((RemoteDevice)rem_dev, rem_rec);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.notifyDone(0);
    }

    void initialize(int discoveryTimeout) {
        this.discoveryTimeout = discoveryTimeout;
    }

    synchronized void startDiscover(DiscoveryAgentImpl agent, DiscoveryListener listener, int accessCode) {
        if (this.state != 1) {
            throw new RuntimeException("Internal error: wrong device discoverer state: " + this.state);
        }
        this.agent = agent;
        this.listener = listener;
        this.accessCode = accessCode;
        this.state = 2;
        new Thread(this).start();
    }

    synchronized void cancelDiscover() {
        if (this.state != 2) {
            throw new RuntimeException("Internal error: wrong device discoverer state: " + this.state);
        }
        this.state = 4;
    }

    private synchronized boolean checkCanceled() {
        if (this.state != 4) {
            return false;
        }
        this.notifyDone(5);
        return true;
    }

    private synchronized void notifyDone(int discType) {
        this.state = 1;
        try {
            this.listener.inquiryCompleted(discType);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.agent.inquiryCompleted();
    }
}

