/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.DataL2CAPReaderWriter;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.DataElement;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.UUID;

class SDPClient {
    private static final int MAX_SERVICE_RECORD_COUNT = 4095;
    private static final int MAX_ATTRIBUTE_BYTE_COUNT = 65535;
    private static final int firstTransactionID = 16;
    private static final int maxTransactionID = 65535;
    private static int currentTransactionID = 16;
    private static Hashtable transportsStorage = new Hashtable();
    private static Hashtable counters = new Hashtable();
    private SDPTransport transport;
    private String bluetoothAddress;

    SDPClient() {
    }

    SDPClient(String bluetoothAddress) throws IOException {
        this.open(bluetoothAddress);
    }

    static synchronized short newTransactionID() {
        int transactionID = currentTransactionID++;
        if (currentTransactionID > 65535) {
            currentTransactionID = 16;
        }
        return (short)transactionID;
    }

    static synchronized void freeTransactionID(short transactionID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SDPTransport openTransport(String address) throws IOException {
        SDPTransport transport;
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            transport = (SDPTransport)transportsStorage.get(address);
            Counter counter = (Counter)counters.get(address);
            if (transport == null) {
                transport = new SDPTransport(address);
                transportsStorage.put(address, transport);
                counter = new Counter();
                counters.put(address, counter);
            }
            ++counter.counter;
        }
        transport.start();
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTransport(String address) throws IOException {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport transport = (SDPTransport)transportsStorage.get(address);
            Counter counter = (Counter)counters.get(address);
            if (transport == null) {
                throw new IOException("transport is closed");
            }
            ++counter.counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopTransport(String address) throws IOException {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport transport = (SDPTransport)transportsStorage.get(address);
            Counter counter = (Counter)counters.get(address);
            if (transport == null) {
                throw new IOException("transport is closed");
            }
            --counter.counter;
            if (counter.counter == 0) {
                transportsStorage.remove(address);
                counters.remove(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeTransport(String address) throws IOException {
        SDPTransport transport;
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            transport = (SDPTransport)transportsStorage.get(address);
            Counter counter = (Counter)counters.get(address);
            if (transport == null) {
                throw new IOException("transport is closed");
            }
            --counter.counter;
            if (counter.counter == 0) {
                transportsStorage.remove(address);
                counters.remove(address);
            }
        }
        transport.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTransport(String address) {
        Hashtable hashtable = transportsStorage;
        synchronized (hashtable) {
            SDPTransport transport = (SDPTransport)transportsStorage.remove(address);
            counters.remove(address);
        }
    }

    synchronized void open(String address) throws IOException {
        if (this.bluetoothAddress == null) {
            this.bluetoothAddress = address;
        } else if (!this.bluetoothAddress.equals(address)) {
            throw new IOException("The SDP Connection has been opened with the other bluetooth address");
        }
        this.transport = SDPClient.openTransport(address);
    }

    synchronized void close() throws IOException {
        SDPClient.closeTransport(this.bluetoothAddress);
        this.transport = null;
        this.bluetoothAddress = null;
    }

    void serviceSearchRequest(UUID[] uuidSet, int transactionID, SDPResponseListener listener) throws IOException {
        try {
            this.transport.serviceSearchRequest(uuidSet, transactionID, listener);
        }
        catch (IOException ioe) {
            this.transport.cancelAll(65536);
            throw ioe;
        }
    }

    void serviceAttributeRequest(int serviceRecordHandle, int[] attrSet, int transactionID, SDPResponseListener listener) throws IOException {
        try {
            this.transport.serviceAttributeRequest(serviceRecordHandle, attrSet, transactionID, listener);
        }
        catch (IOException ioe) {
            this.transport.cancelAll(65536);
            throw ioe;
        }
    }

    void serviceSearchAttributeRequest(int[] attrSet, UUID[] uuidSet, int transactionID, SDPResponseListener listener) throws IOException {
        try {
            this.transport.serviceSearchAttributeRequest(attrSet, uuidSet, transactionID, listener);
        }
        catch (IOException ioe) {
            this.transport.cancelAll(65536);
            throw ioe;
        }
    }

    boolean cancelServiceSearch(int transactionID) {
        return this.transport.cancelServiceSearch(transactionID);
    }

    private static class SDPTransport {
        private String bluetoothAddress;
        private int counter;
        private L2CAPConnection connection;
        private DataL2CAPReaderWriter rw;
        private Hashtable requestListeners;
        private Receiver receiver = new Receiver();
        private Object readLock = new Object();
        private Object writeLock = new Object();
        private static final int SDP_ERROR_RESPONSE = 1;
        private static final int SDP_SERVICE_SEARCH_REQUEST = 2;
        private static final int SDP_SERVICE_SEARCH_RESPONSE = 3;
        private static final int SDP_SERVICE_ATTRIBUTE_REQUEST = 4;
        private static final int SDP_SERVICE_ATTRIBUTE_RESPONSE = 5;
        private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_REQUEST = 6;
        private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_RESPONSE = 7;
        private static final String SDP_L2CAP_URL_BEGIN = "//";
        private static final String SDP_L2CAP_URL_END = ":0001";

        SDPTransport(String bluetoothAddress) {
            this.bluetoothAddress = bluetoothAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws IOException {
            boolean firstStart = false;
            SDPTransport sDPTransport = this;
            synchronized (sDPTransport) {
                if (this.counter == 0) {
                    BCC control = LocalDeviceImpl.getBCC();
                    this.connection = (L2CAPConnection)control.getL2CAPConnection(SDP_L2CAP_URL_BEGIN + this.bluetoothAddress + SDP_L2CAP_URL_END);
                    this.rw = new DataL2CAPReaderWriter(this.connection);
                    this.requestListeners = new Hashtable();
                    this.receiver = new Receiver();
                    firstStart = true;
                } else if (this.counter < 0) {
                    throw new RuntimeException("Illegal state of SDPTransport");
                }
                ++this.counter;
            }
            if (firstStart) {
                SDPClient.startTransport(this.bluetoothAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws IOException {
            boolean lastStop = false;
            SDPTransport sDPTransport = this;
            synchronized (sDPTransport) {
                --this.counter;
                if (this.counter == 0) {
                    lastStop = true;
                    try {
                        this.connection.close();
                    }
                    finally {
                        this.connection = null;
                        this.rw = null;
                        this.requestListeners = null;
                        this.receiver = null;
                    }
                } else if (this.counter < 0) {
                    throw new RuntimeException("Illegal state of SDPTransport");
                }
            }
            if (lastStop) {
                SDPClient.stopTransport(this.bluetoothAddress);
            }
        }

        void startTransaction(int transactionID, SDPResponseListener listener) throws IOException {
            this.start();
            this.receiver.start();
            this.requestListeners.put(new Integer(transactionID), listener);
        }

        void stopTransaction(int transactionID) throws IOException {
            this.requestListeners.remove(new Integer(transactionID));
            this.receiver.stop();
            this.stop();
        }

        boolean cancelTransaction(int transactionID, int reason) {
            SDPResponseListener listener = (SDPResponseListener)this.requestListeners.remove(new Integer(transactionID));
            if (listener == null) {
                return false;
            }
            try {
                this.stopTransaction(transactionID);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            listener.errorResponse(reason, "", transactionID);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAll(int reason) {
            SDPClient.removeTransport(this.bluetoothAddress);
            SDPTransport sDPTransport = this;
            synchronized (sDPTransport) {
                if (this.counter == 0) {
                    return;
                }
                this.receiver.cancel();
                try {
                    this.connection.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                Hashtable listeners = this.requestListeners;
                this.counter = 0;
                this.connection = null;
                this.rw = null;
                this.requestListeners = null;
                this.receiver = null;
            }
            Enumeration transactionIDs = this.requestListeners.keys();
            while (transactionIDs.hasMoreElements()) {
                Object ID = transactionIDs.nextElement();
                int id = (Integer)ID;
                SDPResponseListener listener = (SDPResponseListener)this.requestListeners.get(ID);
                listener.errorResponse(reason, "", id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceSearchRequest(UUID[] uuidSet, int transactionID, SDPResponseListener listener) throws IOException {
            this.startTransaction(transactionID, listener);
            DataElement data = new DataElement(48);
            for (int i = 0; i < uuidSet.length; ++i) {
                data.addElement(new DataElement(24, (Object)uuidSet[i]));
            }
            long length = this.rw.getDataSize(data) + 3L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(2L);
                this.rw.writeShort((short)transactionID);
                this.rw.writeShort((short)length);
                this.rw.writeDataElement(data);
                this.rw.writeShort((short)4095);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceAttributeRequest(int serviceRecordHandle, int[] attrSet, int transactionID, SDPResponseListener listener) throws IOException {
            this.startTransaction(transactionID, listener);
            DataElement data = new DataElement(48);
            for (int i = 0; i < attrSet.length; ++i) {
                data.addElement(new DataElement(9, (long)attrSet[i]));
            }
            long length = this.rw.getDataSize(data) + 7L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(4L);
                this.rw.writeShort((short)transactionID);
                this.rw.writeShort((short)length);
                this.rw.writeInteger(serviceRecordHandle);
                this.rw.writeShort((short)-1);
                this.rw.writeDataElement(data);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void serviceSearchAttributeRequest(int[] attrSet, UUID[] uuidSet, int transactionID, SDPResponseListener listener) throws IOException {
            int i;
            this.startTransaction(transactionID, listener);
            DataElement attrData = new DataElement(48);
            DataElement uuidData = new DataElement(48);
            for (i = 0; i < attrSet.length; ++i) {
                attrData.addElement(new DataElement(9, (long)attrSet[i]));
            }
            for (i = 0; i < uuidSet.length; ++i) {
                uuidData.addElement(new DataElement(24, (Object)uuidSet[i]));
            }
            long length = this.rw.getDataSize(attrData) + this.rw.getDataSize(uuidData) + 3L;
            Object object = this.writeLock;
            synchronized (object) {
                this.rw.writeByte(6L);
                this.rw.writeShort((short)transactionID);
                this.rw.writeShort((short)length);
                this.rw.writeDataElement(uuidData);
                this.rw.writeShort((short)-1);
                this.rw.writeDataElement(attrData);
                this.rw.writeByte(0L);
                this.rw.flush();
            }
        }

        boolean cancelServiceSearch(int transactionID) {
            return this.cancelTransaction(transactionID, 65537);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processResponse() throws IOException {
            SDPResponseListener listener;
            short transID;
            byte requestType;
            if (this.connection == null || this.rw == null) {
                return;
            }
            if (this.requestListeners == null || this.requestListeners.isEmpty()) {
                return;
            }
            if (!this.connection.ready()) {
                return;
            }
            int[] handleList = null;
            DataElement attrList = null;
            short errorCode = 0;
            byte[] infoBytes = null;
            Object object = this.readLock;
            synchronized (object) {
                requestType = this.rw.readByte();
                transID = this.rw.readShort();
                short length = this.rw.readShort();
                listener = (SDPResponseListener)this.requestListeners.remove(new Integer(transID));
                if (listener != null) {
                    this.stopTransaction(transID);
                }
                if (requestType == 3) {
                    handleList = this.readServiceSearchResponse();
                } else if (requestType == 5) {
                    attrList = this.readServiceAttributeResponse();
                } else if (requestType == 7) {
                    attrList = this.readServiceAttributeResponse();
                } else if (requestType == 1) {
                    errorCode = this.rw.readShort();
                    infoBytes = this.rw.readBytes(length - 2);
                }
            }
            if (requestType == 3) {
                this.processServiceSearchResponse(handleList, listener, transID);
            } else if (requestType == 5) {
                this.processServiceAttributeResponse(attrList, listener, transID);
            } else if (requestType == 7) {
                this.processServiceSearchAttributeResponse(attrList, listener, transID);
            } else if (requestType == 1) {
                this.processErrorResponse(errorCode, infoBytes, listener, transID);
            } else {
                System.err.println("Unsupported SDP response code (PDU)");
            }
        }

        private void processServiceSearchResponse(int[] handleList, SDPResponseListener listener, short transID) throws IOException {
            if (listener != null) {
                listener.serviceSearchResponse(handleList, transID);
            }
        }

        private int[] readServiceSearchResponse() throws IOException {
            short totalServiceRecordCount = this.rw.readShort();
            int currentServiceRecordCount = this.rw.readShort();
            int[] handleList = null;
            if (currentServiceRecordCount > 0) {
                handleList = new int[currentServiceRecordCount];
                for (int i = 0; i < currentServiceRecordCount; ++i) {
                    handleList[i] = this.rw.readInteger();
                }
            }
            this.rw.readByte();
            return handleList;
        }

        private void processServiceAttributeResponse(DataElement attrList, SDPResponseListener listener, short transID) throws IOException {
            if (listener != null) {
                if (attrList == null) {
                    listener.serviceAttributeResponse(null, null, transID);
                    return;
                }
                int size = attrList.getSize() / 2;
                if (size == 0) {
                    listener.serviceAttributeResponse(null, null, transID);
                    return;
                }
                Enumeration elements = (Enumeration)attrList.getValue();
                int[] attrIDs = new int[size];
                DataElement[] attrValues = new DataElement[size];
                int i = 0;
                while (elements.hasMoreElements()) {
                    attrIDs[i] = (int)((DataElement)elements.nextElement()).getLong();
                    attrValues[i] = (DataElement)elements.nextElement();
                    ++i;
                }
                listener.serviceAttributeResponse(attrIDs, attrValues, transID);
            }
        }

        private void processServiceSearchAttributeResponse(DataElement attrList, SDPResponseListener listener, short transID) throws IOException {
            if (listener != null) {
                if (attrList == null) {
                    listener.serviceSearchAttributeResponse(null, null, transID);
                    return;
                }
                int size = attrList.getSize() / 2;
                if (size == 0) {
                    listener.serviceSearchAttributeResponse(null, null, transID);
                    return;
                }
                Enumeration elements = (Enumeration)attrList.getValue();
                int[] attrIDs = new int[size];
                DataElement[] attrValues = new DataElement[size];
                int i = 0;
                while (elements.hasMoreElements()) {
                    attrIDs[i] = (int)((DataElement)elements.nextElement()).getLong();
                    attrValues[i] = (DataElement)elements.nextElement();
                    ++i;
                }
                listener.serviceSearchAttributeResponse(attrIDs, attrValues, transID);
            }
        }

        private DataElement readServiceAttributeResponse() throws IOException {
            short byteCount = this.rw.readShort();
            if (byteCount < 2) {
                return null;
            }
            DataElement result = this.rw.readDataElement();
            this.rw.readByte();
            return result;
        }

        private void processErrorResponse(short errorCode, byte[] infoBytes, SDPResponseListener listener, short transID) throws IOException {
            if (listener != null) {
                String info = new String(infoBytes);
                listener.errorResponse(errorCode, info, transID);
            }
        }

        private class Receiver
        implements Runnable {
            private int startCounter = 0;
            private boolean canceled = false;
            private boolean stoped = true;

            private Receiver() {
            }

            synchronized void start() {
                if (this.startCounter == 0 && this.stoped) {
                    this.stoped = false;
                    new Thread(this).start();
                }
                ++this.startCounter;
            }

            synchronized void stop() {
                --this.startCounter;
            }

            synchronized void cancel() {
                this.canceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Object addresses = null;
                    Receiver receiver = this;
                    synchronized (receiver) {
                        if (this.startCounter <= 0 || this.canceled) {
                            this.startCounter = 0;
                            this.stoped = true;
                            break;
                        }
                    }
                    try {
                        SDPTransport.this.processResponse();
                    }
                    catch (IOException ioe) {
                        Receiver receiver2 = this;
                        synchronized (receiver2) {
                            if (this.startCounter <= 0 || this.canceled) {
                                this.startCounter = 0;
                                this.stoped = true;
                                break;
                            }
                        }
                        SDPTransport.this.cancelAll(65536);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static class Counter {
        int counter;

        private Counter() {
        }
    }
}

