/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.SDPServer;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SDDBImpl {
    private static final boolean DEBUG = false;
    private static SDDBImpl sddbInstance;
    private static int freeHandle;
    private Hashtable recordStorage;
    private SDPServer server;
    private BCC control;
    private boolean isInitialized;

    public static synchronized SDDBImpl getSDDBInstance() {
        if (!SDDBImpl.sddbInstance.isInitialized) {
            sddbInstance.init();
            SDDBImpl.sddbInstance.isInitialized = true;
        }
        return sddbInstance;
    }

    SDDBImpl(BCC control) {
        this.control = control;
        sddbInstance = this;
    }

    private void init() {
        this.recordStorage = new Hashtable();
        this.server = new SDPServer(this);
        this.server.start();
    }

    public static synchronized int getFreeID() {
        return freeHandle++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord(ServiceRecordImpl record) {
        int handle = record.getHandle();
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            this.recordStorage.put(new Integer(handle), record);
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceRecord(ServiceRecordImpl record) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int handle = record.getHandle();
            this.recordStorage.remove(new Integer(handle));
        }
        this.control.updateDeviceClass(this.getDeviceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getHandles() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int i = 0;
            int sz = this.recordStorage.size();
            int[] handles = new int[sz];
            Enumeration e = this.recordStorage.elements();
            while (e.hasMoreElements()) {
                ServiceRecordImpl rec = (ServiceRecordImpl)e.nextElement();
                handles[i] = rec.getHandle();
                ++i;
            }
            return handles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRecordImpl getServiceRecord(int handle) {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            return (ServiceRecordImpl)this.recordStorage.get(new Integer(handle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDeviceClasses() {
        Hashtable hashtable = this.recordStorage;
        synchronized (hashtable) {
            int devClass = 0;
            Enumeration e = this.recordStorage.elements();
            while (e.hasMoreElements()) {
                ServiceRecordImpl rec = (ServiceRecordImpl)e.nextElement();
                devClass |= rec.getDeviceServiceClasses();
            }
            return devClass;
        }
    }
}

