/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SelectServiceHandler;
import com.sun.kvem.jsr082.bluetooth.ServiceSearcher;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

public final class DiscoveryAgentImpl {
    private static final boolean DEBUG = false;
    private static DiscoveryAgentImpl instance;
    private static BCC bcc;
    private Hashtable cachedDevices = new Hashtable();
    private DiscoveryListener d_listener;
    private Object d_lock = new Object();
    private SelectServiceHandler selectServiceHandler = new SelectServiceHandler(this);
    static /* synthetic */ Class class$com$sun$kvem$jsr082$bluetooth$DiscoveryAgentImpl;
    static /* synthetic */ Class class$javax$bluetooth$DiscoveryAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryAgentImpl(DiscoveryAgent parent) {
        Class clazz = class$com$sun$kvem$jsr082$bluetooth$DiscoveryAgentImpl == null ? (class$com$sun$kvem$jsr082$bluetooth$DiscoveryAgentImpl = DiscoveryAgentImpl.class$("com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl")) : class$com$sun$kvem$jsr082$bluetooth$DiscoveryAgentImpl;
        synchronized (clazz) {
            if (instance != null) {
                throw new RuntimeException("Already initialized");
            }
            if (parent == null || parent.getClass() != (class$javax$bluetooth$DiscoveryAgent == null ? (class$javax$bluetooth$DiscoveryAgent = DiscoveryAgentImpl.class$("javax.bluetooth.DiscoveryAgent")) : class$javax$bluetooth$DiscoveryAgent)) {
                throw new IllegalArgumentException("Illegal 'parent'");
            }
            instance = this;
        }
    }

    public RemoteDevice[] retrieveDevices(int option) {
        RemoteDevice[] res = null;
        switch (option) {
            case 0: {
                if (this.cachedDevices.size() == 0) break;
                res = new RemoteDevice[this.cachedDevices.size()];
                int i = 0;
                Enumeration devs = this.cachedDevices.elements();
                while (devs.hasMoreElements()) {
                    res[i] = (RemoteDevice)devs.nextElement();
                    ++i;
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid 'option' value: " + option);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        if (accessCode != 10390323 && accessCode != 10390272 && (accessCode < 10390272 || accessCode > 10390335)) {
            throw new IllegalArgumentException("Access code is out of range: " + accessCode);
        }
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Object object = this.d_lock;
        synchronized (object) {
            if (this.d_listener != null) {
                throw new BluetoothStateException("The previous device discovery is running...");
            }
            this.d_listener = listener;
            bcc.startInquiry(this, listener, accessCode);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelInquiry(DiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Object object = this.d_lock;
        synchronized (object) {
            if (this.d_listener == null) {
                return false;
            }
            if (this.d_listener != listener) {
                return false;
            }
            bcc.cancelInquiry();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted() {
        Object object = this.d_lock;
        synchronized (object) {
            this.d_listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDeviceImpl getRemoteDevice(String addr) {
        Hashtable hashtable = this.cachedDevices;
        synchronized (hashtable) {
            RemoteDeviceImpl rd = (RemoteDeviceImpl)((Object)this.cachedDevices.get(addr));
            if (rd == null) {
                rd = new RemoteDeviceImpl(addr);
                this.cachedDevices.put(addr, rd);
            }
            return rd;
        }
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice btDev, DiscoveryListener discListener) throws BluetoothStateException {
        ServiceSearcher searcher = new ServiceSearcher(attrSet, uuidSet, btDev, discListener);
        int transID = searcher.start();
        return transID;
    }

    public boolean cancelServiceSearch(int transID) {
        return ServiceSearcher.cancel(transID);
    }

    public String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        return this.selectServiceHandler.selectService(uuid, security, master);
    }

    static DiscoveryAgentImpl getInstance(BCC bcc) {
        DiscoveryAgentImpl.bcc = bcc;
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

