/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.io.j2me.tcpobex;

import com.sun.kvem.jsr082.impl.NetmonCommon;
import com.sun.midp.io.j2me.tcpobex.TCPOBEXConnection;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;

final class TCPOBEXNetmonConnection
extends TCPOBEXConnection {
    private int id;
    private boolean isNetmonClosed;

    TCPOBEXNetmonConnection(SecurityToken token, String host, int port, String url) throws IOException {
        super(token, host, port);
        long groupid = System.currentTimeMillis();
        this.id = NetmonCommon.connect0(url, groupid);
    }

    TCPOBEXNetmonConnection(Object[] sockData, String url) throws IOException {
        super(sockData);
        long groupid = System.currentTimeMillis();
        this.id = NetmonCommon.connect0(url, groupid);
    }

    public void close() throws IOException {
        this.disconnect();
        super.close();
    }

    public void write(byte[] outData, int len) throws IOException {
        try {
            super.write(outData, len);
            NetmonCommon.write0(this.id, outData, 0, len);
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public int read(byte[] inData) throws IOException {
        try {
            int len = super.read(inData);
            if (len != -1) {
                NetmonCommon.read0(this.id, inData, 0, len);
            }
            return len;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        TCPOBEXNetmonConnection tCPOBEXNetmonConnection = this;
        synchronized (tCPOBEXNetmonConnection) {
            if (this.isNetmonClosed) {
                return;
            }
            this.isNetmonClosed = true;
        }
        NetmonCommon.disconnect0(this.id);
    }
}

