/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.io.j2me.sms;

import com.sun.kvem.io.j2me.sms.Protocol;
import com.sun.midp.io.j2me.sms.DatagramRecord;
import com.sun.midp.io.j2me.sms.TextEncoder;
import com.sun.midp.io.j2me.sms.TransportMessage;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import javax.microedition.io.Datagram;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;

public class DatagramImpl
extends com.sun.midp.io.j2me.sms.DatagramImpl {
    MessageConnection connection = null;

    public void open(MessageConnection connection, SecurityToken token) throws IOException {
        this.connection = connection;
        super.open(connection, token);
    }

    public long send(String type, String address, byte[] buffer, String senderPort) throws IOException {
        int segments;
        int headersize;
        DatagramRecord dr = new DatagramRecord();
        long sendtime = System.currentTimeMillis();
        int offset = 0;
        int portheadersize = 0;
        int colon = address.indexOf(":");
        if ((colon = address.indexOf(":", colon + 1)) != -1) {
            portheadersize = 7;
        }
        if (buffer == null) {
            buffer = new byte[]{};
        }
        if (type.equals("text")) {
            byte[] gsm7bytes = TextEncoder.encode(buffer);
            if (gsm7bytes != null) {
                dr.setHeader("Text-Encoding", "gsm7bit");
                this.fragmentsize = 160;
                headersize = 8;
                buffer = gsm7bytes;
            } else {
                dr.setHeader("Text-Encoding", "ucs2");
                this.fragmentsize = 140;
                headersize = 8;
                if (portheadersize != 0) {
                    portheadersize = 6;
                }
            }
        } else {
            this.fragmentsize = 140;
            headersize = 7;
            if (portheadersize != 0) {
                portheadersize = 6;
            }
        }
        this.fragmentsize -= portheadersize;
        if (buffer.length < this.fragmentsize) {
            segments = 1;
        } else {
            this.fragmentsize -= headersize;
            segments = (buffer.length + this.fragmentsize - 1) / this.fragmentsize;
        }
        if (buffer.length > 255 * this.fragmentsize) {
            throw new IOException("Message is too large");
        }
        int length = buffer.length;
        int md = DatagramImpl.beginSending(address);
        for (int i = 0; i < segments; ++i) {
            Datagram mess = this.dgc.newDatagram(buffer.length);
            mess.setAddress("datagram://" + this.dhost + ":" + this.dportout);
            dr.setHeader("Date", String.valueOf(sendtime));
            dr.setHeader("Address", address);
            if (senderPort == null) {
                dr.setHeader("SenderAddress", "sms://" + this.phoneNumber);
            } else {
                dr.setHeader("SenderAddress", "sms://" + this.phoneNumber + ":" + senderPort);
            }
            dr.setHeader("Content-Type", type);
            dr.setHeader("Content-Length", String.valueOf(buffer.length));
            dr.setHeader("Segments", String.valueOf(segments));
            if (segments > 1) {
                offset = i * this.fragmentsize;
                length = i < segments - 1 ? this.fragmentsize : buffer.length - this.fragmentsize * i;
                dr.setHeader("Fragment", String.valueOf(i));
                dr.setHeader("Fragment-Size", String.valueOf(length));
                dr.setHeader("Fragment-Offset", String.valueOf(offset));
            }
            byte[] buf = new byte[length];
            System.arraycopy(buffer, offset, buf, 0, length);
            dr.setData(buf);
            byte[] messdata = dr.getFormattedData();
            mess.setData(messdata, 0, messdata.length);
            this.dgc.send(mess);
            DatagramImpl.send0(md, messdata);
        }
        DatagramImpl.close0(md);
        return sendtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportMessage receive(MessageConnection forThisConnection) throws IOException {
        String te;
        if (this.reader == null) {
            this.reader = new Thread(new KvemDatagramReader());
            this.reader.start();
        }
        int md = DatagramImpl.beginReceiving();
        Datagram mess = null;
        DatagramRecord previous = null;
        DatagramRecord current = null;
        while (true) {
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (((Protocol)forThisConnection).isOpen()) continue;
                    throw new InterruptedIOException("connection closed");
                }
                mess = (Datagram)this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            DatagramImpl.received0(md, mess.getData(), mess.getLength());
            current = new DatagramRecord();
            if (!current.parseData(mess.getData(), mess.getLength()) || current.addData(previous)) break;
            previous = current;
        }
        DatagramImpl.close0(md);
        String addr = current.getHeader("CBSAddress");
        if (addr == null) {
            addr = current.getHeader("Address");
        }
        String senderAddr = current.getHeader("SenderAddress");
        long time = 0L;
        try {
            time = Long.parseLong(current.getHeader("Date"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String type = current.getHeader("Content-Type");
        byte[] buf = current.getData();
        if (type.equals("text") && (te = current.getHeader("Text-Encoding")) != null && te.equals("gsm7bit")) {
            buf = TextEncoder.decode(buf);
        }
        return new TransportMessage(addr, senderAddr, type, time, buf);
    }

    public void setMessageListener(MessageConnection connection, MessageListener listener, String port) throws IOException {
        if (this.dgc != null && listener != null && this.reader == null) {
            this.reader = new Thread(new KvemDatagramReader());
            this.reader.start();
        }
        super.setMessageListener(connection, listener, port);
    }

    private static int beginSending(String url) {
        return DatagramImpl.open0(url, 0, System.currentTimeMillis());
    }

    private static int beginReceiving() {
        return DatagramImpl.open0("", 1, System.currentTimeMillis());
    }

    private static native int open0(String var0, int var1, long var2);

    private static native void close0(int var0);

    private static native void send0(int var0, byte[] var1);

    private static native void received0(int var0, byte[] var1, int var2);

    public class KvemDatagramNotifier
    implements Runnable {
        String sms_port;
        String cbs_port;

        protected KvemDatagramNotifier(String p1, String p2) {
            this.sms_port = p1;
            this.cbs_port = p2;
        }

        public void run() {
            int len = ports.size();
            for (int i = 0; i < len; ++i) {
                if (!ports.elementAt(i).equals(smsconnections.elementAt(i) instanceof com.sun.kvem.io.j2me.cbs.Protocol ? this.cbs_port : this.sms_port)) continue;
                ((MessageListener)listeners.elementAt(i)).notifyIncomingMessage((MessageConnection)smsconnections.elementAt(i));
            }
        }
    }

    public class KvemDatagramReader
    implements Runnable {
        KvemDatagramReader() {
            DatagramImpl.this.queue = new Vector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        Datagram mess = DatagramImpl.this.dgc.newDatagram(1500);
                        DatagramImpl.this.dgc.receive(mess);
                        Vector vector = DatagramImpl.this.queue;
                        synchronized (vector) {
                            DatagramImpl.this.queue.addElement(mess);
                            DatagramImpl.this.queue.notify();
                        }
                        DatagramRecord dr = new DatagramRecord();
                        dr.parseData(mess.getData(), mess.getLength());
                        String addr = dr.getHeader("Address");
                        String cbsaddr = dr.getHeader("CBSAddress");
                        if (addr == null || !dr.getHeader("Segments").equals("1") && !dr.getHeader("Fragment").equals("0")) continue;
                        String target_sms_port = addr.substring(addr.lastIndexOf(58) + 1);
                        String target_cbs_port = null;
                        if (cbsaddr != null) {
                            target_cbs_port = cbsaddr.substring(cbsaddr.lastIndexOf(58) + 1);
                        }
                        try {
                            new Thread(new KvemDatagramNotifier(target_sms_port, target_cbs_port)).start();
                            continue block8;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedIOException iioe) {
                    break;
                }
                catch (IOException ioe) {
                    break;
                }
            }
        }
    }
}

