/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamReader;
import com.sun.kvem.cldc.i18n.j2me.GenericWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class GenericReader
extends StreamReader {
    private String enc;
    private final int maxBytesPerChar;
    private int maxCharsPerByte = -1;
    private int id;
    private static int counter = 0;
    private boolean initializedStream = false;
    static /* synthetic */ Class class$com$sun$kvem$cldc$i18n$j2me$GenericReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericReader(String enc) throws UnsupportedEncodingException {
        this.enc = enc;
        this.maxBytesPerChar = this.checkEncoding(enc);
        Class clazz = class$com$sun$kvem$cldc$i18n$j2me$GenericReader == null ? (class$com$sun$kvem$cldc$i18n$j2me$GenericReader = GenericReader.class$("com.sun.kvem.cldc.i18n.j2me.GenericReader")) : class$com$sun$kvem$cldc$i18n$j2me$GenericReader;
        synchronized (clazz) {
            this.id = counter++;
        }
    }

    public Reader open(InputStream in, String enc) throws UnsupportedEncodingException {
        if (!enc.equals(this.enc)) {
            throw new IllegalArgumentException(enc + " not equals " + this.enc);
        }
        return super.open(in, enc);
    }

    public synchronized int read() throws IOException {
        for (int i = 0; i < this.maxBytesPerChar; ++i) {
            int nextChar;
            int nextByte = this.in.read();
            if (nextByte == -1) {
                if (this.initializedStream) {
                    this.cleanStreamResources();
                }
                return -1;
            }
            if (!this.initializedStream) {
                GenericReader.openStream(this.id, this.enc);
                this.initializedStream = true;
            }
            if ((nextChar = GenericReader.readCharFromStream(this.id, (byte)nextByte)) == -1) continue;
            return (char)nextChar;
        }
        String message = "Malformed input (cannot form character from input stream)";
        throw new IOException(message);
    }

    public char[] getChars(byte[] buffer, int offset, int bLength) throws IOException {
        char[] cs;
        int cLength;
        if (this.maxCharsPerByte == -1) {
            this.maxCharsPerByte = new GenericWriter(this.enc).getMaxCharsPerByte();
        }
        if ((cLength = this.byteToCharArray(cs = new char[bLength * this.maxCharsPerByte], 0, buffer, offset, bLength, this.enc, -1)) == cs.length) {
            return cs;
        }
        char[] cs2 = new char[cLength];
        System.arraycopy(cs, 0, cs2, 0, cLength);
        return cs2;
    }

    public void close() throws IOException {
        this.cleanStreamResources();
        super.close();
    }

    private synchronized void cleanStreamResources() {
        GenericReader.closeStream(this.id);
        this.initializedStream = false;
    }

    private static native int readCharFromStream(int var0, byte var1);

    private static native void openStream(int var0, String var1);

    private static native void closeStream(int var0);

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.initializedStream) {
            GenericReader.openStream(this.id, this.enc);
            this.initializedStream = true;
        }
        int totalCharsRead = 0;
        int bytesToRead = GenericReader.getMinimumBytes(len, this.id);
        if (bytesToRead < 1) {
            bytesToRead = 1;
        }
        byte[] b = new byte[bytesToRead];
        int bytesReadWhileWaitingForNextChar = 0;
        while (totalCharsRead < len) {
            int bytesRead = this.in.read(b, 0, bytesToRead);
            if (bytesRead == -1) {
                if (this.initializedStream) {
                    GenericReader.closeStream(this.id);
                    this.initializedStream = false;
                }
                return totalCharsRead == 0 ? -1 : totalCharsRead;
            }
            int charsRead = this.byteToCharArray(cbuf, off + totalCharsRead, b, 0, bytesRead, this.enc, this.id);
            if (charsRead == -1) {
                if ((bytesReadWhileWaitingForNextChar += bytesRead) >= this.maxBytesPerChar) {
                    throw new IOException("Malformed input");
                }
            } else {
                totalCharsRead += charsRead;
                bytesReadWhileWaitingForNextChar = 0;
            }
            if (totalCharsRead >= len || (bytesToRead = GenericReader.getMinimumBytes(len - totalCharsRead, this.id)) >= 1) continue;
            bytesToRead = 1;
        }
        return len;
    }

    public int sizeOf(byte[] bytes, int off, int len) {
        try {
            if (off != 0) {
                byte[] temp = new byte[len];
                System.arraycopy(bytes, off, temp, 0, len);
                return this.sizeOf(temp, len, this.enc);
            }
            return this.sizeOf(bytes, len, this.enc);
        }
        catch (IOException e) {
            return -1;
        }
    }

    int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    private static native int getMinimumBytes(int var0, int var1);

    private native int byteToCharArray(char[] var1, int var2, byte[] var3, int var4, int var5, String var6, int var7) throws IOException;

    private native int sizeOf(byte[] var1, int var2, String var3) throws IOException;

    private native int checkEncoding(String var1) throws UnsupportedEncodingException;

    private native void finalize();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

