/*
 * Decompiled with CFR 0.152.
 */
package example.obex.demo;

import example.obex.demo.GUIImageSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.Operation;

final class ObexImageSender
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String cn = "ObexImageSender";
    private boolean stop = true;
    private InputStream imageSource = null;
    private ByteArrayOutputStream baos = null;
    private ClientSession session = null;
    private Operation operation = null;
    private OutputStream outputStream = null;
    private byte[] imageData = null;
    private String imageName = null;
    private GUIImageSender gui = null;

    ObexImageSender(GUIImageSender gUIImageSender) {
        this.gui = gUIImageSender;
    }

    void setImageName(String string) {
        this.imageName = string;
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        this.stop = false;
        try {
            this.loadImageData(this.imageName);
            bl = true;
            this.connect();
            bl2 = true;
            this.uploadImage(this.imageName);
        }
        catch (IOException iOException) {
            if (!this.stop) {
                if (bl2) {
                    this.gui.stopMessage();
                } else if (bl) {
                    this.gui.notReadyMessage();
                } else {
                    this.gui.errorMessage();
                }
                this.closeAll();
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.closeAll();
        this.gui.showImageList();
    }

    private void loadImageData(String string) throws IOException {
        this.imageSource = this.getClass().getResourceAsStream(string);
        byte[] byArray = new byte[1024];
        this.baos = new ByteArrayOutputStream(1024);
        while (true) {
            if (this.stop) {
                throw new IOException();
            }
            int n = this.imageSource.read(byArray);
            if (n == -1) break;
            this.baos.write(byArray, 0, n);
        }
        this.imageData = this.baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        String string = "irdaobex://discover.0210;ias=ImageExchange";
        this.gui.showProgress("Connecting ...", this.imageData.length);
        ObexImageSender obexImageSender = this;
        synchronized (obexImageSender) {
            this.session = (ClientSession)Connector.open((String)string);
        }
        this.gui.showProgress("Uploading Image ...", this.imageData.length);
        obexImageSender = this.session.connect(null);
        int n = obexImageSender.getResponseCode();
        if (n != 160) {
            throw new IOException();
        }
    }

    private void uploadImage(String string) throws IOException {
        int n = 0;
        HeaderSet headerSet = this.session.createHeaderSet();
        headerSet.setHeader(1, (Object)string);
        headerSet.setHeader(195, (Object)new Long(this.imageData.length));
        this.operation = this.session.put(headerSet);
        this.outputStream = this.operation.openOutputStream();
        while (n != this.imageData.length) {
            int n2;
            OutputStream outputStream = this.outputStream;
            int n3 = n2 = this.imageData.length - n > 256 ? 256 : this.imageData.length - n;
            if (outputStream == null) {
                throw new IOException();
            }
            outputStream.write(this.imageData, n, n2);
            this.gui.updateProgress(n += n2);
        }
        this.outputStream.close();
        int n4 = this.operation.getResponseCode();
        if (n4 != 160) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.stop = true;
        ObexImageSender obexImageSender = this;
        synchronized (obexImageSender) {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void closeAll() {
        this.imageData = null;
        if (this.imageSource != null) {
            try {
                this.imageSource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.imageSource = null;
        }
        if (this.baos != null) {
            try {
                this.baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.baos = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
        }
        if (this.operation != null) {
            try {
                this.operation.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.operation = null;
        }
        if (this.session != null) {
            try {
                this.session.disconnect(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.session = null;
        }
    }
}

