/*
 * Decompiled with CFR 0.152.
 */
package example.obex.demo;

import example.obex.demo.GUIImageReceiver;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

final class ObexImageReceiver
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String cn = "ObexImageReceiver";
    private static final byte NONE = 0;
    private static final byte OPENED = 1;
    private static final byte CONNECTED = 2;
    private static final byte STARTED = 3;
    private static final byte STOPED = 4;
    private static final byte CLOSED = 5;
    private byte current_state = 0;
    private Handler handler = new Handler();
    private static final int MAX_PROCESSING_LENGTH = 2;
    private int processingLength = 0;
    private SessionNotifier session = null;
    private Operation operation = null;
    private InputStream inputStream = null;
    private GUIImageReceiver gui = null;

    ObexImageReceiver(GUIImageReceiver gUIImageReceiver) {
        this.gui = gUIImageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ObexImageReceiver obexImageReceiver;
        try {
            obexImageReceiver = this;
            synchronized (obexImageReceiver) {
                String string = "irdaobex://localhost.0010;ias=ImageExchange";
                this.session = (SessionNotifier)Connector.open((String)string);
                this.current_state = 1;
            }
            while (this.current_state != 5) {
                this.session.acceptAndOpen((ServerRequestHandler)this.handler);
                this.preventOverloading();
            }
        }
        catch (IOException iOException) {
            ObexImageReceiver obexImageReceiver2 = this;
            synchronized (obexImageReceiver2) {
                if (this.current_state != 5) {
                    iOException.printStackTrace();
                }
            }
        }
        obexImageReceiver = this;
        synchronized (obexImageReceiver) {
            if (this.current_state != 5) {
                this.current_state = (byte)5;
                this.gui.canNotConnectMessage();
            }
        }
        this.closeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preventOverloading() {
        Handler handler = this.handler;
        synchronized (handler) {
            while (this.processingLength >= 2) {
                ++this.processingLength;
                try {
                    ((Object)((Object)this.handler)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.processingLength;
                if (this.processingLength <= 0) continue;
                ((Object)((Object)this.handler)).notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSynchReceiving(Operation operation) throws IOException {
        Object object = this.handler;
        synchronized (object) {
            ++this.processingLength;
            if (this.processingLength > 1) {
                try {
                    ((Object)((Object)this.handler)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.current_state == 5) {
                throw new IOException();
            }
            this.operation = operation;
            this.current_state = (byte)2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSynchReceiving() {
        Handler handler = this.handler;
        synchronized (handler) {
            --this.processingLength;
            if (this.processingLength > 0) {
                ((Object)((Object)this.handler)).notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int imageReceive(Operation operation) {
        int n;
        HeaderSet headerSet = null;
        String string = null;
        int n2 = 0;
        try {
            this.startSynchReceiving(operation);
            headerSet = operation.getReceivedHeaders();
            string = (String)headerSet.getHeader(1);
            n2 = (int)((Long)headerSet.getHeader(195)).longValue();
            if (this.gui.askPermission(string, n2)) {
                this.gui.showImage(this.downloadImage(n2));
                n = 160;
            } else {
                n = 195;
            }
        }
        catch (IOException iOException) {
            if (this.current_state == 4) {
                this.gui.showWaiting();
                this.closeAll(false);
                n = 165;
            }
            if (this.current_state == 2) {
                this.gui.canNotConnectMessage();
                this.closeAll(false);
                n = 208;
            }
            if (this.current_state == 3) {
                this.gui.stopMessage();
                this.gui.showWaiting();
                this.closeAll(false);
                n = 208;
            }
            ObexImageReceiver obexImageReceiver = this;
            synchronized (obexImageReceiver) {
                this.current_state = (byte)5;
            }
            this.closeAll(true);
            n = 208;
        }
        this.stopSynchReceiving();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadImage(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        this.checkStopSignal();
        this.gui.showProgress(n);
        Object object = this;
        synchronized (object) {
            this.current_state = (byte)3;
            this.inputStream = this.operation.openInputStream();
        }
        while (n2 < n) {
            object = this.inputStream;
            if (object == null) {
                throw new IOException();
            }
            this.checkStopSignal();
            n3 = n2 < n - 256 ? ((InputStream)object).read(byArray, n2, 256) : ((InputStream)object).read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new IOException();
            }
            this.gui.updateProgress(n2 += n3);
        }
        object = this;
        synchronized (object) {
            this.current_state = (byte)5;
        }
        this.closeAll(true);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStopSignal() throws IOException {
        ObexImageReceiver obexImageReceiver = this;
        synchronized (obexImageReceiver) {
            if (this.current_state == 4 || this.current_state == 5) {
                throw new IOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean bl) {
        ObexImageReceiver obexImageReceiver = this;
        synchronized (obexImageReceiver) {
            if (bl) {
                this.current_state = (byte)5;
            } else {
                this.current_state = (byte)4;
                Handler handler = this.handler;
                synchronized (handler) {
                    ((Object)((Object)this.handler)).notifyAll();
                }
            }
            this.closeAll(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAll(boolean bl) {
        ObexImageReceiver obexImageReceiver = this;
        synchronized (obexImageReceiver) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.inputStream = null;
            }
            if (this.operation != null) {
                try {
                    this.operation.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.operation = null;
            }
            if (this.session != null && bl) {
                try {
                    this.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.session = null;
            }
        }
    }

    class Handler
    extends ServerRequestHandler {
        public int onPut(Operation operation) {
            return ObexImageReceiver.this.imageReceive(operation);
        }
    }
}

