/*
 * Decompiled with CFR 0.152.
 */
package example.obex.demo;

import example.obex.demo.ObexDemoMIDlet;
import example.obex.demo.ObexImageSender;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

final class GUIImageSender
implements CommandListener {
    private static final boolean DEBUG = false;
    private static final String cn = "GUIImageSender";
    private ObexDemoMIDlet parent;
    private Command stopCommand = new Command("Stop", 2, 1);
    private Command backCommand = new Command("Back", 6, 1);
    private Command sendCommand = new Command("Send", 8, 1);
    private Vector imageNames = null;
    private List imageList = null;
    private Form senderForm = new Form("Send Image");
    private Gauge sendingItem = new Gauge("", false, 256, 0);
    private ObexImageSender obexSender = null;

    GUIImageSender(ObexDemoMIDlet obexDemoMIDlet) {
        this.parent = obexDemoMIDlet;
        this.obexSender = new ObexImageSender(this);
        this.setupImageList();
        this.imageList.addCommand(this.sendCommand);
        this.imageList.addCommand(this.backCommand);
        this.imageList.setCommandListener((CommandListener)this);
        this.senderForm.append((Item)this.sendingItem);
        this.senderForm.addCommand(this.stopCommand);
        this.senderForm.setCommandListener((CommandListener)this);
        this.showImageList();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.parent.show();
        } else if (command == this.stopCommand) {
            this.obexSender.stop();
            this.showImageList();
        } else if (command == this.sendCommand) {
            this.sendImage();
        } else if (command == List.SELECT_COMMAND) {
            this.sendImage();
        } else if (command == Alert.DISMISS_COMMAND) {
            this.showImageList();
        }
    }

    void showProgress(String string, int n) {
        this.sendingItem.setLabel(string);
        this.sendingItem.setValue(0);
        this.sendingItem.setMaxValue(n);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.senderForm);
    }

    void updateProgress(int n) {
        this.sendingItem.setValue(n);
    }

    void showImageList() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.imageList);
    }

    void errorMessage() {
        Alert alert = new Alert("Error", "Can't read the image", null, null);
        alert.setTimeout(5000);
        alert.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.imageList);
    }

    void notReadyMessage() {
        Alert alert = new Alert("Warning", "Receiver isn't ready to download image", null, null);
        alert.setTimeout(5000);
        alert.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.imageList);
    }

    void stopMessage() {
        Alert alert = new Alert("Warning", "Receiver terminated image loading", null, null);
        alert.setTimeout(5000);
        alert.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.imageList);
    }

    void stop() {
        this.obexSender.stop();
    }

    private void sendImage() {
        int n = this.imageList.getSelectedIndex();
        String string = (String)this.imageNames.elementAt(n);
        this.obexSender.setImageName(string);
        new Thread(this.obexSender).start();
    }

    private void setupImageList() {
        String string;
        String string2;
        this.imageNames = new Vector();
        this.imageList = new List("Select Image to send", 3);
        this.imageList.addCommand(this.backCommand);
        this.imageList.setCommandListener((CommandListener)this);
        for (int i = 1; i < 100 && (string2 = this.parent.getAppProperty(string = "ImageName-" + i)) != null && string2.length() != 0; ++i) {
            String string3 = "ImageTitle-" + i;
            String string4 = this.parent.getAppProperty(string3);
            if (string4 == null || string4.length() == 0) {
                string4 = string2;
            }
            this.imageNames.addElement(string2);
            this.imageList.append(string4, null);
        }
    }
}

