/*
 * Decompiled with CFR 0.152.
 */
package example.obex.demo;

import example.obex.demo.ObexDemoMIDlet;
import example.obex.demo.ObexImageReceiver;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

final class GUIImageReceiver
implements CommandListener {
    private static final boolean DEBUG = false;
    private static final String cn = "GUIImageReceiver";
    private ObexDemoMIDlet parent;
    private Command stopCommand = new Command("Stop", 2, 1);
    private Command backCommand = new Command("Back", 6, 1);
    private Command confirmCommand = new Command("Yes", 4, 1);
    private Command rejectCommand = new Command("No", 3, 1);
    private StringItem waitingItem = new StringItem("Waiting for connection", "");
    private ImageItem imageItem = new ImageItem("Image ...", null, 3, null);
    private Gauge downloadingItem = new Gauge("Downloading Image ...", false, 256, 0);
    private Form receiverForm = new Form("Receive Image");
    private Object alertLock = new Object();
    private boolean download = false;
    private boolean choose = false;
    private ObexImageReceiver obexReceiver = null;

    GUIImageReceiver(ObexDemoMIDlet obexDemoMIDlet) {
        this.parent = obexDemoMIDlet;
        this.obexReceiver = new ObexImageReceiver(this);
        this.waitingItem.setLayout(3);
        this.receiverForm.append((Item)this.waitingItem);
        this.receiverForm.addCommand(this.backCommand);
        this.receiverForm.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)obexDemoMIDlet).setCurrent((Displayable)this.receiverForm);
        new Thread(this.obexReceiver).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == this.stopCommand) {
            this.obexReceiver.stop(false);
            return;
        }
        if (command == this.backCommand) {
            this.obexReceiver.stop(true);
            this.parent.show();
            return;
        }
        if (command == this.confirmCommand) {
            Object object = this.alertLock;
            synchronized (object) {
                this.download = true;
                this.choose = true;
                this.alertLock.notify();
            }
        }
        if (command == this.rejectCommand) {
            Object object = this.alertLock;
            synchronized (object) {
                this.download = false;
                this.choose = true;
                this.alertLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean askPermission(String string, int n) {
        boolean bl = false;
        Alert alert = new Alert("Connected!", "Incoming image:\nName   = " + string + "\nLength = " + n + "\nWould you like to receive it ?", null, null);
        alert.setTimeout(-2);
        alert.addCommand(this.confirmCommand);
        alert.addCommand(this.rejectCommand);
        alert.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)alert);
        Object object = this.alertLock;
        synchronized (object) {
            if (!this.choose) {
                try {
                    this.alertLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.choose = false;
            bl = this.download;
        }
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.receiverForm);
        return bl;
    }

    void showWaiting() {
        this.receiverForm.set(0, (Item)this.waitingItem);
        this.receiverForm.removeCommand(this.stopCommand);
        this.receiverForm.addCommand(this.backCommand);
        this.downloadingItem.setValue(0);
    }

    void showProgress(int n) {
        this.downloadingItem.setValue(0);
        this.downloadingItem.setMaxValue(n);
        this.receiverForm.set(0, (Item)this.downloadingItem);
        this.receiverForm.removeCommand(this.backCommand);
        this.receiverForm.addCommand(this.stopCommand);
    }

    void updateProgress(int n) {
        this.downloadingItem.setValue(n);
    }

    void showImage(byte[] byArray) {
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.imageItem.setImage(image);
        this.receiverForm.set(0, (Item)this.imageItem);
        this.receiverForm.removeCommand(this.stopCommand);
        this.receiverForm.addCommand(this.backCommand);
    }

    void canNotConnectMessage() {
        Alert alert = new Alert("Warning", "Can not connect to any sender", null, null);
        alert.setTimeout(5000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.receiverForm);
    }

    void stopMessage() {
        Alert alert = new Alert("Warning", "Sender stoped image uploading", null, null);
        alert.setTimeout(5000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.receiverForm);
    }

    void stop() {
        this.obexReceiver.stop(true);
    }
}

