/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.jadtool;

import com.sun.midp.jadtool.AppDescriptorException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class SignCert {
    public static void signACert(String string, String string2, char[] cArray, KeyStore keyStore, char[] cArray2) throws AppDescriptorException, CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException, NoSuchProviderException, SignatureException, Exception {
        String string3;
        String string4;
        if (string == null || string2 == null || cArray == null || keyStore == null) {
            throw new AppDescriptorException("signACert got a null argument", 4);
        }
        Object[] objectArray = SignCert.recoverPrivateKey(string2, cArray2, cArray, keyStore);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (cArray == null) {
            cArray = (char[])objectArray[1];
        }
        if ((string4 = privateKey.getAlgorithm()).equalsIgnoreCase("DSA") || string4.equalsIgnoreCase("DSS")) {
            string3 = "SHA1WithDSA";
        } else if (string4.equalsIgnoreCase("RSA")) {
            string3 = "SHA1WithRSA";
        } else {
            throw new AppDescriptorException("Cannot derive signature algorithm", 5);
        }
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null) {
            throw new AppDescriptorException(string + " has no public key", 4);
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new AppDescriptorException(string + " has no X.509 certificate", 6);
        }
        Certificate certificate2 = keyStore.getCertificate(string2);
        if (certificate2 == null) {
            throw new AppDescriptorException(string + " has no public key", 7);
        }
        if (!(certificate2 instanceof X509Certificate)) {
            throw new AppDescriptorException(string + " has no X.509 certificate", 8);
        }
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        byArray = certificate2.getEncoded();
        X509CertImpl x509CertImpl2 = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo2 = (X509CertInfo)x509CertImpl2.get("x509.info");
        int n = 180;
        Date date = new Date();
        Date date2 = new Date();
        date2.setTime(date.getTime() + (long)(n * 1000 * 24 * 60) * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber((int)(date.getTime() / 1000L)));
        X500Name x500Name = (X500Name)x509CertInfo.get("subject.dname");
        X500Name x500Name2 = (X500Name)x509CertInfo2.get("subject.dname");
        x509CertInfo.set("issuer.dname", x500Name2);
        X509CertImpl x509CertImpl3 = new X509CertImpl(x509CertInfo);
        x509CertImpl3.sign(privateKey, string3);
        AlgorithmId algorithmId = (AlgorithmId)x509CertImpl3.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        x509CertImpl3 = new X509CertImpl(x509CertInfo);
        x509CertImpl3.sign(privateKey, string3);
        keyStore.setKeyEntry(string, privateKey, cArray != null ? cArray : cArray2, new Certificate[]{x509CertImpl3});
        System.err.println("New certificate signed & inserted into KeyStore!");
        System.err.print(x509CertImpl3.toString());
        System.err.println();
    }

    private static Object[] recoverPrivateKey(String string, char[] cArray, char[] cArray2, KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, Exception {
        Key key = null;
        if (!keyStore.containsAlias(string)) {
            throw new Exception("Alias <" + string + "> does not exist");
        }
        if (!keyStore.isKeyEntry(string)) {
            throw new Exception("Alias <" + string + "> has no (private) key");
        }
        if (cArray2 == null) {
            try {
                key = keyStore.getKey(string, cArray);
                cArray2 = cArray;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new Exception("Invalid Key password entered");
            }
        } else {
            key = keyStore.getKey(string, cArray2);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception("Recovered key is not a private key");
        }
        return new Object[]{(PrivateKey)key, cArray2};
    }
}

