/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.jadtool;

import com.sun.midp.jadtool.AppDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Vector;

public class JadTool {
    private static String USAGE = "\nJadTool arguments:\n-help\n-addcert\n\t-alias <key alias> [-storepass <password>] [-keystore <keystore>]\n\t[-certnum <number>] [-chainnum <number>]\n\t[-encoding <encoding>] -inputjad <filename> -outputjad <filename>\n-addjarsig\n\t[-jarfile <filename>] -keypass <password> -alias <key alias>\n\t-storepass <password> [-keystore <keystore>] [-encoding <encoding>]\n\t-inputjad <filename> -outputjad <filename>\n-showcert\n\t[([-certnum <number>] [-chainnum <number>]) | [-all]]\n\t[-encoding <encoding>] -inputjad <filename>\n\nThe default for -encoding is UTF-8.\nThe default for -jarfile is the MIDlet-Jar-URL property in the JAD.\nThe default for -keystore is \"$HOME/.keystore\".\nThe default for -certnum is 1.\nThe default for -chainnum is 1.\n";
    private String command = null;
    private String encoding = null;
    private String infile = null;
    private String outfile = null;
    private String jarfile = null;
    private String keystore = null;
    private String alias = null;
    private String certnum = null;
    private String chainNum = null;
    private char[] storepass = null;
    private char[] keypass = null;
    private int certIndex = 1;
    private int chainIndex = 1;
    private AppDescriptor appdesc = null;
    private OutputStream outstream;

    private JadTool() {
    }

    public static void main(String[] stringArray) {
        int n = -1;
        try {
            new JadTool().run(stringArray);
            n = 0;
        }
        catch (Exception exception) {
            System.err.println("\n" + exception.getMessage() + "\n");
        }
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void run(String[] stringArray) throws Exception {
        block26: {
            block25: {
                if (stringArray.length == 0) {
                    this.usageError("No command given");
                }
                this.command = stringArray[0];
                if (!this.command.equals("-addjarsig")) break block27;
                this.performAddJarSigCommand(stringArray);
                Object var4_2 = null;
                if (this.storepass == null) break block25;
                Arrays.fill(this.storepass, ' ');
                this.storepass = null;
            }
            if (this.keypass != null) {
                Arrays.fill(this.keypass, ' ');
                this.keypass = null;
            }
            try {
                if (this.outstream != null) {
                    this.outstream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                block27: {
                    return;
                }
                if (!this.command.equals("-addcert")) break block28;
                this.performAddCertCommand(stringArray);
            }
            Object var4_3 = null;
            if (this.storepass != null) {
                Arrays.fill(this.storepass, ' ');
                this.storepass = null;
            }
            if (this.keypass != null) {
                Arrays.fill(this.keypass, ' ');
                this.keypass = null;
            }
            try {
                if (this.outstream != null) {
                    this.outstream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                block28: {
                    return;
                }
                if (!this.command.equals("-showcert")) break block29;
                this.performShowCertCommand(stringArray);
            }
            Object var4_4 = null;
            if (this.storepass != null) {
                Arrays.fill(this.storepass, ' ');
                this.storepass = null;
            }
            if (this.keypass != null) {
                Arrays.fill(this.keypass, ' ');
                this.keypass = null;
            }
            try {
                if (this.outstream != null) {
                    this.outstream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                block29: {
                    return;
                }
                if (this.command.equals("-help")) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        this.usageError("Illegal option for " + this.command + ": " + stringArray[i]);
                    }
                    this.help();
                }
                this.usageError("Illegal command: " + this.command);
            }
            Object var4_5 = null;
            if (this.storepass != null) {
                Arrays.fill(this.storepass, ' ');
                this.storepass = null;
            }
            if (this.keypass != null) {
                Arrays.fill(this.keypass, ' ');
                this.keypass = null;
            }
            try {
                if (this.outstream != null) {
                    this.outstream.close();
                }
                break block26;
            }
            catch (IOException iOException) {}
            break block26;
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.storepass != null) {
                    Arrays.fill(this.storepass, ' ');
                    this.storepass = null;
                }
                if (this.keypass != null) {
                    Arrays.fill(this.keypass, ' ');
                    this.keypass = null;
                }
                try {
                    if (this.outstream != null) {
                        this.outstream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void performAddJarSigCommand(String[] stringArray) throws Exception {
        int n = 1;
        try {
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-encoding")) {
                    this.encoding = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-keystore")) {
                    this.keystore = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-storepass")) {
                    this.storepass = stringArray[++n].toCharArray();
                    continue;
                }
                if (stringArray[n].equals("-keypass")) {
                    this.keypass = stringArray[++n].toCharArray();
                    continue;
                }
                if (stringArray[n].equals("-alias")) {
                    this.alias = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-jarfile")) {
                    this.jarfile = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-inputjad")) {
                    this.infile = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-outputjad")) {
                    this.outfile = stringArray[++n];
                    continue;
                }
                this.usageError("Illegal option for " + this.command + ": " + stringArray[n]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError("Missing value for " + stringArray[--n]);
        }
        if (this.keypass == null) {
            this.usageError(this.command + " requires -keypass");
        }
        this.initJadUtil();
        this.openKeystoreAndOutputJad();
        if (this.jarfile != null) {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.jarfile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception("JAR does not exist: " + this.jarfile);
            }
            try {
                this.appdesc.addJarSignature(this.alias, this.keypass, fileInputStream);
            }
            catch (Exception exception) {
                throw new Exception(this.command + " failed: " + exception.toString());
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        } else {
            try {
                this.appdesc.addJarSignature(this.alias, this.keypass);
            }
            catch (Exception exception) {
                throw new Exception(this.command + " failed: " + exception.toString());
            }
        }
        this.appdesc.store(this.outstream, this.encoding);
    }

    private void performAddCertCommand(String[] stringArray) throws Exception {
        int n = 1;
        this.certIndex = 0;
        try {
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-encoding")) {
                    this.encoding = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-keystore")) {
                    this.keystore = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-storepass")) {
                    this.storepass = stringArray[++n].toCharArray();
                    continue;
                }
                if (stringArray[n].equals("-alias")) {
                    this.alias = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-certnum")) {
                    this.certnum = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-chainnum")) {
                    this.chainNum = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-inputjad")) {
                    this.infile = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-outputjad")) {
                    this.outfile = stringArray[++n];
                    continue;
                }
                this.usageError("Illegal option for " + this.command + ": " + stringArray[n]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError("Missing value for " + stringArray[--n]);
        }
        this.checkCertAndChainNum();
        this.initJadUtil();
        this.openKeystoreAndOutputJad();
        try {
            this.appdesc.addCert(this.alias, this.chainIndex, this.certIndex);
            this.appdesc.store(this.outstream, this.encoding);
            return;
        }
        catch (Exception exception) {
            throw new Exception(this.command + " failed: " + exception.toString());
        }
    }

    private void performShowCertCommand(String[] stringArray) throws Exception {
        X509Certificate x509Certificate;
        int n = 1;
        boolean bl = false;
        try {
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-encoding")) {
                    this.encoding = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-certnum")) {
                    this.certnum = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-chainnum")) {
                    this.chainNum = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-all")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equals("-inputjad")) {
                    this.infile = stringArray[++n];
                    continue;
                }
                this.usageError("Illegal option for " + this.command + ": " + stringArray[n]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError("Missing value for " + stringArray[--n]);
        }
        if (bl && (this.chainNum != null || this.certnum != null)) {
            this.usageError("-all cannot be used with -certnum or -chainnum");
        }
        this.checkCertAndChainNum();
        this.initJadUtil();
        if (bl) {
            Vector vector = this.appdesc.getAllCerts();
            if (vector.size() == 0) {
                System.out.println("\nNo certificates found in JAD.\n");
                return;
            }
            System.out.println();
            for (n = 0; n < vector.size(); ++n) {
                Object[] objectArray = (Object[])vector.elementAt(n);
                System.out.println((String)objectArray[AppDescriptor.KEY] + ":");
                this.displayCert((X509Certificate)objectArray[AppDescriptor.CERT]);
            }
            return;
        }
        try {
            x509Certificate = this.appdesc.getCert(this.chainIndex, this.certIndex);
        }
        catch (Exception exception) {
            throw new Exception("-showcert failed: " + exception.toString());
        }
        if (x509Certificate == null) {
            throw new Exception("Certificate " + this.chainIndex + "-" + this.certIndex + " not in JAD");
        }
        try {
            this.displayCert(x509Certificate);
            return;
        }
        catch (Exception exception) {
            throw new Exception("-showcert failed: " + exception.toString());
        }
    }

    private void checkCertAndChainNum() {
        if (this.certnum != null) {
            try {
                this.certIndex = Integer.valueOf(this.certnum);
                if (this.certIndex <= 0) {
                    this.usageError("-certnum must be a positive number");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.usageError("-certnum must be a positive number");
            }
        }
        if (this.chainNum != null) {
            try {
                this.chainIndex = Integer.valueOf(this.chainNum);
                if (this.chainIndex <= 0) {
                    this.usageError("-chainnum must be a positive number");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.usageError("-chainnum must be a positive number");
            }
        }
    }

    private void initJadUtil() throws Exception {
        BufferedInputStream bufferedInputStream;
        if (this.infile == null) {
            this.usageError(this.command + " requires an input JAD");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.infile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Input JAD does not exist: " + this.infile);
        }
        try {
            this.appdesc = new AppDescriptor();
            this.appdesc.load(bufferedInputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Exception("Encoding type " + this.encoding + " not supported");
        }
        catch (IOException iOException) {
            throw new Exception("Error parsing input JAD: " + this.infile);
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openKeystoreAndOutputJad() throws Exception {
        FileInputStream fileInputStream;
        if (this.alias == null) {
            this.usageError(this.command + " requires -alias");
        }
        if (this.outfile == null) {
            this.usageError(this.command + " requires an output JAD");
        }
        if (this.keystore == null) {
            this.keystore = System.getProperty("user.home") + File.separator + ".keystore";
        }
        try {
            File file = new File(this.keystore);
            if (file.exists() && file.length() == 0L) {
                throw new Exception("Keystore exists, but is empty: " + this.keystore);
            }
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Keystore does not exist: " + this.keystore);
        }
        try {
            try {
                this.outstream = new FileOutputStream(this.outfile);
            }
            catch (IOException iOException) {
                throw new Exception("Error opening output JAD: " + this.outfile);
            }
            try {
                this.appdesc.loadKeyStore(fileInputStream, this.storepass);
            }
            catch (Exception exception) {
                throw new Exception("Keystore could not be loaded: " + exception.toString());
            }
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void help() {
        this.usage(0);
    }

    private void usageError(String string) {
        System.err.println("\n" + string);
        this.usage(-1);
    }

    private void usage(int n) {
        System.out.println(USAGE);
        System.exit(n);
    }

    private void displayCert(X509Certificate x509Certificate) throws Exception {
        System.out.println();
        System.out.println("Subject: " + x509Certificate.getSubjectDN().getName());
        System.out.println("Issuer : " + x509Certificate.getIssuerDN().getName());
        System.out.println("Serial number: " + x509Certificate.getSerialNumber().toString(16));
        System.out.println("Valid from " + x509Certificate.getNotBefore() + " to " + x509Certificate.getNotAfter());
        System.out.println("Certificate fingerprints:");
        System.out.print("  MD5: ");
        String string = AppDescriptor.createFingerprint(x509Certificate.getEncoded(), "MD5");
        System.out.println(string);
        System.out.print("  SHA: ");
        string = AppDescriptor.createFingerprint(x509Certificate.getEncoded(), "SHA");
        System.out.println(string);
        System.out.println();
    }
}

