/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.jadtool;

import com.sun.midp.jadtool.AppDescriptorException;
import com.sun.midp.jadtool.Base64;
import com.sun.midp.jadtool.JadWriter;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class AppDescriptor
extends JadProperties {
    public static int KEY = 0;
    public static int CERT = 1;
    public static final String JAR_SIGNATURE = "MIDlet-Jar-RSA-SHA1";
    public static final String CP_ATTR = "MIDlet-Certificate-";
    public static final String JAR_URL = "MIDlet-Jar-URL";
    public static final String JAR_SIZE = "MIDlet-Jar-Size";
    public static final String SEP_ATTR = ": ";
    public static final String SIGN_ALG = "SHA1withRSA";
    private KeyStore keystore = null;

    public synchronized void load(InputStream inputStream, String string) throws UnsupportedEncodingException, IOException, InvalidJadException {
        super.load(inputStream, string);
    }

    public synchronized void store(OutputStream outputStream, String string) throws UnsupportedEncodingException, IOException {
        if (string != null) {
            JadWriter.write(this, outputStream, string);
        } else {
            JadWriter.write(this, outputStream);
        }
    }

    public synchronized void loadKeyStore(InputStream inputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, Exception {
        try {
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keystore.load(inputStream, cArray);
        }
        catch (Exception exception) {
            throw new Exception("loadKeyStore failed");
        }
    }

    public synchronized void storeKeyStore(String string, char[] cArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.keystore.store(fileOutputStream, cArray);
        fileOutputStream.close();
    }

    public void addJarSignature(String string, char[] cArray) throws AppDescriptorException, MalformedURLException, IOException, KeyStoreException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = this.getProperty(JAR_URL);
        if (string2 == null) {
            throw new AppDescriptorException("MIDlet-Jar-URL not in descriptor");
        }
        URL uRL = new URL(string2);
        InputStream inputStream = uRL.openStream();
        this.addJarSignature(string, cArray, inputStream);
    }

    public void addJarSignature(String string, char[] cArray, InputStream inputStream) throws IOException, NoSuchAlgorithmException, KeyStoreException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.setProperty(JAR_SIGNATURE, this.getEncodedSig(string, cArray, inputStream));
    }

    public void addCert(String string, int n, int n2) throws CertificateException, KeyStoreException, AppDescriptorException {
        String string2 = this.getEncodedCertificate(string);
        String string3 = CP_ATTR + n + "-";
        if (n2 != 0) {
            this.setProperty(string3 + n2, string2);
            return;
        }
        int n3 = 1;
        while (this.getProperty(string3 + n3) != null) {
            ++n3;
        }
        this.addProperty(string3 + n3, string2);
    }

    public X509Certificate getCert(int n, int n2) throws CertificateException {
        X509Certificate x509Certificate = null;
        String string = this.getProperty(CP_ATTR + n + "-" + n2);
        if (string != null) {
            x509Certificate = this.base64CertToX509Cert(string);
        }
        return x509Certificate;
    }

    public X509Certificate getCertAttribute(int n, int n2) throws CertificateException {
        X509Certificate x509Certificate = null;
        String string = this.getProperty(CP_ATTR + n + "-" + n2);
        if (string != null) {
            x509Certificate = this.base64CertToX509Cert(string);
        }
        return x509Certificate;
    }

    public Vector getAllCerts() throws CertificateException {
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < this.size(); ++i) {
            String string = this.getKeyAt(i);
            String string2 = this.getValueAt(i);
            if (!string.startsWith(CP_ATTR)) continue;
            X509Certificate x509Certificate = this.base64CertToX509Cert(string2);
            Object[] objectArray = new Object[2];
            objectArray[AppDescriptor.KEY] = string;
            objectArray[AppDescriptor.CERT] = x509Certificate;
            vector.addElement(objectArray);
        }
        return vector;
    }

    public String getCertDigest(int n, int n2, String string) throws NoSuchAlgorithmException {
        String string2 = null;
        String string3 = this.getProperty(CP_ATTR + n + "-" + n2);
        if (string3 != null) {
            byte[] byArray = Base64.decode(string3);
            string2 = AppDescriptor.createFingerprint(byArray, string);
        }
        return string2;
    }

    private String getEncodedCertificate(String string) throws KeyStoreException, CertificateException, AppDescriptorException {
        if (this.keystore == null) {
            throw new AppDescriptorException(4);
        }
        Certificate certificate = this.keystore.getCertificate(string);
        if (certificate == null) {
            throw new CertificateException("Certificate not found");
        }
        byte[] byArray = certificate.getEncoded();
        return Base64.encode(byArray);
    }

    private int getNextCertIndex(String string) {
        String string2;
        int n;
        for (n = 1; n > 0 && (string2 = this.getProperty(string + n)) != null; ++n) {
        }
        return n;
    }

    static String createFingerprint(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            int n = byArray2[i] & 0xFF;
            String string2 = Integer.toHexString(n);
            if (i != 0) {
                stringBuffer.append(":");
            }
            if (string2.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String getEncodedSig(String string, char[] cArray, InputStream inputStream) throws KeyStoreException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        int n;
        byte[] byArray = new byte[10240];
        Signature signature = Signature.getInstance(SIGN_ALG);
        Key key = this.keystore.getKey(string, cArray);
        signature.initSign((PrivateKey)key);
        while ((n = inputStream.read(byArray)) != -1) {
            signature.update(byArray, 0, n);
        }
        byte[] byArray2 = signature.sign();
        return Base64.encode(byArray2);
    }

    private X509Certificate getVerifyCert(String string) throws AppDescriptorException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        X509Certificate x509Certificate3 = null;
        Certificate certificate = null;
        String string2 = null;
        String string3 = null;
        Object var9_8 = null;
        certificate = this.keystore.getCertificate(string);
        byte[] byArray = certificate.getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string2 = x509Certificate3.getSubjectDN().getName();
        int n = 1;
        while ((x509Certificate2 = this.getCert(1, n)) != null) {
            string3 = x509Certificate2.getIssuerDN().getName();
            if (string2.equals(string3)) {
                x509Certificate2.verify(certificate.getPublicKey());
                x509Certificate2.checkValidity();
                x509Certificate = x509Certificate2;
                break;
            }
            ++n;
        }
        return x509Certificate;
    }

    private X509Certificate base64CertToX509Cert(String string) throws CertificateException {
        X509Certificate x509Certificate = null;
        byte[] byArray = Base64.decode(string);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return x509Certificate;
    }
}

