/*
 * Decompiled with CFR 0.152.
 */
package example.photoalbum;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class TestChart {
    int w;
    int h;
    Font font;
    int fh;
    int titleHeight;
    int pad;
    int pieSize;
    int barSize;
    int frameno;

    public Vector generateImages() {
        Vector<Image> vector = new Vector<Image>(4);
        this.frameno = 0;
        while (this.frameno < 4) {
            Image image = Image.createImage((int)this.w, (int)this.h);
            this.paint(image.getGraphics());
            vector.addElement(image);
            ++this.frameno;
        }
        return vector;
    }

    public TestChart(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fh = this.font.getHeight();
        this.pad = 2;
        this.titleHeight = this.fh + this.pad * 2;
        this.barSize = this.h - (this.titleHeight + this.pad);
        if (this.barSize < 10) {
            this.barSize = 10;
        }
        if (this.barSize > (this.w - this.pad) / 2) {
            this.barSize = (this.w - this.pad) / 2;
        }
        this.pieSize = this.barSize;
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.setGrayScale(255);
        graphics.fillRect(0, 0, this.w, this.h);
        int n = this.pad * 2 + this.font.stringWidth("Chart Samples");
        int n2 = (this.w - n) / 2;
        graphics.setGrayScale(128);
        graphics.fillRoundRect(n2, 0, n, this.fh, 5, 5);
        graphics.setGrayScale(0);
        graphics.drawRoundRect(n2, 0, n, this.fh, 5, 5);
        graphics.setColor(0, 0, 0);
        graphics.drawString("Chart Samples", n2 + this.pad, this.pad, 20);
        graphics.translate(0, this.titleHeight + this.pad);
        graphics.setColor(255, 0, 0);
        graphics.fillArc(0, 0, this.pieSize, this.pieSize, 45, 270);
        graphics.setColor(0, 255, 0);
        graphics.fillArc(0, 0, this.pieSize, this.pieSize, 0, 45);
        graphics.setColor(0, 0, 255);
        graphics.fillArc(0, 0, this.pieSize, this.pieSize, 0, -45);
        graphics.setColor(0);
        graphics.drawArc(0, 0, this.pieSize, this.pieSize, 0, 360);
        int n3 = this.barSize;
        int n4 = this.barSize / 3;
        int n5 = this.barSize / 2;
        int n6 = this.barSize;
        int n7 = (n4 + n5 + n6) / 3;
        graphics.translate((this.w + this.pad) / 2, 0);
        int n8 = this.pieSize / 7;
        if (n8 < 2) {
            n8 = 2;
        }
        if (this.frameno > 0) {
            graphics.setColor(255, 0, 0);
            graphics.fillRect(n8 * 1, n3 - n4, n8 + 1, n4);
        }
        if (this.frameno > 1) {
            graphics.setColor(0, 255, 0);
            graphics.fillRect(n8 * 3, n3 - n5, n8 + 1, n5);
        }
        if (this.frameno > 2) {
            graphics.setColor(0, 0, 255);
            graphics.fillRect(n8 * 5, n3 - n6, n8 + 1, n6);
        }
        graphics.setColor(0);
        graphics.drawRect(n8 * 1, n3 - n4, n8, n4);
        graphics.drawRect(n8 * 3, n3 - n5, n8, n5);
        graphics.drawRect(n8 * 5, n3 - n6, n8, n6);
        graphics.setGrayScale(0);
        graphics.drawLine(0, 0, 0, n3);
        graphics.drawLine(0, n3, this.barSize, n3);
        graphics.setStrokeStyle(1);
        graphics.drawLine(0, n3 - n7, this.barSize, n3 - n7);
        graphics.setStrokeStyle(0);
        graphics.translate(-(this.w + this.pad) / 2, this.pieSize + this.pad);
    }
}

