/*
 * Decompiled with CFR 0.152.
 */
package example.photoalbum;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class PhotoFrame
extends Canvas
implements Runnable {
    private int style;
    private int speed;
    private Vector images;
    private int index;
    private int imageX;
    private int imageY;
    private int imageWidth;
    private int imageHeight;
    private Thread thread;
    private Image image = Image.createImage((int)this.getWidth(), (int)this.getHeight());
    private Image bimage;
    private long paintTime;
    private long statsTime;
    int frameCount;
    int frameRate;
    private static final int[] speeds = new int[]{999999999, 500, 250, 100, 0};

    PhotoFrame() {
        this.setStyle(0);
        this.setSpeed(0);
    }

    void setImages(Vector vector) {
        this.images = vector;
        if (vector.size() > 0) {
            Image image = (Image)vector.elementAt(0);
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        this.index = 0;
        this.imageX = (this.getWidth() - this.imageWidth) / 2;
        this.imageY = (this.getHeight() - this.imageHeight) / 2;
        this.genFrame(this.style, this.imageX, this.imageY, this.imageWidth, this.imageHeight);
    }

    void next() {
        if (this.images == null || ++this.index >= this.images.size()) {
            this.index = 0;
        }
    }

    void previous() {
        this.index = this.images != null && --this.index < 0 ? this.images.size() - 1 : 0;
    }

    void reset() {
        this.images = null;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 5: {
                if (this.thread != null) break;
                this.next();
                this.repaint();
                break;
            }
            case 2: {
                if (this.thread != null) break;
                this.previous();
                this.repaint();
                break;
            }
            case 8: {
                if (this.thread == null) {
                    this.thread = new Thread(this);
                    this.thread.start();
                    break;
                }
                PhotoFrame photoFrame = this;
                synchronized (photoFrame) {
                    this.notify();
                }
                this.thread = null;
            }
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    void setSpeed(int n) {
        this.speed = n;
        this.statsTime = 0L;
    }

    int getSpeed() {
        return this.speed;
    }

    void setStyle(int n) {
        this.style = n;
        this.genFrame(n, this.imageX, this.imageY, this.imageWidth, this.imageHeight);
    }

    int getStyle() {
        return this.style;
    }

    protected void showNotify() {
        if (this.images != null && this.images.size() > 1) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void hideNotify() {
        this.thread = null;
    }

    boolean intersectsClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        if (n + n3 <= n5) {
            return false;
        }
        int n6 = graphics.getClipWidth();
        if (n > n5 + n6) {
            return false;
        }
        int n7 = graphics.getClipY();
        if (n2 + n4 <= n7) {
            return false;
        }
        int n8 = graphics.getClipHeight();
        return n2 <= n7 + n8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        Thread thread = Thread.currentThread();
        this.statsTime = l = System.currentTimeMillis();
        this.paintTime = l;
        this.frameCount = 0;
        this.frameRate = 0;
        while (this.thread == thread) {
            long l2 = (l += (long)speeds[this.speed]) - this.paintTime;
            if (l2 > 0L) {
                PhotoFrame photoFrame = this;
                synchronized (photoFrame) {
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.next();
            this.repaint();
            this.serviceRepaints();
        }
    }

    protected void paint(Graphics graphics) {
        this.paintTime = System.currentTimeMillis();
        if (this.image != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = graphics.getClipX();
            if (n < this.imageX || (n2 = graphics.getClipY()) < this.imageY || n + (n3 = graphics.getClipWidth()) > this.imageX + this.imageWidth || n2 + (n4 = graphics.getClipHeight()) > this.imageY + this.imageHeight) {
                graphics.drawImage(this.image, 0, 0, 20);
                if (this.frameRate > 0) {
                    graphics.fillRect(0, this.getHeight(), 60, 20);
                    graphics.drawString("FPS = " + this.frameRate, 0, this.getHeight(), 36);
                }
            }
            if (this.images != null && this.index < this.images.size() && this.intersectsClip(graphics, this.imageX, this.imageY, this.imageWidth, this.imageHeight)) {
                graphics.drawImage((Image)this.images.elementAt(this.index), this.imageX, this.imageY, 20);
            }
            ++this.frameCount;
            int n5 = (int)(this.paintTime - this.statsTime);
            if (n5 > 1000 && n5 < 10000) {
                this.frameRate = (this.frameCount * 1000 + 500) / n5;
                this.frameCount = 0;
                this.statsTime = this.paintTime;
                this.repaint();
            }
        }
    }

    private void genFrame(int n, int n2, int n3, int n4, int n5) {
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.image.getWidth() + 1, this.image.getHeight() + 1);
        graphics.translate(n2, n3);
        this.paintBorder(graphics, n, n4, n5);
    }

    private void paintBorder(Graphics graphics, int n, int n2, int n3) {
        if (n == 1) {
            graphics.setGrayScale(128);
            graphics.drawRect(-1, -1, n2 + 1, n3 + 1);
            graphics.drawRect(-2, -2, n2 + 3, n3 + 3);
        }
        if (n == 2) {
            int n4;
            if (this.bimage == null) {
                this.bimage = this.genBorder();
            }
            int n5 = this.bimage.getWidth();
            int n6 = this.bimage.getHeight();
            graphics.setGrayScale(128);
            graphics.drawRect(-1, -1, n2 + 1, n3 + 1);
            graphics.drawRect(-n5 - 2, -n6 - 2, n2 + n5 * 2 + 3, n3 + n6 * 2 + 3);
            graphics.drawImage(this.bimage, -1, -1, 40);
            graphics.drawImage(this.bimage, -1, n3 + 1, 24);
            graphics.drawImage(this.bimage, n2 + 1, -1, 36);
            graphics.drawImage(this.bimage, n2 + 1, n3 + 1, 20);
            for (n4 = n3 % n6 / 2; n4 < n3 - n6; n4 += n6) {
                graphics.drawImage(this.bimage, -1, n4, 24);
                graphics.drawImage(this.bimage, n2 + 1, n4, 20);
            }
            for (n4 = n2 % n5 / 2; n4 < n2 - n5; n4 += n5) {
                graphics.drawImage(this.bimage, n4, -1, 36);
                graphics.drawImage(this.bimage, n4, n3 + 1, 20);
            }
        }
    }

    private Image genBorder() {
        Image image = Image.createImage((int)5, (int)5);
        Graphics graphics = image.getGraphics();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 5, 5);
        graphics.setColor(128, 0, 255);
        graphics.drawLine(2, 1, 2, 3);
        graphics.drawLine(1, 2, 3, 2);
        return image;
    }
}

