/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2mews.sg;

import com.sun.j2mews.sg.AbstractGenerator;
import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;

public class StubGenerator
extends AbstractGenerator
implements ProcessorAction {
    public static final int UNBOUNDED = -1;
    protected boolean useWSIBasicProfile = false;
    protected boolean cldc1_0InfoAlready = false;
    protected boolean cldc1_0InfoAlreadyConverted = false;
    protected Map qnames;
    protected Map varNameToQNames;
    protected Map typeNames;
    protected LinkedHashMap types;
    protected Map faultNames;
    protected Map originalTypes;
    protected Map usedTypes;
    protected Map methodNames;
    protected boolean floatDoubleWarning = false;
    protected boolean genDebug = false;
    protected boolean hasUserExceptions = false;
    protected boolean faultDetailHandlerIsInnerClass = false;
    protected String prepOperationMethodName = "_prepOperation";
    protected String javaxMicroeditionXmlRpc = "javax.microedition.xml.rpc";

    public StubGenerator() {
        this.messageFactory = new LocalizableMessageFactory("com.sun.j2mews.sg.stubgenerator");
        this.originalTypes = new HashMap();
    }

    public void setOriginalTypes(Map map) {
        this.originalTypes = map;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        this.useWSIBasicProfile = Boolean.valueOf(properties.getProperty("useWSIBasicProfile"));
        this.floatDoubleWarning = "true".equals(properties.getProperty("FLOAT_DOUBLE_TO_STRING"));
        super.perform(model, configuration, properties);
    }

    protected void generate() throws IOException {
        this.qnames = new HashMap();
        this.varNameToQNames = new HashMap();
        this.usedTypes = new HashMap();
        this.typeNames = new HashMap();
        this.types = new LinkedHashMap();
        this.faultNames = new HashMap();
        this.methodNames = new HashMap();
        if (this.optimize) {
            this.prepOperationMethodName = "_prep";
        }
        Iterator iterator = this.port.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            JavaMethod javaMethod = operation.getJavaMethod();
            if (javaMethod.getExceptionsList().size() > 0) {
                this.hasUserExceptions = true;
            }
            String string = javaMethod.getName();
            this.methodNames.put(string, javaMethod);
            if (!"handleFault".equals(string)) continue;
            this.faultDetailHandlerIsInnerClass = true;
        }
        super.generate();
    }

    protected String getFullClassName() {
        return this.env.getNames().stubFor(this.port, null);
    }

    protected File getSourceFile() {
        return this.env.getNames().sourceFileForClass(this.fullClassName, this.fullClassName, this.sourceDir, this.env);
    }

    protected String getSourceFileType() {
        return "Stub";
    }

    protected void writeImports() throws IOException {
        this.jw.writeImport("javax.xml.rpc.JAXRPCException");
        this.jw.writeImport("javax.xml.namespace.QName");
        this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".Operation");
        this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".Type");
        this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".ComplexType");
        this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".Element");
        if (this.hasUserExceptions) {
            this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".FaultDetailException");
            this.jw.writeImport(this.javaxMicroeditionXmlRpc + ".FaultDetailHandler");
        }
        this.jw.cr();
    }

    protected void generateClass() throws IOException {
        JavaInterface javaInterface = this.port.getJavaInterface();
        String string = javaInterface.getName() + ", javax.xml.rpc.Stub";
        if (this.hasUserExceptions && !this.faultDetailHandlerIsInnerClass) {
            string = string + ", FaultDetailHandler";
        }
        this.jw.writeClassDecl(this.className, null, string, 0);
        this.jw.select(this.jw.CONSTRUCTOR_SECTION);
        this.jw.beginConstructor(this.className);
        String string2 = this.port.getAddress();
        if (string2 == null) {
            this.jw.writeEol("_propertyNames = new String[0]");
            this.jw.writeEol("_propertyValues = new Object[0]");
        } else {
            this.jw.writeEol("_propertyNames = new String[] {ENDPOINT_ADDRESS_PROPERTY}");
            this.jw.writeEol("_propertyValues = new Object[] {\"" + string2 + "\"}");
        }
        this.jw.end();
        this.jw.cr();
        this.generateProperties();
        this.jw.select(this.jw.BODY_SECTION);
        this.jw.comment("");
        this.jw.comment(" Begin user methods");
        this.jw.comment("");
        this.generateUserMethods(this.port);
        this.jw.comment("");
        this.jw.comment(" End user methods");
        this.jw.comment("");
        this.jw.cr();
        if (this.genDebug) {
            this.jw.beginMethod("printObjects", "Object o", null, "void", 3);
            this.jw.beginIf("o == null");
            this.jw.writeEol("System.out.print(\"null\")");
            this.jw.writeEol("return");
            this.jw.end();
            this.jw.beginIf("o.getClass().isArray()");
            this.jw.writeEol("Object[] a = (Object[]) o");
            this.jw.writeEol("System.out.print(\"{\")");
            this.jw.beginFor("int i = 0", "i < a.length", "++i");
            this.jw.beginIf("i > 0");
            this.jw.writeEol("System.out.print(\", \")");
            this.jw.end();
            this.jw.writeEol("System.out.print(\"[\"+i+\"]=\")");
            this.jw.writeEol("printObjects(a[i])");
            this.jw.end();
            this.jw.writeEol("System.out.print(\"}\")");
            this.jw.endElseBegin();
            this.jw.writeEol("System.out.print(\"\\\"\"+o+\"\\\"\")");
            this.jw.end();
            this.jw.end();
            this.jw.cr();
        }
        this.generateQNameVars();
        this.generateInitTypes();
        this.generateFaultHandler();
        this.jw.select(this.jw.DECL_SECTION);
        this.jw.cr();
    }

    protected void generateProperties() throws IOException {
        this.jw.select(this.jw.DECL_SECTION);
        this.jw.writeEol("private String[] _propertyNames");
        this.jw.writeEol("private Object[] _propertyValues");
        this.jw.select(this.jw.BODY_SECTION);
        this.jw.beginMethod("_setProperty", "String name, Object value");
        this.jw.writeEol("int size = _propertyNames.length");
        this.jw.beginFor("int i = 0", "i < size", "++i");
        this.jw.beginIf("_propertyNames[i].equals(name)");
        this.jw.writeEol("_propertyValues[i] = value");
        this.jw.writeEol("return");
        this.jw.end();
        this.jw.end();
        this.jw.comment("Need to expand our array for a new property");
        this.jw.writeEol("String[] newPropNames = new String[size + 1]");
        this.jw.writeEol("System.arraycopy(_propertyNames, 0, newPropNames, 0, size)");
        this.jw.writeEol("_propertyNames = newPropNames");
        this.jw.writeEol("Object[] newPropValues = new Object[size + 1]");
        this.jw.writeEol("System.arraycopy(_propertyValues, 0, newPropValues, 0, size)");
        this.jw.writeEol("_propertyValues = newPropValues");
        this.jw.cr();
        this.jw.writeEol("_propertyNames[size] = name");
        this.jw.writeEol("_propertyValues[size] = value");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod("_getProperty", "String name", null, "Object");
        this.jw.beginFor("int i = 0", "i < _propertyNames.length", "++i");
        this.jw.beginIf("_propertyNames[i].equals(name)");
        this.jw.writeEol("return _propertyValues[i]");
        this.jw.end();
        this.jw.end();
        this.jw.beginIf("ENDPOINT_ADDRESS_PROPERTY.equals(name) || USERNAME_PROPERTY.equals(name) || PASSWORD_PROPERTY.equals(name)");
        this.jw.writeEol("return null");
        this.jw.end();
        this.jw.beginIf("SESSION_MAINTAIN_PROPERTY.equals(name)");
        this.jw.writeEol("return new java.lang.Boolean(false)");
        this.jw.end();
        this.jw.writeEol("throw new JAXRPCException(", this.localize(this.getMessage("stubgenerator.unrecognizedProperty", "name")), ")");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod(this.prepOperationMethodName, "Operation op", null, "void", 1);
        this.jw.beginFor("int i = 0", "i < _propertyNames.length", "++i");
        this.jw.writeEol("op.setProperty(_propertyNames[i], _propertyValues[i].toString())");
        this.jw.end();
        this.jw.end();
        this.jw.cr();
    }

    protected void generateUserMethods(Port port) throws IOException {
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            JavaInterface javaInterface = port.getJavaInterface();
            this.generateUserMethods(operation, javaInterface);
        }
    }

    protected void generateUserMethods(Operation operation, JavaInterface javaInterface) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        JavaMethod javaMethod = operation.getJavaMethod();
        String string2 = javaMethod.getName();
        QName qName = operation.getName();
        String string3 = qName.getLocalPart();
        if (qName.getNamespaceURI() == null || "".equals(qName.getNamespaceURI())) {
            qName = new QName(this.port.getName().getNamespaceURI(), string3);
        }
        this.jw.cr();
        if (operation.getStyle() != SOAPStyle.DOCUMENT || operation.getUse() != SOAPUse.LITERAL) {
            String string4 = this.styleToString(operation.getStyle());
            String string5 = this.useToString(operation.getUse());
            Localizable localizable = this.getMessage("stubgenerator.wrongStyleOrUse", string3, string4, string5);
            this.commentWarning(localizable);
            return;
        }
        if (!this.isValid(operation, this.usedTypes)) {
            Localizable localizable = this.getMessage("stubgenerator.operationHasInvalidType", string3);
            this.commentWarning(localizable);
            return;
        }
        JavaType javaType = javaMethod.getReturnType();
        JavaType javaType2 = this.getExpandedReturnType(javaMethod);
        String string6 = this.javaTypeToString(javaType2);
        boolean bl = javaType2 == null || "void".equals(string6);
        HashMap<String, JavaParameter> hashMap = new HashMap<String, JavaParameter>();
        hashMap.putAll(this.methodNames);
        this.jw.write("public ");
        if (bl) {
            this.jw.write("void");
        } else {
            this.jw.write(string6);
        }
        this.jw.write(" ");
        this.jw.write(string2);
        this.jw.write("(");
        this.jw.setFirst(", ");
        List list = this.getExpandedParametersList(javaMethod);
        int n2 = list.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaParameter javaParameter = (JavaParameter)iterator.next();
            object5 = javaParameter.getType();
            string = this.javaTypeToString((JavaType)object5);
            this.jw.writeNext(string, " ", javaParameter.getName());
            hashMap.put(javaParameter.getName(), javaParameter);
        }
        this.jw.write(")");
        this.jw.write(" throws java.rmi.RemoteException");
        boolean bl2 = false;
        object5 = javaMethod.getExceptions();
        while (object5.hasNext()) {
            bl2 = true;
            string = (String)object5.next();
            this.jw.write(", ");
            this.jw.write(string);
        }
        this.jw.write(" ");
        this.jw.begin();
        string = this.makeUniq("resultObj", hashMap);
        String string7 = this.makeUniq("result", hashMap);
        String string8 = null;
        Object object6 = null;
        if (javaMethod.getParameterCount() > 0) {
            String string9;
            if (javaMethod.getParameterCount() > 1) {
                this.onWarning(this.getMessage("stubgenerator.moreThanOneParameter", string2));
            }
            object4 = javaMethod.getParameters();
            while (object4.hasNext()) {
                object3 = (JavaParameter)object4.next();
                Parameter parameter = object3.getParameter();
                object2 = parameter.getBlock();
                JavaType javaType3 = object3.getType();
                string9 = this.javaTypeToString(javaType3);
                object = this.convertJavaTypeToType(javaType3);
                boolean bl3 = parameter.getType().isNillable();
                if (!bl3) {
                    bl3 = this.forceNillable(javaType3, string2);
                }
                boolean bl4 = false;
                Element element = this.getElement(object2.getName(), (Type)object, false, bl3, bl4);
                element.setTopLevel(true);
                string8 = element.getVarName();
            }
            object3 = list.iterator();
            this.jw.comment("Copy the incoming values into an Object array if needed.");
            boolean bl5 = list.size() > 1 || list != javaMethod.getParametersList();
            object2 = null;
            if (bl5) {
                object2 = this.instanceOf("input", "Object", hashMap);
                this.jw.writeEol("Object[] ", (String)object2, " = new Object[" + list.size(), "]");
            }
            n = 0;
            while (object3.hasNext()) {
                string9 = (JavaParameter)object3.next();
                object = string9.getName();
                JavaType javaType4 = string9.getType();
                object6 = this.genMakeInputObject(javaType4, hashMap, (String)object);
                if (bl5) {
                    this.jw.writeEol((String)object2, "[" + n, "] = ", (String)object6);
                }
                ++n;
            }
            if (bl5) {
                object6 = object2;
            }
        }
        if (this.genDebug) {
            this.jw.writeEol("System.out.print(\"Input objects: \")");
            this.jw.writeEol("printObjects(", object6, ")");
            this.jw.writeEol("System.out.println()");
        }
        object4 = null;
        if (!bl) {
            object3 = this.convertJavaTypeToType(javaType);
            QName qName2 = null;
            object2 = operation.getResponse();
            n = 0;
            boolean bl6 = false;
            object = object2.getParameters();
            while (object.hasNext()) {
                Parameter parameter = (Parameter)object.next();
                Block block = parameter.getBlock();
                qName2 = block.getName();
                n = parameter.getType().isNillable();
            }
            Element element = this.getElement(qName2, (Type)object3, false, n != 0, bl6);
            element.setTopLevel(true);
            object4 = element.getVarName();
        }
        this.jw.cr();
        this.jw.write("Operation op = Operation.newInstance(", this.getQNameVar(qName), ", ");
        this.jw.write(string8, ", ", (String)object4);
        if (bl2) {
            if (this.faultDetailHandlerIsInnerClass) {
                this.jw.write(", _myFaultDetailHandler");
            } else {
                this.jw.write(", this");
            }
        }
        this.jw.writeEol(")");
        this.jw.writeEol(this.prepOperationMethodName, "(op)");
        object3 = operation.getSOAPAction();
        if (object3 == null) {
            object3 = "";
        }
        this.jw.writeEol("op.setProperty(Operation.SOAPACTION_URI_PROPERTY, ", JavaUtil.instanceFrom((String)"String", (String)operation.getSOAPAction()), ")");
        if (!bl) {
            this.jw.writeEol("Object ", string);
        }
        this.jw.beginTry();
        if (!bl) {
            this.jw.write(string, " = ");
        }
        this.jw.writeEol("op.invoke(", (String)object6, ")");
        this.jw.endCatch("JAXRPCException e");
        String string10 = this.makeUniq("cause", hashMap);
        this.jw.writeEol("Throwable ", string10, " = e.getLinkedCause()");
        this.jw.beginIf(string10 + " instanceof java.rmi.RemoteException");
        this.jw.writeEol("throw (java.rmi.RemoteException) ", string10);
        if (bl2) {
            this.jw.endElseBeginIf(string10 + " instanceof FaultDetailException");
            object2 = this.makeUniq("fde", hashMap);
            String string11 = this.makeUniq("fdeName", hashMap);
            this.jw.writeEol("FaultDetailException ", (String)object2, " = (FaultDetailException) ", string10);
            this.jw.write("QName ", string11);
            this.jw.writeEol(" = ", (String)object2, ".getFaultDetailName()");
            this.genMakeFaults(operation, (String)object2, string11, hashMap);
        }
        this.jw.end();
        this.jw.writeEol("throw e");
        this.jw.end();
        if (this.genDebug) {
            this.jw.writeEol("System.out.print(\"Output objects: \")");
            this.jw.writeEol("printObjects(", string, ")");
            this.jw.writeEol("System.out.println()");
        }
        if (!bl) {
            this.jw.writeEol(string6, " ", string7);
            this.jw.comment("Convert the result into the right Java type.");
            if (javaType == javaType2) {
                this.genMakeOutputObject(string, false, string7, javaType2, hashMap);
            } else {
                this.jw.comment("Unwrapped return value");
                object2 = (JavaStructureType)javaType;
                JavaStructureMember javaStructureMember = (JavaStructureMember)object2.getMembers().next();
                this.genMakeOutputObject(string, false, string7, javaStructureMember, 0, 1, hashMap);
            }
            this.jw.writeEol("return ", string7);
        }
        this.jw.end();
    }

    protected Type convertJavaTypeToType(JavaType javaType) throws IOException {
        String string = this.javaTypeToString(javaType).intern();
        if (javaType instanceof JavaSimpleType) {
            Type type = Type.toType(string);
            if (type == Type.UNKNOWN) {
                this.onError(this.getMessage("stubgenerator.unknownSimpleType", string));
            }
            return type;
        }
        if (javaType instanceof JavaStructureType) {
            Object object;
            JavaStructureType javaStructureType = (JavaStructureType)javaType;
            int n = javaStructureType.getMembersCount();
            ArrayList<Element> arrayList = new ArrayList<Element>(n);
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                Object object2;
                object = (JavaStructureMember)iterator.next();
                String string2 = object.getName();
                JavaType javaType2 = object.getType();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (javaType2 instanceof JavaArrayType) {
                    bl = true;
                }
                QName qName = null;
                Object object3 = object.getOwner();
                if (object3 instanceof AbstractType) {
                    object2 = (AbstractType)object3;
                    qName = object2.getName();
                    if (object2.isNillable()) {
                        bl2 = true;
                    }
                } else if (object3 instanceof LiteralElementMember) {
                    object2 = (LiteralElementMember)object3;
                    qName = object2.getName();
                    if (object2.isNillable()) {
                        bl2 = true;
                    }
                    if (!object2.isRequired()) {
                        bl3 = true;
                    }
                } else {
                    this.jw.comment("!!!!!!! memberOwner is of unknown type: " + object3);
                }
                if (qName == null) {
                    this.onError(this.getMessage("stubgenerator.unknownQNameOfMember", string2));
                }
                object2 = this.convertJavaTypeToType(javaType2);
                Element element = this.getElement(qName, (Type)object2, bl, bl2, bl3);
                arrayList.add(element);
            }
            object = this.getComplexType(javaType, arrayList);
            return object;
        }
        if (javaType instanceof JavaArrayType) {
            JavaArrayType javaArrayType = (JavaArrayType)javaType;
            JavaType javaType3 = javaArrayType.getElementType();
            String string3 = this.javaTypeToString(javaType3);
            Type type = this.convertJavaTypeToType(javaType3);
            return type;
        }
        if (javaType instanceof JavaEnumerationType) {
            JavaEnumerationType javaEnumerationType = (JavaEnumerationType)javaType;
            JavaType javaType4 = javaEnumerationType.getBaseType();
            return this.convertJavaTypeToType(javaType4);
        }
        this.commentWarning(this.getMessage("stubgenerator.unknownType", "convertJavaTypeToType", javaType.toString()));
        return Type.UNKNOWN;
    }

    protected String genMakeInputObject(JavaType javaType, Map map, String string) throws IOException {
        String string2 = this.javaTypeToString(javaType).intern();
        if (javaType instanceof JavaSimpleType) {
            return JavaUtil.toObject((String)string, (String)string2, (boolean)true);
        }
        if (javaType instanceof JavaStructureType) {
            String string3;
            Object object;
            JavaStructureType javaStructureType = (JavaStructureType)javaType;
            int n = javaStructureType.getMembersCount();
            String string4 = this.instanceOf(javaType, "Object", map);
            ArrayList<String> arrayList = new ArrayList<String>(n);
            this.jw.writeEol("Object[] ", string4);
            this.jw.beginIf(string + " == null");
            this.jw.writeEol(string4, " = null");
            this.jw.endElseBegin();
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                object = (JavaStructureMember)iterator.next();
                JavaType javaType2 = object.getType();
                string3 = this.javaTypeToString(javaType2);
                String string5 = string + "." + object.getReadMethod() + "()";
                String string6 = this.genMakeInputObject(javaType2, map, string5);
                arrayList.add(string6);
            }
            this.jw.writeEol(string4, " = new Object[" + n, "]");
            object = arrayList.iterator();
            int n2 = 0;
            while (object.hasNext()) {
                string3 = (String)object.next();
                this.jw.write(string4, "[" + n2, "] = ");
                this.jw.writeEol(string3);
                ++n2;
            }
            this.jw.end();
            return string4;
        }
        if (javaType instanceof JavaArrayType) {
            JavaArrayType javaArrayType = (JavaArrayType)javaType;
            JavaType javaType3 = javaArrayType.getElementType();
            if (javaType3 instanceof JavaSimpleType) {
                return string;
            }
            String string7 = this.javaTypeToString(javaType3);
            String string8 = this.instanceOf(javaType, "Object", map);
            this.jw.writeEol("Object[] ", string8);
            this.jw.beginIf(string + " == null");
            this.jw.writeEol(string8, " = new Object[0]");
            this.jw.endElseBegin();
            this.jw.write(string8, " = new Object[");
            this.jw.writeEol(string, ".length]");
            String string9 = this.instanceOf(javaType, "Index", map);
            String string10 = string + "[" + string9 + "]";
            this.jw.beginFor("int " + string9 + " = 0", string9 + " < " + string + ".length", "++" + string9);
            String string11 = this.genMakeInputObject(javaType3, map, string10);
            this.jw.cr();
            this.jw.write(string8, "[", string9);
            this.jw.writeEol("] = ", string11);
            this.jw.end();
            this.jw.end();
            return string8;
        }
        if (javaType instanceof JavaEnumerationType) {
            JavaEnumerationType javaEnumerationType = (JavaEnumerationType)javaType;
            JavaType javaType4 = javaEnumerationType.getBaseType();
            return this.genMakeInputObject(javaType4, map, string + ".getValue()");
        }
        this.jw.comment(" Hit unknown type: type=" + javaType + " for " + string);
        this.commentWarning(this.getMessage("stubgenerator.unknownType", "genMakeInputObject", javaType.toString()));
        return "unknown type (" + javaType + ") for " + string;
    }

    protected void genMakeOutputObject(String string, boolean bl, String string2, JavaType javaType, Map map) throws IOException {
        String string3 = this.javaTypeToString(javaType).intern();
        if (javaType instanceof JavaSimpleType) {
            if (bl) {
                string = "((Object)" + string + ")";
            }
            this.jw.writeEol(string2, " = ", JavaUtil.fromObject((String)string3, (String)string));
        } else if (javaType instanceof JavaStructureType) {
            JavaStructureType javaStructureType = (JavaStructureType)javaType;
            this.jw.beginIf(string + " == null");
            this.jw.writeEol(string2, " = null");
            this.jw.endElseBegin();
            this.jw.write(string2, " = new ");
            this.jw.writeEol(string3, "()");
            int n = javaStructureType.getMembersCount();
            Iterator iterator = javaStructureType.getMembers();
            int n2 = 0;
            while (iterator.hasNext()) {
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                JavaType javaType2 = javaStructureMember.getType();
                String string4 = this.javaTypeToString(javaType2);
                String string5 = this.instanceOf(javaType2, map);
                this.jw.writeEol(string4, " ", string5);
                this.genMakeOutputObject(string, bl, string5, javaStructureMember, n2, n, map);
                this.jw.writeEol(string2 + "." + javaStructureMember.getWriteMethod() + "(" + string5 + ")");
                ++n2;
            }
            this.jw.end();
        } else if (javaType instanceof JavaArrayType) {
            JavaArrayType javaArrayType = (JavaArrayType)javaType;
            JavaType javaType3 = javaArrayType.getElementType();
            String string6 = this.javaTypeToString(javaType3);
            if (javaType3 instanceof JavaSimpleType) {
                this.jw.write(string2, " = (", string6, "[]) ");
                this.jw.writeEol(string);
            } else {
                this.jw.beginIf(string + " == null");
                this.jw.writeEol(string2, " = null");
                this.jw.endElseBegin();
                if (!bl) {
                    string = "((Object[])" + string + ")";
                }
                String string7 = this.instanceOf(javaType, "Size", map);
                this.jw.write("int ", string7, " = ");
                this.jw.writeEol(string, ".length");
                this.jw.write(string2, " = new ", string6);
                this.jw.writeEol("[", string7, "]");
                String string8 = this.instanceOf(javaType, "Index", map);
                String string9 = string2 + "[" + string8 + "]";
                String string10 = string + "[" + string8 + "]";
                this.jw.beginFor("int " + string8 + " = 0", string8 + " < " + string7, "++" + string8);
                this.genMakeOutputObject(string10, false, string9, javaType3, map);
                this.jw.end();
                this.jw.end();
            }
        } else if (javaType instanceof JavaEnumerationType) {
            JavaEnumerationType javaEnumerationType = (JavaEnumerationType)javaType;
            JavaType javaType4 = javaEnumerationType.getBaseType();
            this.jw.beginIf(string + " == null");
            this.jw.writeEol(string2, " = null");
            this.jw.endElseBegin();
            String string11 = this.instanceOf(javaType, map);
            this.jw.writeEol(this.javaTypeToString(javaType4), " ", string11);
            this.genMakeOutputObject(string, bl, string11, javaType4, map);
            this.jw.write(string2, " = ");
            this.jw.writeEol(string3, ".fromValue(", string11, ")");
            this.jw.end();
        } else {
            this.commentWarning(this.getMessage("stubgenerator.unknownType", "genMakeOutputObject", javaType.toString()));
        }
    }

    protected void genMakeOutputObject(String string, boolean bl, String string2, JavaStructureMember javaStructureMember, int n, int n2, Map map) throws IOException {
        boolean bl2;
        String string3 = javaStructureMember.getName();
        JavaType javaType = javaStructureMember.getType();
        String string4 = this.makeUniq(string3 + "Obj", map);
        if (javaType instanceof JavaSimpleType || javaType instanceof JavaEnumerationType || javaType instanceof JavaArrayType && ((JavaArrayType)javaType).getElementType() instanceof JavaSimpleType) {
            this.jw.write("Object ", string4, " = ");
            bl2 = false;
        } else {
            this.jw.write("Object[] ", string4, " = (Object[]) ");
            bl2 = true;
        }
        if (bl) {
            this.jw.write(string);
        } else {
            this.jw.write("((Object[])", string, ")");
        }
        this.jw.write("[" + n, "]");
        this.jw.eol();
        this.genMakeOutputObject(string4, bl2, string2, javaType, map);
    }

    protected void genMakeFaults(Operation operation, String string, String string2, Map map) throws IOException {
        Iterator iterator = operation.getFaults();
        while (iterator.hasNext()) {
            String string3;
            Object object;
            Element element;
            Fault fault = (Fault)iterator.next();
            Block block = fault.getBlock();
            QName qName = block.getName();
            JavaException javaException = fault.getJavaException();
            boolean bl = javaException.getMembersCount() == 1 && block.getType() instanceof LiteralSimpleType;
            Type type = this.convertJavaTypeToType((JavaType)javaException);
            if (bl && type instanceof ComplexType) {
                ComplexType complexType = (ComplexType)type;
                element = complexType.getElement(0);
                qName = element.getQName();
            } else {
                element = this.getElement(qName, type);
            }
            element.setTopLevel(true);
            this.faultNames.put(qName, element);
            this.jw.beginIf("\"" + qName.getLocalPart() + "\".equals(" + string2 + ".getLocalPart()) && \"" + qName.getNamespaceURI() + "\".equals(" + string2 + ".getNamespaceURI())");
            boolean bl2 = true;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>(javaException.getMembersCount());
            Iterator iterator2 = javaException.getMembers();
            while (iterator2.hasNext()) {
                bl2 = false;
                object = (JavaStructureMember)iterator2.next();
                string3 = this.instanceOf(object.getName(), "_param", map);
                arrayList.add(string3);
                JavaType javaType = object.getType();
                String string4 = this.javaTypeToString(javaType);
                this.jw.writeEol(string4, " ", string3);
                String string5 = bl ? string + ".getFaultDetail()" : "((Object[])" + string + ".getFaultDetail())[" + n + "]";
                this.genMakeOutputObject(string5, false, string3, javaType, map);
                ++n;
            }
            this.jw.write("throw new ");
            this.jw.write(this.javaTypeToString((JavaType)javaException));
            this.jw.write("(");
            this.jw.setFirst(", ");
            object = arrayList.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                this.jw.writeNext(string3);
            }
            this.jw.writeEol(")");
            this.jw.end();
        }
    }

    public boolean isValid(Operation operation, Map map) {
        Iterator iterator;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType = javaMethod.getReturnType();
        String string = operation.getName().getLocalPart();
        if (!this.isValid("Operation " + string + " return type", javaType, map)) {
            return false;
        }
        Iterator iterator2 = javaMethod.getParameters();
        while (iterator2.hasNext()) {
            iterator = (JavaParameter)iterator2.next();
            if (this.isValid("Operation " + string + " parameter " + iterator.getName(), iterator.getType(), map)) continue;
            return false;
        }
        iterator = operation.getFaults();
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            Block block = fault.getBlock();
            JavaException javaException = fault.getJavaException();
            if (this.isValid("Operation " + string + " fault " + fault.getName(), (JavaType)javaException, map)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(String string, JavaType javaType, Map map) {
        String string2 = this.javaTypeToString(javaType);
        if (string2 == null) {
            return true;
        }
        string2 = string2.intern();
        if (javaType instanceof JavaSimpleType) {
            map.put(string2, null);
            if (this.originalTypes.containsKey(javaType)) {
                String string3 = (String)this.originalTypes.get(javaType);
                if (this.showCldc1_0Info) {
                    this.onWarning(this.getMessage("stubgenerator.cldc1_0.warning", string, string3, string2));
                } else if (!this.cldc1_0InfoAlreadyConverted) {
                    this.onWarning(this.getMessage("stubgenerator.cldc1_0.generalInfoConverted"));
                    this.cldc1_0InfoAlreadyConverted = true;
                }
                return true;
            }
            if (string2 == "float" || string2 == "Float" || string2 == "java.lang.Float" || string2 == "double" || string2 == "Double" || string2 == "java.lang.Double") {
                if (this.showCldc1_0Info) {
                    this.onInfo(this.getMessage("stubgenerator.cldc1_0.info", string, string2));
                } else if (!this.cldc1_0InfoAlready) {
                    this.onInfo(this.getMessage("stubgenerator.cldc1_0.generalInfo"));
                    this.cldc1_0InfoAlready = true;
                }
                return true;
            }
            if (string2 == "javax.xml.soap.SOAPElement") {
                this.onError(this.getMessage("stubgenerator.unknownSimpleType", string2));
                return false;
            }
            if (!AbstractGenerator.isValidType(string2)) {
                this.onError(this.getMessage("stubgenerator.invalidType", string, string2));
                return false;
            }
        } else if (javaType instanceof JavaStructureType) {
            JavaStructureType javaStructureType = (JavaStructureType)javaType;
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                if (this.isValid(string + "." + javaStructureMember.getName(), javaStructureMember.getType(), map)) continue;
                return false;
            }
        } else if (javaType instanceof JavaArrayType) {
            JavaArrayType javaArrayType = (JavaArrayType)javaType;
            if (!this.isValid(string + "[]", javaArrayType.getElementType(), map)) {
                return false;
            }
        } else if (javaType instanceof JavaEnumerationType) {
            JavaEnumerationType javaEnumerationType = (JavaEnumerationType)javaType;
            JavaType javaType2 = javaEnumerationType.getBaseType();
            if (!this.isValid(string + " enumeration", javaType2, map)) {
                return false;
            }
        } else {
            this.onWarning(this.getMessage("stubgenerator.unknownType", "isValid", javaType.toString()));
        }
        return true;
    }

    protected void commentWarning(Localizable localizable) throws IOException {
        this.comment(localizable);
        this.onWarning(localizable);
    }

    protected void comment(Localizable localizable) throws IOException {
        this.jw.comment(this.localizer.localize(localizable));
    }

    protected String styleToString(SOAPStyle sOAPStyle) {
        if (sOAPStyle == SOAPStyle.DOCUMENT) {
            return "document";
        }
        if (sOAPStyle == SOAPStyle.RPC) {
            return "rpc";
        }
        return "unknown";
    }

    protected String useToString(SOAPUse sOAPUse) {
        if (sOAPUse == SOAPUse.LITERAL) {
            return "literal";
        }
        if (sOAPUse == SOAPUse.ENCODED) {
            return "encoded";
        }
        return "unknown";
    }

    protected boolean forceNillable(JavaType javaType, String string) {
        String string2 = this.javaTypeToString(javaType);
        return !string2.equals(JavaUtil.fromObjectType((String)string2));
    }

    protected String getQNameVar(QName qName) {
        if (this.qnames.containsKey(qName)) {
            return (String)this.qnames.get(qName);
        }
        String string = this.optimize ? this.makeUniq("_q", this.varNameToQNames) : this.makeVarName(qName, "_qname_", this.varNameToQNames);
        this.varNameToQNames.put(string, qName);
        this.qnames.put(qName, string);
        return string;
    }

    protected void generateQNameVars() throws IOException {
        ArrayList arrayList = new ArrayList(this.qnames.keySet());
        Collections.sort(arrayList, new QNameComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            QName qName = (QName)e;
            this.jw.write("protected static final QName ");
            this.jw.write((String)this.qnames.get(qName));
            this.jw.write(" = new QName(");
            if (qName.getNamespaceURI() == null) {
                this.jw.write("null");
            } else {
                this.jw.write("\"");
                this.jw.write(qName.getNamespaceURI());
                this.jw.write("\"");
            }
            this.jw.write(", \"");
            this.jw.write(qName.getLocalPart());
            this.jw.writeEol("\")");
        }
    }

    protected Element getElement(QName qName, Type type) {
        return this.getElement(qName, type, 1, 1, false);
    }

    protected Element getElement(QName qName, Type type, int n, int n2, boolean bl) {
        String string = this.optimize ? "_t" : this.makeVarName(qName, "_type_", null);
        Element element = new Element(string, this.getQNameVar(qName), qName, type, n, n2, bl);
        if (this.types.containsKey(element)) {
            Object v = this.types.get(element);
            return (Element)v;
        }
        string = this.makeUniq(string, this.typeNames);
        element.setVarName(string);
        this.types.put(element, element);
        this.typeNames.put(string, element);
        return element;
    }

    protected Element getElement(QName qName, Type type, boolean bl, boolean bl2, boolean bl3) {
        return this.getElement(qName, type, bl3 ? 0 : 1, bl ? -1 : 1, bl2);
    }

    protected ComplexType getComplexType(JavaType javaType, List list) {
        String string = javaType.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1, string.length());
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = string + "Array";
            ++n3;
        }
        return this.getComplexType(string, list);
    }

    protected ComplexType getComplexType(String string, List list) {
        String string2 = this.optimize ? "_c" : "_complexType_" + this.env.getNames().validJavaMemberName(string);
        ComplexType complexType = new ComplexType(string2, list);
        if (this.types.containsKey(complexType)) {
            Object v = this.types.get(complexType);
            return (ComplexType)v;
        }
        string2 = this.makeUniq(string2, this.typeNames);
        complexType.setVarName(string2);
        this.types.put(complexType, complexType);
        this.typeNames.put(string2, complexType);
        return complexType;
    }

    protected void generateInitTypes() throws IOException {
        Object object;
        Object object2;
        Iterator iterator = this.types.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Type)iterator.next();
            object = ((Type)object2).getVarName();
            if (!((Type)object2).isTopLevel()) continue;
            this.jw.write("protected static final ");
            this.jw.write(((Type)object2).getClassName());
            this.jw.writeEol(" ", (String)object);
        }
        this.jw.write("static ");
        this.jw.begin();
        this.jw.comment("Create all of the Type's that this stub uses, once.");
        object2 = this.types.keySet().iterator();
        while (object2.hasNext()) {
            object = (Type)object2.next();
            String string = ((Type)object).getVarName();
            if (!((Type)object).isTopLevel()) {
                this.jw.writeEol(((Type)object).getClassName(), " ", string);
            }
            ((Type)object).write((Writer)this.jw);
        }
        this.jw.end();
        this.jw.cr();
    }

    protected void generateFaultHandler() throws IOException {
        ArrayList arrayList = new ArrayList(this.faultNames.keySet());
        if (arrayList.size() == 0) {
            return;
        }
        if (this.faultDetailHandlerIsInnerClass) {
            this.jw.select(this.jw.DECL_SECTION);
            this.jw.writeEol("private MyFaultDetailHandler _myFaultDetailHandler = new MyFaultDetailHandler()");
        }
        this.jw.select(this.jw.BODY_SECTION);
        if (this.faultDetailHandlerIsInnerClass) {
            this.jw.write("private static class MyFaultDetailHandler implements FaultDetailHandler ");
            this.jw.begin();
            this.jw.writecr("public MyFaultDetailHandler() {}");
        }
        this.jw.write("public Element handleFault(QName name) ");
        this.jw.begin();
        Collections.sort(arrayList, new QNameComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            QName qName = (QName)e;
            Type type = (Type)this.faultNames.get(qName);
            this.jw.beginIf("\"" + qName.getLocalPart() + "\".equals(name.getLocalPart()) && \"" + qName.getNamespaceURI() + "\".equals(name.getNamespaceURI())");
            this.jw.writeEol("return " + type.getVarName());
            this.jw.end();
        }
        this.jw.writeEol("return null");
        this.jw.end();
        if (this.faultDetailHandlerIsInnerClass) {
            this.jw.end();
        }
        this.jw.cr();
    }

    protected static class ComplexType
    extends Type {
        private List elements;

        protected ComplexType(String string, List list) {
            super(string);
            this.elements = list;
        }

        public String getClassName() {
            return "ComplexType";
        }

        public void setVarName(String string) {
            this.varName = string;
        }

        public Element getElement(int n) {
            return (Element)this.elements.get(n);
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.varName);
            writer.write(" = new ");
            writer.write(this.getClassName());
            writer.write("();\n");
            writer.write(this.varName);
            int n = this.elements.size();
            writer.write(".elements = new Element[" + n);
            writer.write("];\n");
            Iterator iterator = this.elements.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                writer.write(this.varName);
                writer.write(".elements[" + n2);
                writer.write("] = ");
                writer.write(element.getVarName());
                writer.write(";\n");
                ++n2;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ComplexType)) {
                return false;
            }
            ComplexType complexType = (ComplexType)object;
            if (this.elements.size() != complexType.elements.size()) {
                return false;
            }
            Iterator iterator = this.elements.iterator();
            Iterator iterator2 = complexType.elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                Element element2 = (Element)iterator2.next();
                if (element != null ? element.equals(element2) : element2 == null) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 17;
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                n = 37 * n + (element == null ? 0 : element.hashCode());
            }
            return n;
        }
    }

    protected static class Element
    extends Type {
        private String name;
        private QName qName;
        private Type type;
        private int minOccurs;
        private int maxOccurs;
        private boolean nillable;
        private boolean topLevel;

        protected Element(String string, String string2, QName qName, Type type, int n, int n2, boolean bl) {
            super(string);
            this.name = string2;
            this.qName = qName;
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            this.type = type;
            this.minOccurs = n;
            this.maxOccurs = n2;
            this.nillable = bl;
        }

        public String getClassName() {
            return "Element";
        }

        public void setVarName(String string) {
            this.varName = string;
        }

        public void setTopLevel(boolean bl) {
            this.topLevel = bl;
        }

        public boolean isTopLevel() {
            return this.topLevel;
        }

        public QName getQName() {
            return this.qName;
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.varName);
            writer.write(" = new ");
            writer.write(this.getClassName());
            writer.write("(");
            writer.write(this.name);
            writer.write(", ");
            writer.write(this.type.getVarName());
            if (this.minOccurs != 1 || this.maxOccurs != 1 || this.nillable) {
                writer.write(", " + this.minOccurs);
                writer.write(", " + this.maxOccurs);
                writer.write(", " + this.nillable);
            }
            writer.write(");\n");
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Element)) {
                return false;
            }
            Element element = (Element)object;
            if (!(this.name != null ? this.name.equals(element.name) : element.name == null)) {
                return false;
            }
            if (!(this.qName != null ? this.qName.equals(element.qName) : element.qName == null)) {
                return false;
            }
            if (!(this.type != null ? this.type.equals(element.type) : element.type == null)) {
                return false;
            }
            if (this.minOccurs != element.minOccurs) {
                return false;
            }
            if (this.maxOccurs != element.maxOccurs) {
                return false;
            }
            return this.nillable == element.nillable;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 37 * n + (this.qName == null ? 0 : this.qName.hashCode());
            n = 37 * n + (this.type == null ? 0 : this.type.hashCode());
            n = 37 * n + this.minOccurs;
            n = 37 * n + this.maxOccurs;
            n = 37 * n + (this.nillable ? 0 : 1);
            return n;
        }
    }

    protected static class Type {
        protected String varName;
        public static final Type BOOLEAN = new Type("Type.BOOLEAN");
        public static final Type BYTE = new Type("Type.BYTE");
        public static final Type DOUBLE = new Type("Type.DOUBLE");
        public static final Type FLOAT = new Type("Type.FLOAT");
        public static final Type INT = new Type("Type.INT");
        public static final Type LONG = new Type("Type.LONG");
        public static final Type SHORT = new Type("Type.SHORT");
        public static final Type STRING = new Type("Type.STRING");
        public static final Type UNKNOWN = new Type("UNKNOWN");
        private static final Map toTypeMap = new HashMap();

        protected Type(String string) {
            this.varName = string;
        }

        public String getVarName() {
            return this.varName;
        }

        public String getClassName() {
            throw new UnsupportedOperationException();
        }

        public boolean isTopLevel() {
            return false;
        }

        public static Type toType(String string) {
            Type type = (Type)toTypeMap.get(string);
            if (type == null) {
                return UNKNOWN;
            }
            return type;
        }

        public void write(Writer writer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Type)) {
                return false;
            }
            Type type = (Type)object;
            return this.varName != null ? this.varName.equals(type.varName) : type.varName == null;
        }

        public int hashCode() {
            return this.varName == null ? 0 : this.varName.hashCode();
        }

        public String toString() {
            try {
                StringWriter stringWriter = new StringWriter();
                this.write(stringWriter);
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                return this.varName;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return this.varName;
            }
        }

        static {
            toTypeMap.put("boolean", BOOLEAN);
            toTypeMap.put("Boolean", BOOLEAN);
            toTypeMap.put("java.lang.Boolean", BOOLEAN);
            toTypeMap.put("byte", BYTE);
            toTypeMap.put("Byte", BYTE);
            toTypeMap.put("java.lang.Byte", BYTE);
            toTypeMap.put("int", INT);
            toTypeMap.put("Integer", INT);
            toTypeMap.put("java.lang.Integer", INT);
            toTypeMap.put("long", LONG);
            toTypeMap.put("Long", LONG);
            toTypeMap.put("java.lang.Long", LONG);
            toTypeMap.put("short", SHORT);
            toTypeMap.put("Short", SHORT);
            toTypeMap.put("java.lang.Short", SHORT);
            toTypeMap.put("float", FLOAT);
            toTypeMap.put("Float", FLOAT);
            toTypeMap.put("java.lang.Float", FLOAT);
            toTypeMap.put("double", DOUBLE);
            toTypeMap.put("Double", DOUBLE);
            toTypeMap.put("java.lang.Double", DOUBLE);
            toTypeMap.put("String", STRING);
            toTypeMap.put("java.lang.String", STRING);
        }
    }

    protected static class QNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            QName qName = (QName)object;
            QName qName2 = (QName)object2;
            int n = qName.getNamespaceURI().compareTo(qName2.getNamespaceURI());
            if (n == 0) {
                n = qName.getLocalPart().compareTo(qName2.getLocalPart());
            }
            return n;
        }
    }
}

