/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2mews.sg;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MakeCldc1_0
implements ProcessorAction {
    protected ProcessorEnvironment env;
    private Map originalTypes;
    protected LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.j2mews.sg.stubgenerator");

    public MakeCldc1_0(Map map) {
        this.originalTypes = map;
    }

    public void setEnvironment(ProcessorEnvironment processorEnvironment) {
        this.env = processorEnvironment;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            this.mungeTo1_0(service);
        }
    }

    public void mungeTo1_0(Service service) {
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            this.mungeTo1_0(port);
        }
    }

    protected void mungeTo1_0(Port port) {
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            this.mungeTo1_0(operation, port);
        }
    }

    protected void mungeTo1_0(Operation operation, Port port) {
        JavaType javaType;
        Iterator iterator;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType2 = javaMethod.getReturnType();
        this.mungeTo1_0(javaType2, port);
        Iterator iterator2 = javaMethod.getParameters();
        while (iterator2.hasNext()) {
            iterator = (JavaParameter)iterator2.next();
            javaType = iterator.getType();
            this.mungeTo1_0(javaType, port);
        }
        iterator = operation.getFaults();
        while (iterator.hasNext()) {
            javaType = (Fault)iterator.next();
            Block block = javaType.getBlock();
            JavaException javaException = javaType.getJavaException();
            this.mungeTo1_0((JavaType)javaException, port);
        }
    }

    protected void mungeTo1_0(JavaType javaType, Port port) {
        if (javaType == null) {
            return;
        }
        if (javaType instanceof JavaSimpleType) {
            String string = this.javaTypeToString(javaType, port).intern();
            if (string == "float" || string == "Float" || string == "java.lang.Float" || string == "double" || string == "Double" || string == "java.lang.Double") {
                this.originalTypes.put(javaType, string);
                javaType.doSetName("java.lang.String");
            }
        } else if (javaType instanceof JavaStructureType) {
            JavaStructureType javaStructureType = (JavaStructureType)javaType;
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                JavaType javaType2 = javaStructureMember.getType();
                this.mungeTo1_0(javaType2, port);
            }
        } else if (javaType instanceof JavaArrayType) {
            JavaArrayType javaArrayType = (JavaArrayType)javaType;
            JavaType javaType3 = javaArrayType.getElementType();
            this.mungeTo1_0(javaType3, port);
            if (this.originalTypes.containsKey(javaType3)) {
                String string = this.javaTypeToString(javaType, port);
                this.originalTypes.put(javaType, string);
                javaArrayType.doSetName(javaType3.getName() + "[]");
            }
        } else if (javaType instanceof JavaEnumerationType) {
            JavaEnumerationType javaEnumerationType = (JavaEnumerationType)javaType;
            JavaType javaType4 = javaEnumerationType.getBaseType();
            this.mungeTo1_0(javaType4, port);
        } else {
            this.onWarning(this.getMessage("stubgenerator.unknownType", "mungeTo1_0", javaType.toString()));
        }
    }

    protected String javaTypeToString(JavaType javaType, Port port) {
        if (javaType == null) {
            return null;
        }
        String string = javaType.isHolder() ? this.env.getNames().holderClassName(port, javaType) : this.env.getNames().typeClassName(javaType);
        return string;
    }

    protected void onWarning(Localizable localizable) {
        this.env.warn(localizable);
    }

    protected Localizable getMessage(String string, String string2) {
        return this.messageFactory.getMessage(string, new Object[]{string2});
    }

    protected Localizable getMessage(String string, String string2, String string3) {
        return this.messageFactory.getMessage(string, new Object[]{string2, string3});
    }
}

