/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2mews.sg;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;
import org.netbeans.modules.schema2beansdev.gen.JavaWriter;

public abstract class AbstractGenerator {
    public static final String FLOAT_DOUBLE_TO_STRING = "FLOAT_DOUBLE_TO_STRING";
    public static final String SHOW_ALL_CLDC1_0_INFO = "SHOW_ALL_CLDC1_0_INFO";
    public static final String EXPAND_ARGUMENTS = "EXPAND_ARGUMENTS";
    public static final String OPTIMIZE = "OPTIMIZE";
    protected ProcessorEnvironment env;
    protected Service service;
    protected Port port;
    protected JavaWriter jw;
    protected String fullClassName;
    protected String className;
    protected String packageName;
    protected File sourceDir;
    protected LocalizableMessageFactory messageFactory;
    protected Localizer localizer = new Localizer();
    protected boolean expandArguments = false;
    protected boolean optimize = false;
    protected boolean showCldc1_0Info = false;

    protected void setFullClassName(String string) {
        this.fullClassName = string;
        int n = this.fullClassName.lastIndexOf(46);
        if (n >= 0) {
            this.packageName = this.fullClassName.substring(0, n);
            this.className = this.fullClassName.substring(n + 1, this.fullClassName.length());
        } else {
            this.packageName = null;
            this.className = this.fullClassName;
        }
    }

    public void setEnvironment(ProcessorEnvironment processorEnvironment) {
        this.env = processorEnvironment;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        this.sourceDir = new File(properties.getProperty("sourceDirectory"));
        this.expandArguments = "true".equals(properties.getProperty(EXPAND_ARGUMENTS));
        this.showCldc1_0Info = "true".equals(properties.getProperty(SHOW_ALL_CLDC1_0_INFO));
        this.optimize = "true".equals(properties.getProperty(OPTIMIZE));
        try {
            Iterator iterator = model.getServices();
            while (iterator.hasNext()) {
                this.service = (Service)iterator.next();
                this.generate(this.service);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void generate(Service service) throws IOException {
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            this.port = (Port)iterator.next();
            this.setFullClassName(this.getFullClassName());
            this.generate();
        }
    }

    protected abstract String getFullClassName();

    protected void generate() throws IOException {
        this.jw = new JavaWriter();
        this.jw.comment("This class was generated by 172 StubGenerator.");
        this.jw.comment("Contents subject to change without notice.");
        this.jw.comment("@generated");
        this.jw.cr();
        this.jw.writePackage(this.packageName);
        this.jw.cr();
        this.writeImports();
        this.generateClass();
        this.writeOutGeneratedFile();
    }

    protected void writeOutGeneratedFile() throws IOException {
        File file = this.getSourceFile();
        this.log("Generating Java class for: " + file.getName());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.jw.writeTo((OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        GeneratedFileInfo generatedFileInfo = new GeneratedFileInfo();
        generatedFileInfo.setFile(file);
        generatedFileInfo.setType(this.getSourceFileType());
        this.env.addGeneratedFile(generatedFileInfo);
    }

    protected abstract File getSourceFile();

    protected abstract String getSourceFileType();

    protected void writeImports() throws IOException {
    }

    protected abstract void generateClass() throws IOException;

    protected JavaType getExpandedReturnType(JavaMethod javaMethod) {
        JavaStructureType javaStructureType;
        JavaType javaType = javaMethod.getReturnType();
        if (javaType == null || "void".equals(this.javaTypeToString(javaType))) {
            return javaType;
        }
        boolean bl = false;
        if (this.expandArguments && !bl && javaType instanceof JavaStructureType && (javaStructureType = (JavaStructureType)javaType).getMembersCount() == 1) {
            javaType = ((JavaStructureMember)javaStructureType.getMembers().next()).getType();
        }
        return javaType;
    }

    protected List getExpandedParametersList(JavaMethod javaMethod) {
        ArrayList<JavaParameter> arrayList = javaMethod.getParametersList();
        if (arrayList.size() == 1 && this.expandArguments) {
            JavaParameter javaParameter = (JavaParameter)arrayList.iterator().next();
            Parameter parameter = javaParameter.getParameter();
            JavaType javaType = javaParameter.getType();
            Block block = parameter.getBlock();
            boolean bl = block.getType().isNillable();
            if (javaType instanceof JavaStructureType && !bl) {
                JavaStructureType javaStructureType = (JavaStructureType)javaType;
                arrayList = new ArrayList<JavaParameter>(javaStructureType.getMembersCount());
                Iterator iterator = javaStructureType.getMembers();
                while (iterator.hasNext()) {
                    JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                    String string = javaStructureMember.getName();
                    JavaType javaType2 = javaStructureMember.getType();
                    javaParameter = new JavaParameter(string, javaType2, parameter);
                    arrayList.add(javaParameter);
                }
            }
        }
        return arrayList;
    }

    protected String javaTypeToString(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        String string = javaType.isHolder() ? this.env.getNames().holderClassName(this.port, javaType) : this.env.getNames().typeClassName(javaType);
        return string;
    }

    public static boolean isValidType(String string) {
        if (string == null) {
            return true;
        }
        return (string = string.intern()) != "java.math.BigDecimal" && string != "java.math.BigInteger";
    }

    protected String makeVarName(QName qName, String string, Map map) {
        String string2 = string + qName.getLocalPart();
        string2 = string2.replace('.', '_');
        string2 = string2.replace('/', '_');
        string2 = string2.replace(':', '_');
        if (map != null && map.containsKey(string2)) {
            String string3 = qName.getNamespaceURI();
            if (string3 != null) {
                int n = string3.lastIndexOf(47);
                if (n >= 0) {
                    string3 = string3.substring(n + 1, string3.length());
                }
                string3 = string3.replace('.', '_');
                string3 = string3.replace(':', '_');
                string3 = string3.replace('/', '_');
                string3 = string3.replace('%', '_');
                string2 = string + string3 + "_" + qName.getLocalPart();
            }
            string2 = this.makeUniq(string2, map);
        }
        return string2;
    }

    protected String instanceOf(JavaType javaType, String string, Map map) {
        String string2 = javaType.getName();
        return this.instanceOf(string2, string, map);
    }

    protected String instanceOf(JavaType javaType, Map map) {
        return this.instanceOf(javaType, null, map);
    }

    protected String instanceOf(QName qName, String string, Map map) {
        return this.instanceOf(qName.getLocalPart(), string, map);
    }

    protected String instanceOf(String string, String string2, Map map) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1, string.length());
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = string + "Array";
            ++n3;
        }
        if (JavaUtil.isPrimitiveType((String)string)) {
            string = "a_" + string;
        }
        if (string2 != null) {
            string = string + string2;
        }
        string = this.env.getNames().validJavaMemberName(string);
        return this.makeUniq(string, map);
    }

    protected String makeUniq(String string, Map map) {
        if (map.containsKey(string) || this.env.getNames().isJavaReservedWord(string)) {
            String string2 = string;
            int n = this.optimize ? 0 : 2;
            while (map.containsKey(string)) {
                string = string2 + (this.optimize ? Integer.toString(n, 36) : "" + n);
                ++n;
            }
        }
        map.put(string, null);
        return string;
    }

    protected static String baseName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    protected void onWarning(Localizable localizable) {
        this.env.warn(localizable);
    }

    protected void onInfo(Localizable localizable) {
        this.env.info(localizable);
    }

    protected void onError(Localizable localizable) {
        this.env.error(localizable);
    }

    protected Localizable getMessage(String string) {
        return this.messageFactory.getMessage(string);
    }

    protected Localizable getMessage(String string, String string2) {
        return this.messageFactory.getMessage(string, new Object[]{string2});
    }

    protected Localizable getMessage(String string, String string2, String string3) {
        return this.messageFactory.getMessage(string, new Object[]{string2, string3});
    }

    protected Localizable getMessage(String string, String string2, String string3, String string4) {
        return this.messageFactory.getMessage(string, new Object[]{string2, string3, string4});
    }

    protected Localizable getMessage(String string, Localizable localizable) {
        return this.messageFactory.getMessage(string, new Object[]{localizable});
    }

    protected Localizable getMessage(String string, Object[] objectArray) {
        return this.messageFactory.getMessage(string, objectArray);
    }

    protected String localize(Localizable localizable) {
        return this.localizer.localize(localizable);
    }

    public void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
    }

    protected void log(String string) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier((String)this.getClass().getName())).append(": ").append(string).append("]").toString());
        }
    }
}

