/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimplePlayer;
import example.SoccerQ.VideoCanvas;
import example.SoccerQ.VideoPlayer;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class VideoTest
extends MIDlet
implements CommandListener,
Runnable {
    private static VideoCanvas videoCanvas = null;
    private static VideoPlayer videoPlayer = null;
    private static Vector videoClips;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Display display;
    private static List theList;
    private static VideoTest instance;
    private static Vector urls;
    int index = 0;

    public static VideoTest getInstance() {
        return instance;
    }

    public static List getList() {
        return theList;
    }

    public VideoTest() {
        instance = this;
        this.display = Display.getDisplay((MIDlet)this);
        theList = new List("MMAPI Video Player", 3);
        this.fillList();
        theList.addCommand(this.playCommand);
        theList.addCommand(this.exitCommand);
        theList.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)theList);
    }

    private void fillList() {
        String nthURL;
        String url;
        videoClips = new Vector();
        urls = new Vector();
        for (int n = 1; n < 100 && (url = this.getAppProperty(nthURL = "VideoTest-URL" + n)) != null && url.length() != 0; ++n) {
            if (!SimplePlayer.isSupported(url)) continue;
            String nthTitle = "VideoTest-" + n;
            String title = this.getAppProperty(nthTitle);
            if (title == null || title.length() == 0) {
                title = url;
            }
            videoClips.addElement(title);
            urls.addElement(url);
            theList.append(title, null);
        }
    }

    public void startApp() {
        if (videoPlayer != null) {
            videoPlayer.startApp();
        }
        if (videoCanvas != null) {
            videoCanvas.startApp();
        }
    }

    public void pauseApp() {
        if (videoPlayer != null) {
            videoPlayer.pauseApp();
        }
        if (videoCanvas != null) {
            videoCanvas.pauseApp();
        }
    }

    public synchronized void destroyApp(boolean unconditional) {
        if (videoPlayer != null) {
            videoPlayer.close();
        }
        if (videoCanvas != null) {
            videoCanvas.close();
        }
        this.nullPlayer();
    }

    public synchronized void nullPlayer() {
        videoPlayer = null;
        videoCanvas = null;
    }

    public void run() {
        if (this.index % 2 == 0) {
            videoPlayer = new VideoPlayer(this.display);
            videoPlayer.open((String)urls.elementAt(this.index));
            if (videoPlayer != null) {
                this.display.setCurrent((Displayable)videoPlayer);
                videoPlayer.start();
            }
        } else {
            videoCanvas = new VideoCanvas(this.display);
            videoCanvas.open((String)urls.elementAt(this.index));
            if (videoCanvas != null) {
                this.display.setCurrent((Displayable)videoCanvas);
                videoCanvas.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            VideoTest videoTest = this;
            synchronized (videoTest) {
                if (videoPlayer != null || videoCanvas != null) {
                    new Thread(new Runnable(){

                        public void run() {
                            if (videoPlayer != null) {
                                videoPlayer.stopVideoPlayer();
                                videoPlayer = null;
                            } else {
                                videoCanvas.stopVideoCanvas();
                                videoCanvas = null;
                            }
                            VideoTest.this.destroyApp(false);
                            VideoTest.this.notifyDestroyed();
                        }
                    }).start();
                } else {
                    this.destroyApp(false);
                    this.notifyDestroyed();
                }
            }
        }
        if (s == theList && c == List.SELECT_COMMAND || c == this.playCommand) {
            VideoTest videoTest = this;
            synchronized (videoTest) {
                int i;
                if (videoPlayer != null || videoCanvas != null) {
                    return;
                }
                this.index = i = theList.getSelectedIndex();
                new Thread(this).start();
            }
        }
    }

    static {
        instance = null;
    }
}

