/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.Utils;
import example.SoccerQ.VideoTest;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.GUIControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class VideoPlayer
extends Form
implements Runnable,
CommandListener,
PlayerListener {
    private static final String TITLE_TEXT = "MMAPI Video Player";
    private static Player player = null;
    private static boolean isCapturePlayer;
    private static Image logo;
    private int idx = 0;
    private Display parentDisplay;
    private long duration;
    private final Command backCommand = new Command("Back", 2, 1);
    private final Command playCommand = new Command("Play", 8, 1);
    private final Command snapCommand = new Command("Snapshot", 8, 1);
    private final Command pauseCommand = new Command("Pause", 8, 10);
    private Item videoItem;
    private StringItem status;
    private StringItem audioStatus;
    private StringItem time;
    private VolumeControl vc;
    private RateControl rc;
    private Thread th;
    private int currentVolume;
    private boolean muted;
    private int currentRate = 100000;
    private VideoControl vidc;
    private boolean suspended = false;
    private boolean restartOnResume = false;
    private long restartMediaTime;

    public VideoPlayer(Display parentDisplay) {
        super(TITLE_TEXT);
        this.parentDisplay = parentDisplay;
        this.initialize();
    }

    void initialize() {
        this.addCommand(this.backCommand);
        this.addCommand(this.snapCommand);
        this.setCommandListener(this);
        try {
            if (logo == null) {
                logo = Image.createImage((String)"/icons/logo.png");
            }
        }
        catch (Exception ex) {
            logo = null;
        }
        if (logo == null) {
            System.out.println("can not load logo.png");
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this) {
            if (c == this.backCommand) {
                this.close();
                this.parentDisplay.setCurrent((Displayable)VideoTest.getList());
            } else if (this.videoItem != null && c == this.snapCommand) {
                this.doSnapshot();
            } else if (this.videoItem == null && c == this.pauseCommand) {
                this.removeCommand(this.pauseCommand);
                this.addCommand(this.playCommand);
                this.pause();
            } else if (this.videoItem == null && c == this.playCommand) {
                this.start();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (player != null) {
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (player != null && this.suspended);
            VideoPlayer videoPlayer = this;
            synchronized (videoPlayer) {
                if (player == null) {
                    return;
                }
                if (this.vc != null && (this.vc.getLevel() != this.currentVolume || this.vc.isMuted() != this.muted)) {
                    this.muted = this.vc.isMuted();
                    this.currentVolume = this.vc.getLevel();
                    this.audioStatus.setText("Volume: " + this.currentVolume + "% " + (this.muted ? " (muted)" : ""));
                }
                if (this.rc != null && this.rc.getRate() != this.currentRate) {
                    this.currentRate = this.rc.getRate();
                    this.updateStatus();
                }
                long k = player.getMediaTime();
                this.time.setText("Pos: " + k / 1000000L + "." + k / 10000L % 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String url) {
        try {
            VideoPlayer videoPlayer = this;
            synchronized (videoPlayer) {
                if (player == null) {
                    if (url.startsWith("resource:")) {
                        InputStream ins = this.getClass().getResourceAsStream(url.substring(9));
                        String ct = Utils.guessContentType(url);
                        player = Manager.createPlayer((InputStream)ins, (String)ct);
                    } else {
                        player = Manager.createPlayer((String)url);
                    }
                    player.addPlayerListener((PlayerListener)this);
                    isCapturePlayer = url.startsWith("capture:");
                }
            }
            player.realize();
            this.vidc = (VideoControl)player.getControl("VideoControl");
            if (this.vidc != null) {
                this.videoItem = (Item)this.vidc.initDisplayMode(0, null);
            } else if (logo != null) {
                this.append((Item)new ImageItem("", logo, 3, ""));
            }
            Control[] controls = player.getControls();
            for (int i = 0; i < controls.length; ++i) {
                if (controls[i] instanceof GUIControl && controls[i] != this.vidc) {
                    this.append((Item)controls[i]);
                }
                if (controls[i] instanceof VolumeControl) {
                    this.vc = (VolumeControl)controls[i];
                }
                if (!(controls[i] instanceof RateControl)) continue;
                this.rc = (RateControl)controls[i];
            }
            this.status = new StringItem("Status: ", "");
            this.status.setLayout(512);
            this.append((Item)this.status);
            if (this.vc != null) {
                this.audioStatus = new StringItem("", "Volume:");
                this.audioStatus.setLayout(512);
                this.append((Item)this.audioStatus);
            }
            this.time = new StringItem("", "");
            this.time.setLayout(512);
            this.append((Item)this.time);
            player.prefetch();
            if (this.videoItem == null) {
                this.addCommand(this.pauseCommand);
            } else {
                Spacer spacer = new Spacer(3, 10);
                spacer.setLayout(256);
                this.append((Item)spacer);
                this.append(this.videoItem);
            }
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception me) {
            System.err.println(me);
            this.close();
        }
    }

    public void start() {
        if (player == null) {
            return;
        }
        try {
            this.duration = player.getDuration();
            player.start();
        }
        catch (Exception ex) {
            System.err.println(ex);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        VideoPlayer videoPlayer = this;
        synchronized (videoPlayer) {
            this.pause();
            if (player != null) {
                player.close();
                player = null;
            }
        }
        VideoTest.getInstance().nullPlayer();
    }

    public void pause() {
        if (player != null) {
            try {
                player.stop();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        }
    }

    private synchronized void updateStatus() {
        if (player == null) {
            return;
        }
        this.status.setText((player.getState() == 400 ? "Playing, " : "Paused, ") + "Rate: " + this.currentRate / 1000 + "%\n");
    }

    public void playerUpdate(Player plyr, String evt, Object evtData) {
        if (evt == "endOfMedia") {
            try {
                player.setMediaTime(0L);
                player.start();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        } else if (evt == "started" || evt == "stopped") {
            this.updateStatus();
        }
    }

    private void doSnapshot() {
        new Thread(){

            public void run() {
                try {
                    byte[] snap = VideoPlayer.this.vidc.getSnapshot("encoding=jpeg");
                    if (snap != null) {
                        Image im = Image.createImage((byte[])snap, (int)0, (int)snap.length);
                        ImageItem imi = new ImageItem("", im, 0, "");
                        VideoPlayer.this.append((Item)imi);
                    }
                }
                catch (MediaException me) {
                    System.err.println((Object)me);
                }
            }
        }.start();
    }

    public synchronized void stopVideoPlayer() {
        player.deallocate();
    }

    public synchronized void pauseApp() {
        this.suspended = true;
        if (player != null && player.getState() >= 400) {
            if (!isCapturePlayer) {
                this.restartMediaTime = player.getMediaTime();
            }
            player.deallocate();
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void startApp() {
        this.suspended = false;
        if (player != null && this.restartOnResume) {
            try {
                player.prefetch();
                if (!isCapturePlayer) {
                    try {
                        player.setMediaTime(this.restartMediaTime);
                    }
                    catch (MediaException me) {
                        System.err.println((Object)me);
                    }
                }
                player.start();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        }
        this.restartOnResume = false;
    }

    static {
        logo = null;
    }
}

