/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.Utils;
import example.SoccerQ.VideoTest;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class VideoCanvas
extends Canvas
implements Runnable,
CommandListener,
PlayerListener {
    private static Player player = null;
    private static boolean isCapturePlayer;
    private int idx = 0;
    private boolean fsmode = false;
    private Display parentDisplay;
    private long duration;
    private long lastTime = -1L;
    private Thread sliderThread;
    private Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command snapCommand = new Command("Snapshot", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 10);
    private VolumeControl vc;
    private RateControl rc;
    private VideoControl vidc;
    private FramePositioningControl fpc;
    private int CB_Y = 0;
    private static final int CB_H = 8;
    private static final int TH_W = 6;
    private static final int VB_W = 10;
    private static final int VB_H = 8;
    private boolean vis = true;
    private int canvasW;
    private int canvasH;
    private int videoW;
    private int videoH;
    private boolean suspended = false;
    private boolean restartOnResume = false;
    private long restartMediaTime;

    public VideoCanvas(Display parentDisplay) {
        this.parentDisplay = parentDisplay;
        this.canvasW = this.getWidth();
        this.canvasH = this.getHeight();
        this.CB_Y = this.canvasH - 8 - 8 - 20;
        this.videoW = this.canvasW - 20;
        this.videoH = this.CB_Y - 16;
        this.initialize();
    }

    public void paint(Graphics g) {
        if (this.fsmode) {
            return;
        }
        g.setColor(0x9090E0);
        g.fillRect(0, 0, this.canvasW, this.canvasH);
        g.setColor(0x202050);
        g.drawLine(9, 7, this.videoW + 10 - 1, 7);
        g.drawLine(9, 7, 9, this.videoH + 8 - 1);
        if (this.sliderThread != null) {
            g.drawLine(9, this.CB_Y, this.videoW + 10 - 1, this.CB_Y);
            g.drawLine(9, this.CB_Y, 9, this.CB_Y + 8);
        }
        g.setColor(0xD0D0FF);
        g.drawLine(this.videoW + 10, 8, this.videoW + 10, this.videoH + 8);
        g.drawLine(this.videoW + 10, this.videoH + 8, 10, this.videoH + 8);
        if (this.sliderThread != null) {
            g.drawLine(this.videoW + 10, this.CB_Y + 1, this.videoW + 10, this.CB_Y + 8 + 1);
            g.drawLine(this.videoW + 10, this.CB_Y + 8 + 1, 8, this.CB_Y + 8 + 1);
        }
        if (this.sliderThread != null) {
            int p = this.time2pix(this.lastTime);
            g.drawLine(10 + p, this.CB_Y + 1, 10 + p, this.CB_Y + 8);
            g.drawLine(10 + p, this.CB_Y + 1, 10 + p + 6 - 1, this.CB_Y + 1);
            g.setColor(0x202050);
            g.drawLine(10 + p + 1, this.CB_Y + 8, 10 + p + 6, this.CB_Y + 8);
            g.drawLine(10 + p + 6, this.CB_Y + 8, 10 + p + 6, this.CB_Y + 1);
            g.setColor(0xA0A0FF);
            g.fillRect(10 + p + 1, this.CB_Y + 2, 4, 6);
            g.setColor(0);
            g.drawString("00:00", 10, this.CB_Y + 8 + 4, 20);
            g.drawString(this.time2String(this.lastTime) + "/" + this.time2String(this.duration), 10 + this.videoW, this.CB_Y + 8 + 4, 24);
        }
    }

    private void initialize() {
        this.addCommand(this.backCommand);
        this.addCommand(this.snapCommand);
        this.setCommandListener(this);
    }

    private int time2pix(long time) {
        int t2p = (int)(time * (long)(this.videoW - 1 - 6) / this.duration);
        return t2p;
    }

    private String time2String(long time) {
        String strTime = "" + (time /= 1000000L) % 10L;
        strTime = (time /= 10L) % 6L + strTime;
        strTime = (time /= 6L) % 10L + ":" + strTime;
        strTime = (time /= 10L) % 6L + strTime;
        time /= 6L;
        return strTime;
    }

    public void run() {
        while (player != null) {
            try {
                long time = player.getMediaTime();
                if (this.time2pix(time) != this.time2pix(this.lastTime)) {
                    this.lastTime = time;
                    this.repaint(8, this.CB_Y, this.videoW + 2, 30);
                }
                do {
                    Thread.sleep(250L);
                } while (player != null && this.suspended);
            }
            catch (Exception e) {
                System.err.println("In run(): " + e);
                break;
            }
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this) {
            if (c == this.backCommand) {
                this.close();
                this.parentDisplay.setCurrent((Displayable)VideoTest.getList());
            } else if (this.vidc != null && c == this.snapCommand) {
                this.doSnapshot();
            } else if (this.vidc == null && c == this.pauseCommand) {
                this.removeCommand(this.pauseCommand);
                this.addCommand(this.playCommand);
                this.pause();
            } else if (this.vidc == null && c == this.playCommand) {
                this.start();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.duration == -1L || isCapturePlayer) {
            return;
        }
        if (y >= this.CB_Y && y < this.CB_Y + 8 && x >= 8 && x <= 8 + this.videoW) {
            if ((x -= 11) < 0) {
                x = 0;
            }
            if (x > this.videoW - 6) {
                x = this.videoW - 6;
            }
            long time = this.duration * (long)x / (long)(this.videoW - 6);
            try {
                player.setMediaTime(time);
            }
            catch (MediaException me) {
                System.out.println((Object)me);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        this.pointerPressed(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String url) {
        try {
            VideoCanvas videoCanvas = this;
            synchronized (videoCanvas) {
                if (player == null) {
                    if (url.startsWith("resource:")) {
                        InputStream ins = this.getClass().getResourceAsStream(url.substring(9));
                        String ct = Utils.guessContentType(url);
                        player = Manager.createPlayer((InputStream)ins, (String)ct);
                    } else {
                        player = Manager.createPlayer((String)url);
                    }
                    player.addPlayerListener((PlayerListener)this);
                    isCapturePlayer = url.startsWith("capture:");
                }
            }
            player.realize();
            this.vidc = (VideoControl)player.getControl("VideoControl");
            if (this.vidc != null) {
                this.vidc.initDisplayMode(1, (Object)this);
                int frameW = this.vidc.getSourceWidth();
                int frameH = this.vidc.getSourceHeight();
                if (frameW > this.videoW) {
                    frameW = this.videoW;
                }
                if (frameH > this.videoH) {
                    frameH = this.videoH;
                }
                int frameX = (this.videoW - frameW) / 2 + 10;
                int frameY = (this.videoH - frameH) / 2 + 8;
                this.vidc.setDisplayLocation(frameX, frameY);
                this.vidc.setDisplaySize(frameW, frameH);
                this.vidc.setVisible(true);
            }
            Control[] controls = player.getControls();
            for (int i = 0; i < controls.length; ++i) {
                if (controls[i] instanceof VolumeControl) {
                    this.vc = (VolumeControl)controls[i];
                }
                if (controls[i] instanceof RateControl) {
                    this.rc = (RateControl)controls[i];
                }
                if (!(controls[i] instanceof FramePositioningControl)) continue;
                this.fpc = (FramePositioningControl)controls[i];
            }
            player.prefetch();
            if (this.vidc == null) {
                this.addCommand(this.pauseCommand);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            this.close();
        }
    }

    public void start() {
        if (player == null) {
            return;
        }
        try {
            this.duration = player.getDuration();
            player.start();
            if (this.duration != -1L) {
                this.sliderThread = new Thread(this);
                this.sliderThread.start();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        VideoCanvas videoCanvas = this;
        synchronized (videoCanvas) {
            this.pause();
            if (player != null) {
                player.close();
                player = null;
            }
        }
        VideoTest.getInstance().nullPlayer();
    }

    public void pause() {
        if (player != null) {
            try {
                player.stop();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        }
    }

    public void playerUpdate(Player plyr, String evt, Object evtData) {
        if (evt == "endOfMedia") {
            try {
                player.setMediaTime(0L);
                player.start();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        }
    }

    private void doSnapshot() {
        final VideoCanvas tThis = this;
        new Thread(){

            public void run() {
                try {
                    byte[] snap = VideoCanvas.this.vidc.getSnapshot("encoding=jpeg");
                    if (snap != null) {
                        Image im = Image.createImage((byte[])snap, (int)0, (int)snap.length);
                        Alert al = new Alert("Snapshot", "Here's the snap", im, AlertType.INFO);
                        al.setTimeout(2000);
                        VideoCanvas.this.parentDisplay.setCurrent(al, (Displayable)tThis);
                    }
                }
                catch (MediaException me) {
                    System.err.println((Object)me);
                }
            }
        }.start();
    }

    public synchronized void stopVideoCanvas() {
        player.deallocate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 52: {
                int cr = this.rc.getRate();
                cr -= 10000;
                cr = this.rc.setRate(cr);
                return;
            }
            case 54: {
                int cr = this.rc.getRate();
                cr += 10000;
                cr = this.rc.setRate(cr);
                return;
            }
            case 42: {
                if (this.vc == null) return;
                int cv = this.vc.getLevel();
                cv -= 10;
                cv = this.vc.setLevel(cv);
                return;
            }
            case 48: {
                if (this.vc == null) return;
                this.vc.setMute(!this.vc.isMuted());
                return;
            }
            case 35: {
                if (this.vc == null) return;
                int cv = this.vc.getLevel();
                cv += 10;
                cv = this.vc.setLevel(cv);
                return;
            }
            case 55: {
                if (this.fpc == null) return;
                this.fpc.skip(-1);
                return;
            }
            case 53: {
                try {
                    player.stop();
                    if (!isCapturePlayer) {
                        player.setMediaTime(0L);
                    }
                    player.deallocate();
                    return;
                }
                catch (MediaException me) {
                    System.err.println((Object)me);
                }
                return;
            }
            case 57: {
                if (this.fpc == null) return;
                this.fpc.skip(1);
                return;
            }
            case 50: {
                try {
                    if (player.getState() == 400) {
                        player.stop();
                        return;
                    }
                    player.start();
                    return;
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                return;
            }
            case 56: {
                try {
                    if (this.vidc != null) {
                        this.fsmode = !this.fsmode;
                        this.vidc.setDisplayFullScreen(this.fsmode);
                    }
                    this.repaint();
                    return;
                }
                catch (MediaException me) {
                    System.err.println((Object)me);
                }
                return;
            }
            case 49: 
            case 51: {
                if (isCapturePlayer) return;
                long mTime = player.getMediaTime();
                long duration = player.getDuration();
                if (duration == -1L || mTime == -1L) {
                    return;
                }
                try {
                    if (keyCode == 51) {
                        if ((mTime += duration / 10L) > duration) {
                            mTime = duration;
                        }
                        player.setMediaTime(mTime);
                        return;
                    }
                    if (keyCode != 49) return;
                    if ((mTime -= duration / 10L) < 0L) {
                        mTime = 0L;
                    }
                    player.setMediaTime(mTime);
                    return;
                }
                catch (MediaException me) {
                    System.err.println((Object)me);
                }
                return;
            }
            default: {
                int game = this.getGameAction(keyCode);
                int x = this.vidc.getDisplayX();
                int y = this.vidc.getDisplayY();
                if (game == 1) {
                    this.vidc.setDisplayLocation(x, y - 10);
                } else if (game == 6) {
                    this.vidc.setDisplayLocation(x, y + 10);
                } else if (game == 2) {
                    this.vidc.setDisplayLocation(x - 10, y);
                } else if (game == 5) {
                    this.vidc.setDisplayLocation(x + 10, y);
                } else if (game == 8) {
                    this.vis = !this.vis;
                    this.vidc.setVisible(this.vis);
                }
                this.repaint();
            }
        }
    }

    public synchronized void pauseApp() {
        this.suspended = true;
        if (player != null && player.getState() >= 400) {
            if (!isCapturePlayer) {
                this.restartMediaTime = player.getMediaTime();
            }
            player.deallocate();
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void startApp() {
        this.suspended = false;
        if (player != null && this.restartOnResume) {
            try {
                player.prefetch();
                if (!isCapturePlayer) {
                    try {
                        player.setMediaTime(this.restartMediaTime);
                    }
                    catch (MediaException me) {
                        System.err.println((Object)me);
                    }
                }
                player.start();
            }
            catch (MediaException me) {
                System.err.println((Object)me);
            }
        }
        this.restartOnResume = false;
    }
}

