/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.media.MediaException;

public class Utils {
    public static boolean DEBUG = false;

    private Utils() {
    }

    public static void debugOut(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public static void debugOut(Throwable t) {
        if (DEBUG) {
            System.out.println(t.toString());
        }
        if (DEBUG) {
            t.printStackTrace();
        }
    }

    public static void error(Throwable t, BreadCrumbTrail bct) {
        if (DEBUG) {
            t.printStackTrace();
        }
        Utils.error(Utils.friendlyException(t), bct);
    }

    public static void error(String s, BreadCrumbTrail bct) {
        Alert alert = new Alert("Error", s, null, AlertType.ERROR);
        alert.setTimeout(-2);
        bct.replaceCurrent((Displayable)alert);
    }

    public static void FYI(String s, BreadCrumbTrail bct) {
        Alert alert = new Alert("FYI", s, null, AlertType.INFO);
        alert.setTimeout(-2);
        bct.replaceCurrent((Displayable)alert);
    }

    public static String friendlyException(Throwable t) {
        if (t instanceof MediaException && t.getMessage().indexOf(" ") > 5) {
            return t.getMessage();
        }
        String s = t.toString();
        while (true) {
            int colon;
            int dot = s.indexOf(".");
            int space = s.indexOf(" ");
            if (space < 0) {
                space = s.length();
            }
            if ((colon = s.indexOf(":")) < 0) {
                colon = s.length();
            }
            if (dot < 0 || dot >= space || dot >= colon) break;
            s = s.substring(dot + 1);
        }
        return s;
    }

    public static void query(String title, String def, int maxSize, QueryListener listener, BreadCrumbTrail bct) {
        Utils.query(title, def, maxSize, 0, listener, bct);
    }

    public static void query(String title, String def, int maxSize, int constraints, QueryListener listener, BreadCrumbTrail bct) {
        TextBox tb = new TextBox(title, def, maxSize, constraints);
        tb.addCommand(QueryTask.cancelCommand);
        tb.addCommand(QueryTask.OKCommand);
        QueryTask qt = new QueryTask(listener, bct);
        tb.setCommandListener((CommandListener)qt);
        bct.go((Displayable)tb);
    }

    public static String[] splitURL(String url) throws Exception {
        int slash;
        StringBuffer u = new StringBuffer(url);
        String[] result = new String[6];
        for (int i = 0; i <= 5; ++i) {
            result[i] = "";
        }
        boolean protFound = false;
        int index = url.indexOf(":");
        if (index > 0) {
            result[0] = url.substring(0, index);
            u.delete(0, index + 1);
            protFound = true;
        } else if (index == 0) {
            throw new Exception("url format error - protocol");
        }
        if (u.length() > 2 && u.charAt(0) == '/' && u.charAt(1) == '/') {
            u.delete(0, 2);
            slash = u.toString().indexOf(47);
            if (slash < 0) {
                slash = u.length();
            }
            int colon = u.toString().indexOf(58);
            int endIndex = slash;
            if (colon >= 0) {
                if (colon > slash) {
                    throw new Exception("url format error - port");
                }
                endIndex = colon;
                result[2] = u.toString().substring(colon + 1, slash);
            }
            result[1] = u.toString().substring(0, endIndex);
            u.delete(0, slash);
        }
        if (u.length() > 0) {
            url = u.toString();
            slash = url.lastIndexOf(47);
            if (slash > 0) {
                result[3] = url.substring(0, slash);
            }
            if (slash < url.length() - 1) {
                String fn = url.substring(slash + 1, url.length());
                int anchorIndex = fn.indexOf("#");
                if (anchorIndex >= 0) {
                    result[4] = fn.substring(0, anchorIndex);
                    result[5] = fn.substring(anchorIndex + 1);
                } else {
                    result[4] = fn;
                }
            }
        }
        return result;
    }

    public static String mergeURL(String[] url) {
        return (url[0] == "" ? "" : url[0] + ":/") + (url[1] == "" ? "" : "/" + url[1]) + (url[2] == "" ? "" : ":" + url[2]) + url[3] + "/" + url[4] + (url[5] == "" ? "" : "#" + url[5]);
    }

    public static String guessContentType(String url) throws Exception {
        String[] sURL = Utils.splitURL(url);
        String ext = "";
        String ct = "";
        int lastDot = sURL[4].lastIndexOf(46);
        if (lastDot >= 0) {
            ext = sURL[4].substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mpg") || url.equals("avi")) {
            ct = "video/mpeg";
        } else if (ext.equals("mid") || ext.equals("kar")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        }
        return ct;
    }

    private static void quickSort(String[] s, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = s[(lo0 + hi0) / 2].toUpperCase();
            while (lo <= hi) {
                while (lo < hi0 && s[lo].toUpperCase().compareTo(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && s[hi].toUpperCase().compareTo(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                String temp = s[lo];
                s[lo] = s[hi];
                s[hi] = temp;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Utils.quickSort(s, lo0, hi);
            }
            if (lo < hi0) {
                Utils.quickSort(s, lo, hi0);
            }
        }
    }

    public static void sort(String[] elements) {
        Utils.quickSort(elements, 0, elements.length - 1);
    }

    static interface Interruptable {
        public void pauseApp();

        public void resumeApp();
    }

    static interface QueryListener {
        public void queryOK(String var1);

        public void queryCancelled();
    }

    static interface ContentHandler {
        public void close();

        public boolean canHandle(String var1);

        public void handle(String var1, String var2);
    }

    static interface BreadCrumbTrail {
        public Displayable go(Displayable var1);

        public Displayable goBack();

        public void handle(String var1, String var2);

        public Displayable replaceCurrent(Displayable var1);

        public Displayable getCurrentDisplayable();
    }

    private static class QueryTask
    implements CommandListener,
    Runnable {
        private static Command cancelCommand = new Command("Cancel", 3, 1);
        private static Command OKCommand = new Command("OK", 4, 1);
        private QueryListener queryListener;
        private BreadCrumbTrail queryBCT;
        private static String queryText = "";

        private QueryTask(QueryListener listener, BreadCrumbTrail bct) {
            this.queryListener = listener;
            this.queryBCT = bct;
        }

        public void commandAction(Command c, Displayable s) {
            if (this.queryBCT != null) {
                Utils.debugOut("Utils.commandAction: goBack()");
                this.queryBCT.goBack();
            }
            if (c == cancelCommand) {
                Utils.debugOut("Command: cancel");
                if (this.queryListener != null) {
                    this.queryListener.queryCancelled();
                }
            } else if (c == OKCommand) {
                Utils.debugOut("Command: OK");
                if (this.queryListener != null) {
                    queryText = "";
                    if (s instanceof TextBox) {
                        queryText = ((TextBox)s).getString();
                    }
                    new Thread(this).start();
                }
            }
        }

        public void run() {
            this.sendListenerEvent();
        }

        private void sendListenerEvent() {
            if (this.queryListener != null) {
                this.queryListener.queryOK(queryText);
            }
        }
    }
}

