/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.BaseListMidlet;
import example.SoccerQ.DrummerCanvas;
import example.SoccerQ.Utils;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class SimpleTones
extends BaseListMidlet
implements Utils.BreadCrumbTrail {
    private static final boolean USE_LONG_MIDI = false;
    private Player mp;
    byte[] niceChord = new byte[]{43, 64, 68, 76, 83, 88, 35, 59, 50, 31};

    public SimpleTones() {
        super("MMAPI Simple Tones");
    }

    protected void fillList(List list) {
        list.append("Short Single Tone", null);
        list.append("Long Single Tone", null);
        list.append("Short MIDI event", null);
        list.append("MMAPI Drummer", null);
        list.addCommand(this.exitCommand);
        list.addCommand(this.playCommand);
    }

    protected void selectCommand(int index) {
        switch (index) {
            case 0: {
                this.simpleTone(60, 100);
                break;
            }
            case 1: {
                this.simpleTone(64, 1000);
                break;
            }
            case 2: {
                this.midiShort();
                break;
            }
            case 3: 
            case 4: {
                this.drummer();
            }
        }
    }

    public void destroyApp(boolean unconditional) {
        if (this.mp != null) {
            this.mp.close();
            this.mp = null;
        }
    }

    private void simpleTone(int note, int duration) {
        try {
            Manager.playTone((int)note, (int)duration, (int)80);
        }
        catch (Exception ex) {
            Utils.error(ex, (Utils.BreadCrumbTrail)this);
        }
    }

    MIDIControl getMIDIControl() throws Exception {
        if (this.mp == null) {
            this.mp = Manager.createPlayer((String)"device://midi");
            this.mp.prefetch();
        }
        return (MIDIControl)this.mp.getControl("javax.microedition.media.control.MIDIControl");
    }

    private void midiShort() {
        try {
            int i;
            MIDIControl mc = this.getMIDIControl();
            for (i = 0; i < this.niceChord.length; ++i) {
                mc.shortMidiEvent(144, (int)this.niceChord[i], 127);
            }
            mc.shortMidiEvent(153, 35, 127);
            mc.shortMidiEvent(153, 35, 0);
            mc.shortMidiEvent(153, 58, 127);
            mc.shortMidiEvent(153, 58, 0);
            mc.shortMidiEvent(153, 57, 127);
            mc.shortMidiEvent(153, 57, 0);
            Thread.sleep(200L);
            for (i = 0; i < this.niceChord.length; ++i) {
                mc.shortMidiEvent(144, (int)this.niceChord[i], 0);
            }
        }
        catch (Exception ex) {
            Utils.error(ex, (Utils.BreadCrumbTrail)this);
        }
    }

    private void midiLong() {
        try {
            MIDIControl mc = this.getMIDIControl();
            int len = this.niceChord.length * 3;
            byte[] data = new byte[len];
            int c = 0;
            for (int i = 0; i < len / 3; ++i) {
                data[c++] = -112;
                data[c++] = this.niceChord[i % this.niceChord.length];
                data[c++] = 127;
            }
            int count = mc.longMidiEvent(data, 0, len);
            Thread.sleep(200L);
            for (int i = 2; i < len; i += 3) {
                data[i] = 0;
            }
            count = mc.longMidiEvent(data, 0, len);
        }
        catch (Exception ex) {
            Utils.error(ex, (Utils.BreadCrumbTrail)this);
        }
    }

    private synchronized void drummer() {
        DrummerCanvas dc = new DrummerCanvas(this, this);
        this.go((Displayable)dc);
        dc.show();
    }

    public void handle(String name, String url) {
        throw new RuntimeException("SimpleTones.handle() must not be called");
    }
}

