/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

class SimpleRmsBrowser
extends List
implements CommandListener,
Utils.ContentHandler {
    private Command backCommand = new Command("Back", 2, 1);
    private Command selCommand = new Command("Select", 8, 1);
    private Command delCommand = new Command("Delete", 8, 1);
    private int lastSelectedRecord;
    private RecordStore currStore;
    private String[] names;
    private Utils.BreadCrumbTrail parent;

    public SimpleRmsBrowser(String title, Utils.BreadCrumbTrail parent) {
        super(title, 3);
        this.parent = parent;
    }

    public void display(String url, int selectedIndex) {
        this.clearLists();
        try {
            String[] sURL = SimpleRmsBrowser.splitURL(url);
            if (!SimpleRmsBrowser.canHandle(sURL)) {
                throw new Exception("Invalid rms URL");
            }
            if (sURL[5] != "") {
                throw new Exception("is a record, not a store");
            }
            if (sURL[4] != "") {
                this.currStore = SimpleRmsBrowser.getRecordStore(sURL, false);
            }
            if (this.currStore != null) {
                RecordEnumeration re = this.currStore.enumerateRecords(null, null, false);
                this.names = new String[re.numRecords()];
                for (int i = 0; i < this.names.length; ++i) {
                    try {
                        int id = re.nextRecordId();
                        this.names[i] = String.valueOf(id);
                        this.append(this.names[i] + " - " + this.currStore.getRecordSize(id) + " bytes", null);
                        continue;
                    }
                    catch (InvalidRecordIDException irie) {
                        this.append("[invalid record ID]", null);
                    }
                }
                if (this.size() == 0) {
                    throw new Exception("no records");
                }
            } else {
                this.names = RecordStore.listRecordStores();
                if (this.names != null && this.names.length > 0) {
                    for (int i = 0; i < this.names.length; ++i) {
                        this.append(this.names[i], null);
                    }
                }
                if (this.size() == 0) {
                    throw new Exception("No record stores!");
                }
            }
        }
        catch (Throwable t) {
            this.append("[" + Utils.friendlyException(t) + "]", null);
        }
        this.setListIndex(selectedIndex);
        this.addCommand(this.backCommand);
        this.addCommand(this.selCommand);
        this.addCommand(this.delCommand);
        this.setCommandListener(this);
    }

    private void setListIndex(int index) {
        if (index >= 0 && index < this.size()) {
            this.setSelectedIndex(index, true);
        }
    }

    private void goBack() {
        if (this.currStore != null) {
            this.display("rms:/", this.lastSelectedRecord);
        } else {
            this.exit();
        }
    }

    private void exit() {
        this.clearLists();
        this.parent.goBack();
    }

    private void clearLists() {
        if (this.currStore != null) {
            try {
                this.currStore.closeRecordStore();
            }
            catch (Exception e) {
                Utils.debugOut(e);
            }
            this.currStore = null;
        }
        this.names = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
        System.gc();
    }

    public void close() {
        this.clearLists();
    }

    public boolean canHandle(String url) {
        try {
            Utils.debugOut("SimpleRmsBrowser.canHandle: isValidRmsURL(" + url + ") = " + SimpleRmsBrowser.isValidRmsURL(SimpleRmsBrowser.splitURL(url)));
            return SimpleRmsBrowser.canHandle(SimpleRmsBrowser.splitURL(url));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void handle(String name, String url) {
        Utils.debugOut("SimpleRmsBrowser: handle " + url);
        this.display(url, 0);
    }

    private static boolean canHandle(String[] sURL) {
        try {
            return SimpleRmsBrowser.isValidRmsURL(sURL) && sURL[5] == "";
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isValidRmsURL(String[] sURL) {
        boolean res;
        boolean bl = res = sURL[0].equals("rms") && sURL[1] == "" && sURL[2] == "" && (sURL[3] == "" || sURL[3].equals("/"));
        if (res && sURL[5] != "" && sURL[4] == "") {
            res = false;
        }
        return res;
    }

    public static boolean isRmsFile(String url) {
        try {
            String[] sURL = SimpleRmsBrowser.splitURL(url);
            return SimpleRmsBrowser.isValidRmsURL(sURL) && sURL[4] != "" && sURL[5] != "";
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String[] splitURL(String url) throws Exception {
        String[] sURL = Utils.splitURL(url);
        if (sURL[4] == "" && sURL[3] != "") {
            sURL[4] = sURL[3];
            sURL[3] = "";
        }
        if (sURL[4].startsWith("/")) {
            sURL[4] = sURL[4].substring(1);
        }
        return sURL;
    }

    public void commandAction(Command c, Displayable s) {
        try {
            if ((c == List.SELECT_COMMAND || c == this.selCommand) && this.isShown()) {
                this.select(this.getSelectedIndex());
            } else if (c == this.backCommand) {
                this.goBack();
            } else if (c == this.delCommand) {
                this.deleteRecord(this.getSelectedIndex());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void select(int index) {
        if (this.names == null || index < 0 || index >= this.names.length) {
            this.goBack();
        }
        if (this.currStore != null) {
            try {
                String name = this.currStore.getName() + "#" + this.names[index];
                this.parent.handle(name, "rms:/" + name);
            }
            catch (Exception e) {
                Utils.error(e, this.parent);
            }
        } else {
            this.lastSelectedRecord = index;
            this.display("rms:/" + this.names[index], 0);
        }
    }

    private void deleteRecord(int index) {
        if (this.names == null || index < 0 || index >= this.names.length) {
            return;
        }
        String name = "";
        String disp = "";
        try {
            if (this.currStore != null) {
                disp = "rms:/" + this.currStore.getName();
                name = "Record " + this.names[index];
                int i = Integer.parseInt(this.names[index]);
                this.currStore.deleteRecord(i);
            } else {
                name = "Record Store " + this.names[index];
                disp = "rms:/";
                RecordStore.deleteRecordStore((String)this.names[index]);
            }
            Utils.FYI(name + " successfully deleted", this.parent);
        }
        catch (Exception e) {
            Utils.error(e, this.parent);
        }
        this.display(disp, 0);
    }

    public static RecordStore getRecordStore(String url, boolean canCreate) throws Exception {
        Utils.debugOut("url = " + url + " can create = " + canCreate);
        return SimpleRmsBrowser.getRecordStore(SimpleRmsBrowser.splitURL(url), canCreate);
    }

    private static RecordStore getRecordStore(String[] sURL, boolean canCreate) throws Exception {
        if (!SimpleRmsBrowser.isValidRmsURL(sURL)) {
            throw new Exception("Invalid rms URL");
        }
        try {
            Utils.debugOut("Trying to open Record Store " + sURL[4] + " can create = " + canCreate);
            return RecordStore.openRecordStore((String)sURL[4], (boolean)canCreate);
        }
        catch (RecordStoreNotFoundException rsnfe) {
            throw new Exception("Recordstore not found");
        }
    }

    private static int getRecordStoreIndex(String[] sURL) throws Exception {
        if (!SimpleRmsBrowser.isValidRmsURL(sURL)) {
            throw new Exception("Invalid rms URL");
        }
        int result = -1;
        try {
            result = Integer.parseInt(sURL[5]);
            if (result < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("invalid record store index");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveToRecordStore(InputStream is, String url) throws IOException, RecordStoreException, Exception {
        RecordStore rs = SimpleRmsBrowser.getRecordStore(SimpleRmsBrowser.splitURL(url), true);
        int ret = 0;
        try {
            ret = SimpleRmsBrowser.saveToRecordStore(is, rs);
        }
        finally {
            rs.closeRecordStore();
        }
        return ret;
    }

    public static int saveToRecordStore(InputStream is, RecordStore rs) throws IOException, RecordStoreException {
        int read;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, read);
        }
        buffer = baos.toByteArray();
        return rs.addRecord(buffer, 0, buffer.length);
    }

    public static InputStream getRecordStoreStream(String url) throws RecordStoreException, Exception {
        Utils.debugOut("getRecordStoreStream(" + url + ")");
        return SimpleRmsBrowser.getRecordStoreStream(SimpleRmsBrowser.splitURL(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getRecordStoreStream(String[] sURL) throws RecordStoreException, Exception {
        InputStream is = null;
        RecordStore rs = SimpleRmsBrowser.getRecordStore(sURL, false);
        try {
            int index = SimpleRmsBrowser.getRecordStoreIndex(sURL);
            is = SimpleRmsBrowser.getRecordStoreStream(rs, index);
        }
        finally {
            rs.closeRecordStore();
        }
        return is;
    }

    public static InputStream getRecordStoreStream(RecordStore rs, int index) throws RecordStoreException, Exception {
        byte[] buffer = rs.getRecord(index);
        return new ByteArrayInputStream(buffer);
    }

    public String toString() {
        return "SimpleRmsBrowser";
    }
}

