/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimplePlayerCanvas;
import example.SoccerQ.Utils;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.RecordControl;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class SimplePlayerGUI
implements CommandListener,
PlayerListener,
ItemStateListener {
    private static final boolean USE_FORM_PLAYER_FOR_VIDEO = false;
    private static final int LIMIT_RATE = 300;
    private static final int LOOP_ONCE = 0;
    private static final int LOOP_3 = 1;
    private static final int LOOP_INF = 2;
    private int loopmode = 0;
    private static final int DEFAULT_TIMER_INTERVAL = 50;
    private int timerInterval = 50;
    private static final int GAUGE_NONE = -1;
    private static final int GAUGE_VOLUME = 0;
    private static final int GAUGE_RATE = 1;
    private static final int GAUGE_TEMPO = 2;
    private static final int GAUGE_PITCH = 3;
    private int gaugeMode = -1;
    private Gauge gauge = null;
    private StringItem gaugeLabel = null;
    private Form gaugeForm = null;
    private Timer guiTimer = null;
    private TimerTask timeDisplayTask = null;
    Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command stopCommand = new Command("Stop", 8, 1);
    private Command metaCommand = new Command("META data", 8, 3);
    private Command volCommand = new Command("Volume", 8, 2);
    private Command muteCommand = new Command("Mute", 8, 1);
    private Command unmuteCommand = new Command("Unmute", 8, 1);
    private Command loopCommand = new Command("Loopmode", 8, 4);
    private Command stcCommand = new Command("Stop in 5 sec", 8, 4);
    private Command selectCommand = new Command("Select", 8, 1);
    private Command skipFwCommand = new Command("Skip Forward", 8, 5);
    private Command skipBwCommand = new Command("Skip Backward", 8, 5);
    private Command rewindCommand = new Command("Rewind", 8, 5);
    private Command rateCommand = new Command("Rate", 8, 5);
    private Command tempoCommand = new Command("Tempo", 8, 5);
    private Command pitchCommand = new Command("Pitch", 8, 5);
    private Command fullScreenCommand = new Command("Full Screen: ON", 8, 5);
    private Command normalScreenCommand = new Command("Full Screen: OFF", 8, 5);
    private Command startRecordCommand = new Command("Start Recording", 8, 5);
    private Command stopRecordCommand = new Command("Stop Recording", 8, 5);
    private Command helpCommand = new Command("Quick Help", 8, 10);
    private Parent parent;
    private Displayable display;
    private static Image logo = null;
    private boolean fullScreen = false;
    private boolean isRecording = false;
    private String recordLocator = "file:///root1/recording.wav";
    private Player player = null;
    private String title;
    private InputStream songInputStream;
    private String durationStr;
    private String songContentType = "";
    private String songLocator = "";
    private String songName = "";
    private String[] songDisplayNames = new String[0];
    private int currSongDisplay = 0;
    private int changeSongDisplayCounter = 0;
    private static final int SONG_DISPLAY_COUNTER = 40;
    private static final int LYRICS_EVENT = 96;
    private static final String LYRICS_KEY = "lyrics";
    public static final int KARAOKE_LINE_COUNT = 0;
    public static final int KARAOKE_LINE = 1;
    public static final int KARAOKE_LINE_INDEX = 2;
    public static final int KARAOKE_SYLLABLE_LENGTH = 3;
    private boolean karaokeMode = false;
    private String karaokeLyrics = "";
    private int currKaraokeLine = 0;
    private int currKaraokeLinePos = 0;
    private int currKaraokeLength = 0;
    private String[] karaokeLines = null;
    private int[] karaokeLinePos = null;
    private int karaokeLineCount = 0;
    private int redisplayKaraokeCounter = 0;
    private int nextKaraokePos = 0;
    private boolean restartOnResume = false;

    private static void debugOut(String s) {
        Utils.debugOut("SimplePlayerGUI: " + s);
    }

    public void initialize(String title, Parent parent) {
        this.title = title;
        this.setParent(parent);
        this.initialize();
    }

    public void setParent(Parent parent) {
        this.parent = parent;
        if (!(parent instanceof Displayable)) {
            throw new RuntimeException("parent must be instanceof Displayable!");
        }
        this.display = (Displayable)parent;
        this.display.addCommand(this.backCommand);
        this.display.setCommandListener((CommandListener)this);
        this.updateTime();
        this.updateRate(null);
        this.updateTempo(null);
        this.durationUpdated();
        parent.updateKaraoke();
        parent.updateDisplay();
    }

    private void initialize() {
        this.karaokeMode = false;
        this.karaokeLyrics = "";
        this.currKaraokeLine = 0;
        this.currKaraokeLinePos = 0;
        this.currKaraokeLength = 0;
        this.karaokeLines = null;
        this.karaokeLinePos = null;
        this.karaokeLineCount = 0;
        this.redisplayKaraokeCounter = 0;
        this.removeCommands();
        this.setStatus("");
        this.durationStr = "";
        this.setSong("No song loaded", "");
        this.guiTimer = new Timer();
    }

    public void setSong(String name, String locator) {
        this.songLocator = locator;
        this.songInputStream = null;
        this.songContentType = "";
        this.doSetSong(name);
    }

    public void setSong(String name, InputStream is, String contentType) {
        this.songLocator = "";
        this.songInputStream = is;
        this.songContentType = contentType;
        this.doSetSong(name);
    }

    public void setSong(String name, Player player) {
        this.songLocator = "";
        this.songInputStream = null;
        this.songContentType = "";
        this.doSetSong(name);
        this.player = player;
    }

    private void doSetSong(String name) {
        this.songName = name;
        this.songDisplayNames = new String[1];
        this.songDisplayNames[0] = name;
        this.currSongDisplay = 0;
        this.closePlayer();
        this.setStatus("");
        this.setFeedback("");
        this.clearKaraoke();
        this.updateTempo(null);
        this.updateTime();
        this.updateSongDisplay();
    }

    public void setTimerInterval(int millis) {
        this.timerInterval = millis;
    }

    private void error(Throwable e) {
        this.error(Utils.friendlyException(e));
        if (Utils.DEBUG) {
            e.printStackTrace();
        }
    }

    private void error(String s) {
        this.setFeedback(s);
    }

    private void setStatus(String s) {
        this.parent.setStatus(s);
        if (Utils.DEBUG) {
            System.out.println("Status: " + s);
        }
    }

    private void setFeedback(String s) {
        this.parent.setFeedback(s);
        if (Utils.DEBUG) {
            System.out.println("Feedback: " + s);
        }
    }

    private void updateKaraoke() {
        this.parent.updateKaraoke();
    }

    private void updateTime() {
        this.parent.updateTime();
    }

    private void updateRate(RateControl c) {
        this.parent.updateRate();
        if (this.gauge != null && this.gaugeMode == 1) {
            if (c == null) {
                c = this.getRateControl();
            }
            if (c != null) {
                String disp = this.getRateStr();
                this.gauge.setValue((c.getRate() - c.getMinRate()) / 1000);
                this.gaugeLabel.setLabel(disp);
            }
        }
    }

    private void updateTempo(TempoControl c) {
        this.parent.updateRate();
        if (this.gauge != null && this.gaugeMode == 2) {
            if (c == null) {
                c = this.getTempoControl();
            }
            if (c != null) {
                String disp = this.getTempoStr();
                this.gauge.setValue(c.getTempo() / 1000 - 1);
                this.gaugeLabel.setLabel(disp);
            }
        }
    }

    private void updateVolume(VolumeControl c) {
        if (c == null) {
            c = this.getVolumeControl();
        }
        if (c != null) {
            int l = c.getLevel();
            String disp = "Volume: " + String.valueOf(l);
            if (c.isMuted()) {
                disp = disp + " (muted)";
            }
            if (this.gauge != null && this.gaugeMode == 0) {
                this.gauge.setValue(l);
                this.gaugeLabel.setLabel(disp);
            }
            this.setFeedback(disp);
        }
    }

    private void updatePitch(PitchControl c) {
        if (c == null) {
            c = this.getPitchControl();
        }
        if (c != null) {
            String disp = "Transpose: " + this.toFloatString(c.getPitch(), 3) + " semi tones";
            if (this.gauge != null && this.gaugeMode == 3) {
                this.gauge.setValue((c.getPitch() - c.getMinPitch()) / 1000);
                this.gaugeLabel.setLabel(disp);
            }
            this.setFeedback(disp);
        }
    }

    private void updateLoop() {
        if (this.player != null) {
            try {
                int loop = 1;
                switch (this.loopmode) {
                    case 0: {
                        loop = 1;
                        break;
                    }
                    case 1: {
                        loop = 3;
                        break;
                    }
                    case 2: {
                        loop = -1;
                    }
                }
                boolean restart = false;
                if (this.player.getState() == 400) {
                    this.player.stop();
                    restart = true;
                }
                this.player.setLoopCount(loop);
                if (restart) {
                    this.player.start();
                }
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }

    private void updateSongDisplay() {
        String add = "";
        if (this.currSongDisplay == 0) {
            add = this.durationStr;
        }
        this.parent.setFileTitle(this.songDisplayNames[this.currSongDisplay] + add);
    }

    private void durationUpdated() {
        if (this.player != null) {
            try {
                long duration = this.player.getDuration();
                this.durationStr = duration >= 0L ? " (" + this.timeDisplay(duration) + ")" : "";
            }
            catch (IllegalStateException ise) {
                this.durationStr = "";
            }
            this.updateSongDisplay();
        }
    }

    private void clearKaraoke() {
        this.karaokeLineCount = 0;
        this.nextKaraokePos = -1;
        this.redisplayKaraokeCounter = 0;
        this.updateKaraoke();
    }

    public Image getLogo() {
        if (logo == null) {
            try {
                logo = Image.createImage((String)"/icons/logo.png");
            }
            catch (Exception ex) {
                logo = null;
            }
            if (logo == null) {
                SimplePlayerGUI.debugOut("can not load logo.png");
            }
        }
        return logo;
    }

    private String toFloatString(int number, int digitsAfterDot) {
        StringBuffer ret = new StringBuffer(String.valueOf(number));
        while (ret.length() < digitsAfterDot + 1) {
            ret.insert(0, '0');
        }
        ret.insert(ret.length() - digitsAfterDot, '.');
        return ret.toString();
    }

    private String formatNumber(long num, int len, boolean leadingZeros) {
        StringBuffer ret = new StringBuffer(String.valueOf(num));
        if (leadingZeros) {
            while (ret.length() < len) {
                ret.insert(0, '0');
            }
        } else {
            while (ret.length() < len) {
                ret.append('0');
            }
        }
        return ret.toString();
    }

    private String timeDisplay(long us) {
        long ts = us / 100000L;
        return this.formatNumber(ts / 600L, 2, true) + ":" + this.formatNumber(ts % 600L / 10L, 2, true) + "." + String.valueOf(ts % 10L);
    }

    public String getMediaTimeStr() {
        try {
            if (this.player != null) {
                return this.timeDisplay(this.player.getMediaTime());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return "--:--:-";
    }

    public String getTempoStr() {
        TempoControl tc;
        if (this.player != null && (tc = this.getTempoControl()) != null) {
            int tempo = tc.getTempo();
            return this.toFloatString((tempo + 50) / 100, 1) + "bpm (eff: " + this.toFloatString((int)(((long)tc.getRate() * (long)tempo / 100000L + 50L) / 100L), 1) + ")";
        }
        return "";
    }

    public String getRateStr() {
        RateControl rc;
        if (this.player != null && (rc = this.getRateControl()) != null) {
            return "Rate: " + this.toFloatString(rc.getRate() / 100, 1) + "%";
        }
        return "";
    }

    private void displayNextKaraokePhrase() {
        if (this.karaokeLyrics != null && this.karaokeLineCount > 0 && this.karaokeLines != null && this.nextKaraokePos >= 0 && this.nextKaraokePos < this.karaokeLyrics.length() && this.nextKaraokePos > this.karaokeLinePos[this.currKaraokeLine]) {
            this.setupKaraokeLines(this.nextKaraokePos, 0);
            this.updateKaraoke();
        }
    }

    private void addKaraokeLine(int start, int end) {
        if (this.karaokeLines == null || this.karaokeLines.length <= this.karaokeLineCount) {
            String[] newKL = new String[this.karaokeLineCount + 4];
            if (this.karaokeLines != null) {
                System.arraycopy(this.karaokeLines, 0, newKL, 0, this.karaokeLineCount);
            }
            this.karaokeLines = newKL;
            int[] newKLP = new int[this.karaokeLineCount + 5];
            if (this.karaokeLinePos != null) {
                System.arraycopy(this.karaokeLinePos, 0, newKLP, 0, this.karaokeLineCount + 1);
            }
            this.karaokeLinePos = newKLP;
        }
        this.karaokeLines[this.karaokeLineCount] = this.karaokeLyrics.substring(start, end);
        this.karaokeLinePos[this.karaokeLineCount++] = start;
    }

    private void setupKaraokeLines(int pos, int syllableLen) {
        int len;
        int n = len = this.karaokeLyrics == null ? 0 : this.karaokeLyrics.length();
        if (len == 0) {
            SimplePlayerGUI.debugOut("no karaoke lyrics");
            return;
        }
        this.nextKaraokePos = -1;
        if (pos < 0 || pos >= len) {
            this.karaokeLineCount = 0;
            SimplePlayerGUI.debugOut("setupKaraokeLines: pos out of bounds!");
            return;
        }
        while (this.karaokeLyrics.charAt(pos) == '\\' || this.karaokeLyrics.charAt(pos) == '/') {
            ++pos;
            --syllableLen;
        }
        if (syllableLen < 0) {
            syllableLen = 0;
        }
        if (this.karaokeLinePos == null || this.karaokeLineCount == 0 || pos < this.karaokeLinePos[0] || pos >= this.karaokeLinePos[this.karaokeLineCount]) {
            int endPos;
            int startPos;
            for (startPos = pos; this.karaokeLyrics.charAt(startPos) != '\\' && startPos > 0; --startPos) {
            }
            if (this.karaokeLyrics.charAt(startPos) == '\\') {
                ++startPos;
            }
            this.karaokeLineCount = 0;
            for (endPos = startPos; endPos < len; ++endPos) {
                char c = this.karaokeLyrics.charAt(endPos);
                if (c == '/') {
                    this.addKaraokeLine(startPos, endPos);
                    startPos = endPos + 1;
                    continue;
                }
                if (c == '\\') break;
            }
            this.addKaraokeLine(startPos, endPos);
            if (endPos < len) {
                // empty if block
            }
            this.karaokeLinePos[this.karaokeLineCount] = --endPos;
        }
        this.currKaraokeLength = 0;
        for (int i = 0; i < this.karaokeLineCount; ++i) {
            if (pos < this.karaokeLinePos[i] || pos >= this.karaokeLinePos[i + 1]) continue;
            this.currKaraokeLine = i;
            this.currKaraokeLinePos = pos - this.karaokeLinePos[i];
            this.currKaraokeLength = syllableLen;
            if (this.currKaraokeLinePos + syllableLen < this.karaokeLines[i].length()) break;
            this.nextKaraokePos = this.karaokeLinePos[i + 1] + 1;
            this.redisplayKaraokeCounter = 3;
            break;
        }
    }

    public String[] getKaraokeStr(int[] params) {
        params[0] = this.karaokeLineCount;
        params[1] = this.currKaraokeLine;
        params[2] = this.currKaraokeLinePos;
        params[3] = this.currKaraokeLength;
        return this.karaokeLines;
    }

    private void goBack() {
        Displayable now;
        if (this.parent.getCurrentDisplayable() == this.display) {
            this.closePlayer();
        }
        if ((now = this.parent.goBack()) == this.display) {
            this.setPlayerCommands();
        }
    }

    private void setPlayerCommands() {
        this.removeCommands();
        this.display.addCommand(this.backCommand);
        if (this.player != null) {
            VolumeControl vc;
            if (this.getMetaDataControl() != null) {
                this.display.addCommand(this.metaCommand);
            }
            if (this.getStopTimeControl() != null) {
                this.display.addCommand(this.stcCommand);
            }
            if ((vc = this.getVolumeControl()) != null) {
                this.display.addCommand(this.volCommand);
                if (vc.isMuted()) {
                    this.display.addCommand(this.unmuteCommand);
                } else {
                    this.display.addCommand(this.muteCommand);
                }
            }
            if (this.getRateControl() != null) {
                this.display.addCommand(this.rateCommand);
            }
            if (this.getTempoControl() != null) {
                this.display.addCommand(this.tempoCommand);
            }
            if (this.getPitchControl() != null) {
                this.display.addCommand(this.pitchCommand);
            }
            if (this.getVideoControl() != null) {
                this.display.addCommand(this.normalScreenCommand);
                this.display.addCommand(this.fullScreenCommand);
            }
            if (this.getRecordControl() != null) {
                if (this.isRecording) {
                    this.display.addCommand(this.stopRecordCommand);
                } else {
                    this.display.addCommand(this.startRecordCommand);
                }
            }
            this.display.addCommand(this.loopCommand);
            if (this.player.getState() >= 400) {
                this.display.addCommand(this.stopCommand);
            } else {
                this.display.addCommand(this.playCommand);
            }
            this.display.addCommand(this.skipFwCommand);
            this.display.addCommand(this.skipBwCommand);
            this.display.addCommand(this.rewindCommand);
            if (this.parent instanceof SimplePlayerCanvas) {
                this.display.addCommand(this.helpCommand);
            }
        }
    }

    private void removeCommands() {
        this.display.removeCommand(this.muteCommand);
        this.display.removeCommand(this.unmuteCommand);
        this.display.removeCommand(this.metaCommand);
        this.display.removeCommand(this.volCommand);
        this.display.removeCommand(this.stcCommand);
        this.display.removeCommand(this.loopCommand);
        this.display.removeCommand(this.backCommand);
        this.display.removeCommand(this.playCommand);
        this.display.removeCommand(this.stopCommand);
        this.display.removeCommand(this.skipFwCommand);
        this.display.removeCommand(this.skipBwCommand);
        this.display.removeCommand(this.rewindCommand);
        this.display.removeCommand(this.rateCommand);
        this.display.removeCommand(this.tempoCommand);
        this.display.removeCommand(this.pitchCommand);
        this.display.removeCommand(this.fullScreenCommand);
        this.display.removeCommand(this.normalScreenCommand);
        this.display.removeCommand(this.startRecordCommand);
        this.display.removeCommand(this.stopRecordCommand);
        this.display.removeCommand(this.helpCommand);
    }

    private void mutePressed() {
        VolumeControl c = this.getVolumeControl();
        if (c != null) {
            if (c.isMuted()) {
                this.display.removeCommand(this.unmuteCommand);
                this.display.addCommand(this.muteCommand);
                c.setMute(false);
            } else {
                this.display.removeCommand(this.muteCommand);
                this.display.addCommand(this.unmuteCommand);
                c.setMute(true);
            }
            this.updateVolume(c);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    private void displayGauge(String title) {
        if (this.gaugeForm == null) {
            this.gaugeForm = new Form(title);
            this.gaugeForm.append((Item)this.gauge);
            this.gaugeForm.append((Item)this.gaugeLabel);
            this.gaugeForm.setItemStateListener((ItemStateListener)this);
            this.gaugeForm.addCommand(this.backCommand);
            this.gaugeForm.setCommandListener((CommandListener)this);
        }
        this.parent.go((Displayable)this.gaugeForm);
    }

    private void volPressed() {
        VolumeControl c = this.getVolumeControl();
        if (c != null) {
            if (this.gauge == null || this.gaugeMode != 0) {
                this.gauge = new Gauge("Volume", true, 100, c.getLevel());
                this.gaugeLabel = new StringItem("Volume", "");
                this.gaugeMode = 0;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Volume");
            this.updateVolume(c);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    private void ratePressed() {
        RateControl c = this.getRateControl();
        if (c != null) {
            if (this.gauge == null || this.gaugeMode != 1) {
                int minRate = c.getMinRate() / 1000;
                int maxRate = c.getMaxRate() / 1000;
                if (maxRate > 300) {
                    maxRate = 300;
                }
                int currRate = c.getRate() / 1000;
                this.gauge = new Gauge("Rate", true, maxRate - minRate, currRate - minRate);
                this.gaugeLabel = new StringItem("Rate", "");
                this.gaugeMode = 1;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Rate");
            this.updateRate(c);
        } else {
            this.setFeedback("No RateControl!");
        }
    }

    private void pitchPressed() {
        PitchControl c = this.getPitchControl();
        if (c != null) {
            if (this.gauge == null || this.gaugeMode != 3) {
                this.gauge = new Gauge("Pitch", true, (c.getMaxPitch() - c.getMinPitch()) / 1000, (c.getPitch() - c.getMinPitch()) / 1000);
                this.gaugeLabel = new StringItem("Pitch", "");
                this.gaugeMode = 3;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Pitch");
            this.updatePitch(c);
        } else {
            this.setFeedback("No PitchControl!");
        }
    }

    private void tempoPressed() {
        TempoControl c = this.getTempoControl();
        if (c != null) {
            if (this.gauge == null || this.gaugeMode != 2) {
                this.gauge = new Gauge("Tempo", true, 399, c.getTempo() / 1000 - 1);
                this.gaugeLabel = new StringItem("Tempo", "");
                this.gaugeMode = 2;
                this.gaugeForm = null;
            }
            this.displayGauge("Set Tempo");
            this.updateTempo(c);
        } else {
            this.setFeedback("No TempoControl!");
        }
    }

    private void metaPressed() {
        MetaDataControl c = this.getMetaDataControl();
        if (c != null) {
            List list = new List("Meta Data", 3);
            String[] allkeys = c.getKeys();
            Utils.sort(allkeys);
            for (int i = 0; i < allkeys.length; ++i) {
                try {
                    if (allkeys[i].equals(LYRICS_KEY)) continue;
                    list.append(allkeys[i] + " = " + c.getKeyValue(allkeys[i]), null);
                    continue;
                }
                catch (IllegalArgumentException t) {
                    list.append(allkeys[i] + ": " + Utils.friendlyException(t), null);
                }
            }
            if (allkeys.length == 0) {
                list.append("No meta data", null);
            }
            list.addCommand(this.backCommand);
            list.setCommandListener((CommandListener)this);
            this.parent.go((Displayable)list);
        } else {
            this.setFeedback("No MetaDataControl!");
        }
    }

    private void loopPressed() {
        this.loopmode = (this.loopmode + 1) % 3;
        String fb = "";
        switch (this.loopmode) {
            case 0: {
                fb = "one time";
                break;
            }
            case 1: {
                fb = "3 times";
                break;
            }
            case 2: {
                fb = "infinite";
            }
        }
        this.setFeedback("Set loop mode to " + fb);
        this.updateLoop();
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public boolean toggleFullScreen() {
        VideoControl vc = this.getVideoControl();
        Utils.debugOut("toggleFullScreen");
        if (vc != null) {
            try {
                vc.setDisplayFullScreen(!this.fullScreen);
                this.fullScreen = !this.fullScreen;
                this.parent.fullScreen(this.fullScreen);
                Utils.debugOut("Successfully set to " + (this.fullScreen ? "full screen" : "normal screen"));
            }
            catch (Exception e) {
                this.fullScreen = false;
                this.display.removeCommand(this.fullScreenCommand);
                this.display.removeCommand(this.normalScreenCommand);
                this.error(e);
            }
        } else {
            this.setFeedback("No VideoControl!");
        }
        return this.fullScreen;
    }

    private void fullScreenPressed() {
        this.fullScreen = false;
        this.toggleFullScreen();
    }

    private void normalScreenPressed() {
        this.fullScreen = true;
        this.toggleFullScreen();
    }

    public void stepFrame(int frames) {
        FramePositioningControl fpc = this.getFramePositioningControl();
        if (fpc != null) {
            fpc.skip(frames);
        } else {
            this.setFeedback("No FramePositioningControl!");
        }
    }

    public boolean hasRateControl() {
        return this.getRateControl() != null;
    }

    public boolean hasTempoControl() {
        return this.getTempoControl() != null;
    }

    public boolean hasGUIControls() {
        try {
            if (this.player != null) {
                return this.player.getControl("GUIControl") != null || this.player.getControl("VideoControl") != null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }

    public Control[] getControls() {
        try {
            if (this.player != null) {
                return this.player.getControls();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private VolumeControl getVolumeControl() {
        try {
            if (this.player != null) {
                return (VolumeControl)this.player.getControl("VolumeControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private TempoControl getTempoControl() {
        try {
            if (this.player != null) {
                return (TempoControl)this.player.getControl("TempoControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private RateControl getRateControl() {
        try {
            if (this.player != null) {
                return (RateControl)this.player.getControl("RateControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private PitchControl getPitchControl() {
        try {
            if (this.player != null) {
                return (PitchControl)this.player.getControl("PitchControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private MetaDataControl getMetaDataControl() {
        try {
            if (this.player != null) {
                return (MetaDataControl)this.player.getControl("MetaDataControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private FramePositioningControl getFramePositioningControl() {
        try {
            if (this.player != null) {
                return (FramePositioningControl)this.player.getControl("FramePositioningControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private StopTimeControl getStopTimeControl() {
        try {
            if (this.player != null) {
                return (StopTimeControl)this.player.getControl("StopTimeControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public VideoControl getVideoControl() {
        try {
            if (this.player != null) {
                return (VideoControl)this.player.getControl("VideoControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public RecordControl getRecordControl() {
        try {
            if (this.player != null) {
                return (RecordControl)this.player.getControl("RecordControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private void assertPlayer() throws Throwable {
        String state = "";
        try {
            SimplePlayerGUI.debugOut("assertPlayer");
            this.fullScreen = false;
            this.display.removeCommand(this.backCommand);
            this.display.addCommand(this.backCommand);
            if (this.player == null) {
                if (this.songInputStream == null) {
                    state = "Opening " + this.songLocator;
                    this.setStatus(state + "...");
                    this.player = Manager.createPlayer((String)this.songLocator);
                } else {
                    state = "Opening " + this.songName;
                    this.setStatus(state + "...");
                    this.player = Manager.createPlayer((InputStream)this.songInputStream, (String)this.songContentType);
                }
            }
            this.player.addPlayerListener((PlayerListener)this);
            state = "Realizing";
            this.setStatus(state + "...");
            this.player.realize();
            state = "Prefetching";
            this.setStatus(state + "...");
            this.player.prefetch();
            state = "Prefetched";
            this.setStatus(state);
            this.setPlayerCommands();
            this.parent.setupDisplay();
            MetaDataControl mc = this.getMetaDataControl();
            if (mc != null) {
                int titleCount = 0;
                String title = "";
                try {
                    title = mc.getKeyValue("title");
                    if (title != null && title != "") {
                        String n;
                        ++titleCount;
                        while ((n = mc.getKeyValue("title" + (titleCount + 1))) != null && n != "") {
                            ++titleCount;
                        }
                    }
                }
                catch (IllegalArgumentException me) {
                    // empty catch block
                }
                if (titleCount > 0) {
                    this.songDisplayNames = new String[titleCount];
                    this.songDisplayNames[0] = title;
                    try {
                        for (int i = 1; i < titleCount; ++i) {
                            this.songDisplayNames[i] = mc.getKeyValue("title" + (i + 1));
                        }
                    }
                    catch (IllegalArgumentException me) {
                        // empty catch block
                    }
                    this.currSongDisplay = 0;
                }
                try {
                    String l = mc.getKeyValue(LYRICS_KEY);
                    if (l != null && l != "") {
                        this.karaokeMode = true;
                        this.karaokeLyrics = l;
                    }
                }
                catch (IllegalArgumentException me) {
                    // empty catch block
                }
            }
            this.durationUpdated();
        }
        catch (Throwable t) {
            this.player = null;
            this.setStatus("");
            throw new MediaException(Utils.friendlyException(t) + " at " + state);
        }
    }

    public void startPlayer() {
        try {
            SimplePlayerGUI.debugOut("startPlayer");
            if (this.player == null || this.player.getState() < 300) {
                this.assertPlayer();
            }
            if (this.player == null || this.player.getState() >= 400) {
                return;
            }
            this.updateLoop();
            try {
                long duration = this.player.getDuration();
                if (duration != -1L && this.player.getMediaTime() >= duration) {
                    this.player.setMediaTime(0L);
                }
            }
            catch (MediaException e) {
                // empty catch block
            }
            if (this.player.getMediaTime() == 0L) {
                this.setupKaraokeLines(0, 0);
                this.updateKaraoke();
            } else {
                this.clearKaraoke();
            }
            this.setStatus("Starting...");
            this.player.start();
            this.setStatus("Playing");
            this.setFeedback("");
            this.updateTempo(null);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    public void closePlayer() {
        if (this.player != null) {
            this.setStatus("Stopping...");
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStatus("Closing...");
            this.player.close();
            this.setStatus("Closed");
            this.player = null;
            this.initialize();
        }
    }

    public void pausePlayer() {
        if (this.player != null) {
            this.setStatus("Stopping...");
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clearKaraoke();
            this.setStatus("Stopped");
            this.setFeedback("");
        }
    }

    public void togglePlayer() {
        if (this.player != null) {
            if (this.player.getState() == 400) {
                this.pausePlayer();
            } else {
                this.startPlayer();
            }
        }
    }

    public void skip(boolean backwards) {
        if (this.player != null) {
            try {
                long mTime = this.player.getMediaTime();
                long jump = 10000000L;
                long duration = this.player.getDuration();
                if (duration >= 0L && (jump = duration / 20L) < 2000000L) {
                    jump = 2000000L;
                }
                if (backwards) {
                    this.setMediaTime(mTime - jump);
                } else {
                    this.setMediaTime(mTime + jump);
                }
            }
            catch (IllegalStateException ise) {
                this.error(ise);
            }
        }
    }

    public void stopAfterTime() {
        int delay = 5000000;
        StopTimeControl stc = this.getStopTimeControl();
        if (stc != null) {
            try {
                stc.setStopTime(Long.MAX_VALUE);
                stc.setStopTime(this.player.getMediaTime() + (long)delay);
                this.setFeedback("Stop in " + delay / 1000000 + " seconds.");
            }
            catch (IllegalStateException ise) {
                this.error(ise);
            }
        } else {
            this.setFeedback("No StopTimeControl!");
        }
    }

    public void changeRate(boolean slowdown) {
        RateControl rc;
        int diff = 10000;
        if (slowdown) {
            diff = -diff;
        }
        if ((rc = this.getRateControl()) != null) {
            int ocr = rc.getRate();
            int ncr = ocr + diff;
            int maxRate = rc.getMaxRate();
            if (maxRate > 300000) {
                maxRate = 300000;
            }
            if (ncr >= rc.getMinRate() && ncr <= maxRate) {
                int ecr = rc.setRate(ncr);
                this.setFeedback("New rate: " + this.toFloatString(ecr, 3) + "%");
                this.updateRate(rc);
                this.updateTempo(null);
            }
        } else {
            this.setFeedback("No RateControl!");
        }
    }

    public void setMediaTime(long time) {
        if (this.player == null) {
            return;
        }
        try {
            this.setFeedback("Set MediaTime to " + this.timeDisplay(time));
            this.player.setMediaTime(time);
            this.updateTime();
            this.clearKaraoke();
            this.updateTempo(null);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void changeVolume(boolean decrease) {
        VolumeControl vc;
        int diff = 10;
        if (decrease) {
            diff = -diff;
        }
        if ((vc = this.getVolumeControl()) != null) {
            int cv = vc.getLevel();
            vc.setLevel(cv += diff);
            this.updateVolume(vc);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    public void toggleMute() {
        VolumeControl vc = this.getVolumeControl();
        if (vc != null) {
            vc.setMute(!vc.isMuted());
            this.updateVolume(vc);
        } else {
            this.setFeedback("No VolumeControl!");
        }
    }

    public void transpose(boolean down) {
        PitchControl pc;
        int diff = 1000;
        if (down) {
            diff = -diff;
        }
        if ((pc = this.getPitchControl()) != null) {
            pc.setPitch(pc.getPitch() + diff);
            this.updatePitch(pc);
        } else if (this.getFramePositioningControl() != null) {
            this.skipFrame(down);
        } else {
            this.setFeedback("No PitchControl!");
        }
    }

    public void skipFrame(boolean back) {
        FramePositioningControl fpc;
        int diff = 1;
        if (back) {
            diff = -diff;
        }
        if ((fpc = this.getFramePositioningControl()) != null) {
            int res = fpc.skip(diff);
            this.setFeedback("Skipped: " + res + " frames to " + fpc.mapTimeToFrame(this.player.getMediaTime()));
        } else {
            this.setFeedback("No FramePositioningControl!");
        }
    }

    private void queryRecording() {
        try {
            Utils.query("Enter a record locator", this.recordLocator, 200, 4, new RecordTask(), this.parent);
        }
        catch (Exception e) {
            Utils.error(e, (Utils.BreadCrumbTrail)this.parent);
        }
    }

    private void startRecording(String locator) {
        block4: {
            try {
                if (locator == null || locator == "") {
                    Utils.error("No locator set!", (Utils.BreadCrumbTrail)this.parent);
                    break block4;
                }
                this.recordLocator = locator;
                RecordControl rc = this.getRecordControl();
                if (rc != null) {
                    rc.stopRecord();
                    rc.reset();
                    rc.setRecordLocation(locator);
                    rc.startRecord();
                    break block4;
                }
                throw new MediaException("Could not get RecordControl!");
            }
            catch (Exception e) {
                Utils.error(e, (Utils.BreadCrumbTrail)this.parent);
            }
        }
    }

    private void stopRecording() {
        try {
            final RecordControl rc = this.getRecordControl();
            if (rc == null) {
                throw new MediaException("Could not get RecordControl!");
            }
            rc.stopRecord();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        rc.commit();
                        Utils.FYI("Recorded " + SimplePlayerGUI.this.recordLocator + " successfully.", SimplePlayerGUI.this.parent);
                    }
                    catch (Exception e) {
                        Utils.error(e, (Utils.BreadCrumbTrail)SimplePlayerGUI.this.parent);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            Utils.error(e, (Utils.BreadCrumbTrail)this.parent);
        }
    }

    private void showHelp() {
        if (this.parent instanceof SimplePlayerCanvas) {
            ((SimplePlayerCanvas)this.parent).showHelp();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.backCommand) {
            this.goBack();
        } else if (c == this.muteCommand || c == this.unmuteCommand) {
            this.mutePressed();
        } else if (c == this.volCommand) {
            this.volPressed();
        } else if (c == this.metaCommand) {
            this.metaPressed();
        } else if (c == this.loopCommand) {
            this.loopPressed();
        } else if (c == this.stcCommand) {
            this.stopAfterTime();
        } else if (c == this.playCommand || c == this.stopCommand) {
            this.togglePlayer();
        } else if (c == this.skipFwCommand) {
            this.skip(false);
        } else if (c == this.skipBwCommand) {
            this.skip(true);
        } else if (c == this.rewindCommand) {
            this.setMediaTime(0L);
        } else if (c == this.rateCommand) {
            this.ratePressed();
        } else if (c == this.tempoCommand) {
            this.tempoPressed();
        } else if (c == this.pitchCommand) {
            this.pitchPressed();
        } else if (c == this.fullScreenCommand) {
            this.fullScreenPressed();
        } else if (c == this.normalScreenCommand) {
            this.normalScreenPressed();
        } else if (c == this.startRecordCommand) {
            this.queryRecording();
        } else if (c == this.stopRecordCommand) {
            this.stopRecording();
        } else if (c == this.helpCommand) {
            this.showHelp();
        } else if (s != this.display) {
            this.goBack();
        }
    }

    private synchronized void startDisplayTimer() {
        if (this.timeDisplayTask == null) {
            this.timeDisplayTask = new SPTimerTask();
            this.guiTimer.scheduleAtFixedRate(this.timeDisplayTask, 0L, (long)this.timerInterval);
        }
    }

    private synchronized void stopDisplayTimer() {
        if (this.timeDisplayTask != null) {
            this.timeDisplayTask.cancel();
            this.timeDisplayTask = null;
            this.updateTime();
        }
    }

    public void playerUpdate(Player plyr, String evt, Object evtData) {
        try {
            byte[] data;
            if (evt == "endOfMedia" && plyr.getState() == 400) {
                this.setFeedback("Looping");
                return;
            }
            if (evt == "closed" || evt == "error" || evt == "endOfMedia" || evt == "stoppedAtTime" || evt == "stopped") {
                this.stopDisplayTimer();
            }
            if (evt == "endOfMedia" || evt == "stoppedAtTime" || evt == "stopped" || evt == "error") {
                this.display.removeCommand(this.stopCommand);
                this.display.addCommand(this.playCommand);
                this.changeSongDisplayCounter = 0;
                this.currSongDisplay = 0;
                this.updateSongDisplay();
            }
            if (evt.equals("com.sun.midi.lyrics") && (data = (byte[])evtData) != null && evtData instanceof byte[] && data.length > 0) {
                if (Utils.DEBUG) {
                    System.out.println("META event 0x" + Integer.toHexString(data[0] & 0xFF));
                }
                switch (data[0]) {
                    case 1: 
                    case 5: {
                        if (this.karaokeMode) break;
                    }
                    case 6: 
                    case 7: {
                        String text = new String(data, 1, data.length - 1);
                        this.setFeedback(text);
                        if (!Utils.DEBUG) break;
                        System.out.println("META event 0x" + Integer.toHexString(data[0] & 0xFF) + ": " + text);
                        break;
                    }
                    case 81: {
                        this.updateTempo(null);
                        break;
                    }
                    case 96: {
                        int kPos = data[1] << 16 | data[2] << 8 | data[3] & 0xFF;
                        int kLen = data[4] << 16 | data[5] << 8 | data[6] & 0xFF;
                        this.setupKaraokeLines(kPos, kLen);
                        this.updateKaraoke();
                    }
                }
            }
            if (evt == "started") {
                if (this.songDisplayNames.length > 1) {
                    this.changeSongDisplayCounter = 80;
                }
                this.startDisplayTimer();
                this.display.addCommand(this.stopCommand);
                this.display.removeCommand(this.playCommand);
            } else if (evt == "deviceUnavailable") {
                this.setFeedback("Audio device not available!");
            } else if (evt == "bufferingStarted") {
                this.setFeedback("Buffering started");
            } else if (evt == "bufferingStopped") {
                this.setFeedback("Buffering stopped");
            } else if (evt == "closed") {
                this.setFeedback("Closed");
            } else if (evt == "durationUpdated") {
                this.setFeedback("Duration updated");
                this.durationUpdated();
            } else if (evt == "endOfMedia") {
                this.setStatus("End of media.");
                this.setFeedback("");
            } else if (evt == "error") {
                this.setFeedback("Error: " + (String)evtData);
            } else if (evt == "recordStarted") {
                this.isRecording = true;
                this.display.addCommand(this.stopRecordCommand);
                this.display.removeCommand(this.startRecordCommand);
                this.setFeedback("Recording Started");
            } else if (evt == "recordStopped") {
                this.isRecording = false;
                this.display.addCommand(this.startRecordCommand);
                this.display.removeCommand(this.stopRecordCommand);
                this.setFeedback("Recording Stopped");
            } else if (evt == "sizeChanged") {
                int[] newDim = (int[])evtData;
                this.setFeedback("Resize to " + newDim[0] + "x" + newDim[1]);
            } else if (evt == "stoppedAtTime") {
                this.setStatus("Stopped at time.");
                this.setFeedback("");
            } else if (evt == "volumeChanged") {
                VolumeControl vc = (VolumeControl)evtData;
                this.setFeedback("New volume: " + vc.getLevel());
                this.updateVolume(vc);
            }
        }
        catch (Throwable t) {
            if (Utils.DEBUG) {
                System.out.println("Uncaught Exception in SimplePlayerGUI.playerUpdate()");
            }
            this.error(t);
        }
    }

    public void itemStateChanged(Item item) {
        if (item != null && item == this.gauge) {
            switch (this.gaugeMode) {
                case 0: {
                    VolumeControl vc = this.getVolumeControl();
                    if (vc == null) break;
                    vc.setLevel(this.gauge.getValue());
                    this.updateVolume(vc);
                    break;
                }
                case 1: {
                    RateControl rc = this.getRateControl();
                    if (rc == null) break;
                    rc.setRate(this.gauge.getValue() * 1000 + rc.getMinRate());
                    this.updateRate(rc);
                    break;
                }
                case 2: {
                    TempoControl tc = this.getTempoControl();
                    if (tc == null) break;
                    tc.setTempo((this.gauge.getValue() + 1) * 1000);
                    this.updateTempo(tc);
                    break;
                }
                case 3: {
                    PitchControl pc = this.getPitchControl();
                    if (pc == null) break;
                    pc.setPitch(this.gauge.getValue() * 1000 + pc.getMinPitch());
                    this.updatePitch(pc);
                }
            }
        }
    }

    public synchronized void pauseApp() {
        if (this.player != null && this.player.getState() >= 400) {
            try {
                this.player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.stopDisplayTimer();
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void resumeApp() {
        if (this.player != null && this.restartOnResume) {
            try {
                this.player.start();
            }
            catch (MediaException me) {
                this.error(me);
            }
        }
        this.restartOnResume = false;
    }

    static interface Parent
    extends Utils.BreadCrumbTrail {
        public Utils.BreadCrumbTrail getParent();

        public String getTitle();

        public void setupDisplay();

        public void setStatus(String var1);

        public void setFeedback(String var1);

        public void setFileTitle(String var1);

        public void updateKaraoke();

        public void updateTime();

        public void updateRate();

        public void updateDisplay();

        public void fullScreen(boolean var1);
    }

    private class SPTimerTask
    extends TimerTask {
        private SPTimerTask() {
        }

        public void run() {
            SimplePlayerGUI.this.updateTime();
            if (SimplePlayerGUI.this.redisplayKaraokeCounter > 0) {
                SimplePlayerGUI.this.redisplayKaraokeCounter--;
                if (SimplePlayerGUI.this.redisplayKaraokeCounter == 0) {
                    SimplePlayerGUI.this.displayNextKaraokePhrase();
                }
            }
            if (SimplePlayerGUI.this.changeSongDisplayCounter > 0 && SimplePlayerGUI.this.songDisplayNames.length > 0) {
                SimplePlayerGUI.this.changeSongDisplayCounter--;
                if (SimplePlayerGUI.this.changeSongDisplayCounter == 0) {
                    SimplePlayerGUI.this.currSongDisplay = (SimplePlayerGUI.this.currSongDisplay + 1) % SimplePlayerGUI.this.songDisplayNames.length;
                    SimplePlayerGUI.this.updateSongDisplay();
                    SimplePlayerGUI.this.changeSongDisplayCounter = 40;
                    if (SimplePlayerGUI.this.currSongDisplay == 0) {
                        SimplePlayerGUI.this.changeSongDisplayCounter *= 2;
                    }
                }
            }
        }
    }

    private class RecordTask
    implements Utils.QueryListener {
        private RecordTask() {
        }

        public void start(String location) {
            SimplePlayerGUI.this.startRecording(location);
        }

        public void queryOK(String text) {
            this.start(text);
        }

        public void queryCancelled() {
        }
    }
}

