/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimplePlayerGUI;
import example.SoccerQ.Utils;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.GUIControl;
import javax.microedition.media.control.VideoControl;

public class SimplePlayerForm
extends Form
implements SimplePlayerGUI.Parent,
Utils.ContentHandler,
Utils.Interruptable,
Runnable {
    private SimplePlayerGUI gui;
    private Utils.BreadCrumbTrail parent;
    private static Image spacerImage;
    private ImageItem iiLogo;
    private StringItem siFileTitle;
    private StringItem siTime;
    private StringItem siRate;
    private StringItem siKaraoke;
    private StringItem siFeedback;
    private StringItem siStatus;
    private boolean karaokeShowing;
    private static int maxKaraokeLines;

    private static void debugOut(String s) {
        Utils.debugOut("SimplePlayerForm: " + s);
    }

    public SimplePlayerForm(String title, Utils.BreadCrumbTrail parent) {
        this(title, null, parent);
    }

    public SimplePlayerForm(String title, SimplePlayerGUI spg, Utils.BreadCrumbTrail parent) {
        super(title);
        this.parent = parent;
        this.gui = spg;
        this.siFileTitle = new StringItem("", "");
        this.siTime = new StringItem("", "");
        this.siRate = new StringItem("", "");
        this.siKaraoke = new StringItem("", "");
        this.siFeedback = new StringItem("", "");
        this.siStatus = new StringItem("", "");
        SimplePlayerForm.debugOut("constructor finished");
    }

    private void appendNewLine(Item item) {
        this.insertNewLine(this.size(), item);
    }

    private void insertNewLine(int pos, Item item) {
        this.insert(pos, (Item)((StringItem)item));
        Spacer spacer = new Spacer(3, 10);
        spacer.setLayout(256);
        if (pos < 8) {
            this.insert(pos++, (Item)spacer);
        }
    }

    private void setUpItems() {
        Control[] controls;
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
        this.karaokeShowing = false;
        this.getGUI();
        if (!this.gui.hasGUIControls()) {
            this.makeImageItem();
        }
        this.appendNewLine((Item)this.siFileTitle);
        this.appendNewLine((Item)this.siTime);
        if (this.gui.hasRateControl() || this.gui.hasTempoControl()) {
            this.appendNewLine((Item)this.siRate);
        }
        if (this.gui.hasGUIControls() && (controls = this.gui.getControls()) != null) {
            for (int i = 0; i < controls.length; ++i) {
                Object guiItem;
                Control ctrl = controls[i];
                if (!(ctrl instanceof GUIControl) || !((guiItem = ((GUIControl)ctrl).initDisplayMode(0, null)) instanceof Item)) continue;
                this.append((Item)guiItem);
                if (!(ctrl instanceof VideoControl)) continue;
                try {
                    ((VideoControl)ctrl).setDisplayFullScreen(false);
                    continue;
                }
                catch (MediaException me) {
                    Utils.debugOut(me);
                }
            }
        }
        this.appendNewLine((Item)this.siFeedback);
        this.appendNewLine((Item)this.siStatus);
    }

    private void makeImageItem() {
        if (this.gui != null && !this.gui.isFullScreen()) {
            Image logo;
            if (this.iiLogo == null && (logo = this.gui.getLogo()) != null) {
                this.iiLogo = new ImageItem("", logo, 771, "MMAPI logo");
            }
            if (this.iiLogo != null) {
                this.insert(0, (Item)this.iiLogo);
            }
        }
    }

    public Displayable go(Displayable d) {
        return this.parent.go(d);
    }

    public Displayable goBack() {
        return this.parent.goBack();
    }

    public Displayable replaceCurrent(Displayable d) {
        return this.parent.replaceCurrent(d);
    }

    public Displayable getCurrentDisplayable() {
        return this.parent.getCurrentDisplayable();
    }

    public Utils.BreadCrumbTrail getParent() {
        return this.parent;
    }

    public void setupDisplay() {
        this.setUpItems();
    }

    public void setStatus(String s) {
        this.siStatus.setText(s);
    }

    public void setFeedback(String s) {
        this.siFeedback.setText(s);
    }

    public void setFileTitle(String s) {
        this.siFileTitle.setText(s);
    }

    public void updateKaraoke() {
        int[] karaokeParams = new int[4];
        String[] lines = this.gui.getKaraokeStr(karaokeParams);
        int currLine = karaokeParams[1];
        int lineCount = karaokeParams[0];
        int syllLen = karaokeParams[3];
        int currLinePos = karaokeParams[2];
        int thisLine = 0;
        if (lineCount > maxKaraokeLines) {
            thisLine = currLine - 1;
            if (thisLine < 0) {
                thisLine = 0;
            }
            if (thisLine + maxKaraokeLines > lineCount) {
                thisLine = lineCount - maxKaraokeLines;
            } else if (lineCount - thisLine > maxKaraokeLines) {
                lineCount = thisLine + maxKaraokeLines;
            }
        }
        String text = "";
        while (thisLine < lineCount) {
            text = text + lines[thisLine] + "\n";
            ++thisLine;
        }
        this.siKaraoke.setText(text);
        if (!this.karaokeShowing && !this.gui.isFullScreen()) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != this.siFeedback) continue;
                if (i > 0 && this.get(i - 1) instanceof ImageItem) {
                    --i;
                }
                this.insertNewLine(i, (Item)this.siKaraoke);
                break;
            }
            this.karaokeShowing = true;
        }
    }

    public void updateTime() {
        if (this.gui != null) {
            this.siTime.setText(this.gui.getMediaTimeStr());
        }
    }

    public void updateRate() {
        if (this.getGUI().hasTempoControl()) {
            this.siRate.setText(this.gui.getTempoStr());
        } else {
            this.siRate.setText(this.gui.getRateStr());
        }
    }

    public void updateDisplay() {
    }

    public void fullScreen(boolean value) {
    }

    public synchronized void close() {
        if (this.gui != null) {
            this.gui.closePlayer();
            this.gui = null;
        }
    }

    public boolean canHandle(String url) {
        return true;
    }

    public void handle(String name, String url) {
        Utils.debugOut("SimplePlayerForm: handle " + url);
        this.getGUI().setParent(this);
        this.gui.setSong(name, url);
        this.doHandle();
    }

    public void handle(String name, InputStream is, String contentType) {
        this.getGUI().setParent(this);
        this.gui.setSong(name, is, contentType);
        this.doHandle();
    }

    private synchronized SimplePlayerGUI getGUI() {
        if (this.gui == null) {
            SimplePlayerForm.debugOut("create GUI");
            this.gui = new SimplePlayerGUI();
            this.gui.initialize(this.getTitle(), this);
            this.gui.setTimerInterval(500);
            this.makeImageItem();
        }
        return this.gui;
    }

    private void doHandle() {
        SimplePlayerForm.debugOut("doHandle");
        this.setUpItems();
        new Thread(this).start();
    }

    public void run() {
        this.gui.startPlayer();
    }

    public synchronized void pauseApp() {
        if (this.gui != null) {
            this.gui.pauseApp();
        }
    }

    public synchronized void resumeApp() {
        if (this.gui != null) {
            this.gui.resumeApp();
        }
    }

    public String toString() {
        return "SimplePlayerForm";
    }

    static {
        maxKaraokeLines = 2;
    }
}

