/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimplePlayerGUI;
import example.SoccerQ.Utils;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class SimplePlayerCanvas
extends Canvas
implements SimplePlayerGUI.Parent,
Utils.Interruptable,
Utils.ContentHandler,
Runnable {
    private static int PLAYER_TITLE_TOP = 2;
    private static int LOGO_GAP = 2;
    private static int SONG_TITLE_GAP = 2;
    private static int KARAOKE_GAP = 1;
    private static int TIME_GAP = 2;
    private static int RATE_GAP = 2;
    private static int STATUS_GAP = 2;
    private String title;
    private Image logo = null;
    private SimplePlayerGUI gui;
    private Utils.BreadCrumbTrail parent;
    private VideoControl videoControl;
    private String status = "";
    private String feedback = "";
    private String fileTitle = "";
    int displayWidth = -1;
    int displayHeight = -1;
    int textHeight = 10;
    int logoTop = 0;
    int songTitleTop = 0;
    int timeRateTop = 0;
    int timeWidth = 0;
    int karaokeTop = 0;
    int karaokeHeight = 0;
    int maxKaraokeLines = 0;
    int feedbackTop = 0;
    int statusTop = 0;
    int[] karaokeParams = new int[4];

    private static void debugOut(String s) {
        Utils.debugOut("SimplePlayerCanvas: " + s);
    }

    public SimplePlayerCanvas(String title, Utils.BreadCrumbTrail parent) {
        this.parent = parent;
        this.title = title;
    }

    public Displayable go(Displayable d) {
        return this.parent.go(d);
    }

    public Displayable goBack() {
        return this.parent.goBack();
    }

    public Displayable replaceCurrent(Displayable d) {
        return this.parent.replaceCurrent(d);
    }

    public Displayable getCurrentDisplayable() {
        return this.parent.getCurrentDisplayable();
    }

    public Utils.BreadCrumbTrail getParent() {
        return this.parent;
    }

    public void setupDisplay() {
        this.videoControl = this.gui.getVideoControl();
        if (this.videoControl != null) {
            Utils.debugOut("Initializing display mode.");
            try {
                this.videoControl.initDisplayMode(1, (Object)this);
            }
            catch (Exception e) {
                this.setFeedback(Utils.friendlyException(e));
                this.videoControl = null;
            }
        }
        this.displayHeight = -1;
        this.updateDisplay();
    }

    public String getTitle() {
        return this.title;
    }

    public void setStatus(String s) {
        this.status = s;
        this.repaint(0, this.statusTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void setFeedback(String s) {
        this.feedback = s;
        this.repaint(0, this.feedbackTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void setFileTitle(String s) {
        this.fileTitle = s;
        this.repaint(0, this.songTitleTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void updateKaraoke() {
        this.repaint(0, this.karaokeTop, this.displayWidth, this.karaokeHeight);
        this.serviceRepaints();
    }

    public void updateTime() {
        this.repaint(0, this.timeRateTop, this.timeWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void updateRate() {
        this.repaint(this.timeWidth, this.timeRateTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void updateDisplay() {
        this.repaint();
        this.serviceRepaints();
    }

    public void fullScreen(boolean value) {
        this.repaint();
    }

    public synchronized void close() {
        if (this.gui != null) {
            this.gui.closePlayer();
            this.gui = null;
        }
    }

    public boolean canHandle(String url) {
        return true;
    }

    public void handle(String name, String url) {
        Utils.debugOut("SimplePlayerCanvas: handle " + url);
        this.getGUI().setParent(this);
        this.gui.setSong(name, url);
        this.doHandle();
    }

    public void handle(String name, InputStream is, String contentType) {
        this.getGUI().setParent(this);
        this.gui.setSong(name, is, contentType);
        this.doHandle();
    }

    public void handle(String name, Player player) {
        this.getGUI().setParent(this);
        this.gui.setSong(name, player);
        this.doHandle();
    }

    private synchronized SimplePlayerGUI getGUI() {
        if (this.gui == null) {
            this.gui = new SimplePlayerGUI();
            this.gui.initialize(this.title, this);
        }
        return this.gui;
    }

    private void doHandle() {
        this.repaint();
        this.serviceRepaints();
        new Thread(this).start();
    }

    public void run() {
        this.gui.startPlayer();
    }

    protected void keyPressed(int keycode) {
        try {
            SimplePlayerGUI gui = this.getGUI();
            switch (keycode) {
                case 49: {
                    gui.skip(true);
                    break;
                }
                case 50: {
                    gui.togglePlayer();
                    break;
                }
                case 51: {
                    gui.skip(false);
                    break;
                }
                case 55: {
                    gui.stepFrame(-1);
                    break;
                }
                case 57: {
                    gui.stepFrame(1);
                    break;
                }
                case 53: {
                    gui.pausePlayer();
                    gui.setMediaTime(0L);
                    this.setFeedback("Player Stopped.");
                    break;
                }
                case 52: {
                    gui.changeRate(true);
                    break;
                }
                case 56: {
                    gui.toggleFullScreen();
                    break;
                }
                case 54: {
                    gui.changeRate(false);
                    break;
                }
                case 48: {
                    gui.toggleMute();
                    break;
                }
                case 42: {
                    gui.changeVolume(true);
                    break;
                }
                case 35: {
                    gui.changeVolume(false);
                    break;
                }
                default: {
                    int code = this.getGameAction(keycode);
                    if (code == 5) {
                        gui.skip(false);
                        break;
                    }
                    if (code == 2) {
                        gui.skip(true);
                        break;
                    }
                    if (code == 1) {
                        gui.transpose(false);
                        break;
                    }
                    if (code == 6) {
                        gui.transpose(true);
                        break;
                    }
                    if (code == 8) {
                        gui.togglePlayer();
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            Utils.error(t, this.parent);
        }
    }

    private boolean intersects(int clipY, int clipHeight, int y, int h) {
        return clipY <= y + h && clipY + clipHeight >= y;
    }

    public void paint(Graphics g) {
        try {
            if (this.displayHeight == -1) {
                this.displayWidth = this.getWidth();
                this.displayHeight = this.getHeight();
                this.textHeight = g.getFont().getHeight();
                if (this.gui != null && this.videoControl == null) {
                    if (this.logo == null) {
                        this.logo = this.gui.getLogo();
                    }
                } else {
                    this.logo = null;
                }
                int currTop = PLAYER_TITLE_TOP + this.textHeight;
                if (this.logo != null) {
                    this.logoTop = currTop += LOGO_GAP;
                    currTop += this.logo.getHeight();
                }
                this.songTitleTop = currTop += SONG_TITLE_GAP;
                this.timeRateTop = currTop += TIME_GAP + this.textHeight;
                this.timeWidth = g.getFont().stringWidth("0:00:0  ");
                this.feedbackTop = this.displayHeight - 2 * this.textHeight - STATUS_GAP;
                this.maxKaraokeLines = (this.feedbackTop - (currTop += this.textHeight + KARAOKE_GAP)) / (this.textHeight + KARAOKE_GAP);
                this.karaokeHeight = this.maxKaraokeLines * (this.textHeight + KARAOKE_GAP);
                this.karaokeTop = currTop + (this.feedbackTop - currTop - this.karaokeHeight) / 2;
                if (this.videoControl != null) {
                    int videoTop = this.timeRateTop + this.textHeight;
                    int dispWidth = this.videoControl.getSourceWidth();
                    int dispHeight = this.videoControl.getSourceHeight();
                    if (dispWidth > this.displayWidth) {
                        dispWidth = this.displayWidth;
                    }
                    if (dispHeight > this.feedbackTop - videoTop) {
                        dispHeight = this.feedbackTop - videoTop;
                    }
                    this.videoControl.setDisplayLocation((this.displayWidth - dispWidth) / 2, videoTop);
                    this.videoControl.setDisplaySize(dispWidth, dispHeight);
                    this.videoControl.setVisible(true);
                    Utils.debugOut("Setting video to visible at (0, " + videoTop + ") with size (" + this.displayWidth + ", " + (this.feedbackTop - videoTop) + ")");
                }
                this.statusTop = this.displayHeight - this.textHeight;
            }
            if (this.videoControl == null || !this.gui.isFullScreen()) {
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipWidth = g.getClipWidth();
                int clipHeight = g.getClipHeight();
                g.setColor(0);
                g.fillRect(clipX, clipY, clipWidth, clipHeight);
                if (this.intersects(clipY, clipHeight, PLAYER_TITLE_TOP, this.textHeight)) {
                    g.setColor(0xFF7F00);
                    g.drawString(this.title, this.displayWidth >> 1, PLAYER_TITLE_TOP, 17);
                }
                if (this.logo != null && this.intersects(clipY, clipHeight, this.logoTop, this.logo.getHeight())) {
                    g.drawImage(this.logo, this.displayWidth / 2, this.logoTop, 17);
                }
                if (this.intersects(clipY, clipHeight, this.songTitleTop, this.textHeight)) {
                    g.setColor(0xFF7F00);
                    g.drawString(this.fileTitle, this.displayWidth >> 1, this.songTitleTop, 17);
                }
                if (this.gui != null) {
                    if (this.intersects(clipY, clipHeight, this.timeRateTop, this.textHeight)) {
                        if (this.intersects(clipX, clipWidth, 0, this.timeWidth)) {
                            g.setColor(0xF0F0F0);
                            g.drawString(this.gui.getMediaTimeStr(), 0, this.timeRateTop, 20);
                        }
                        if (this.intersects(clipX, clipWidth, this.timeWidth + 1, this.displayWidth)) {
                            if (this.gui.hasTempoControl()) {
                                g.setColor(0xF0F0F0);
                                g.drawString(this.gui.getTempoStr(), this.displayWidth, this.timeRateTop, 24);
                            } else {
                                g.setColor(0xF0F0F0);
                                g.drawString(this.gui.getRateStr(), this.displayWidth, this.timeRateTop, 24);
                            }
                        }
                    }
                    if (this.intersects(clipY, clipHeight, this.karaokeTop, this.karaokeHeight)) {
                        String[] lines = this.gui.getKaraokeStr(this.karaokeParams);
                        int currTop = this.karaokeTop;
                        int currLine = this.karaokeParams[1];
                        int lineCount = this.karaokeParams[0];
                        int thisLine = 0;
                        if (lineCount > this.maxKaraokeLines) {
                            thisLine = currLine - 1;
                            if (thisLine < 0) {
                                thisLine = 0;
                            }
                            if (thisLine + this.maxKaraokeLines > lineCount) {
                                thisLine = lineCount - this.maxKaraokeLines;
                            } else if (lineCount - thisLine > this.maxKaraokeLines) {
                                lineCount = thisLine + this.maxKaraokeLines;
                            }
                        }
                        int syllLen = this.karaokeParams[3];
                        int currLinePos = this.karaokeParams[2];
                        while (thisLine < lineCount) {
                            if (currLine != thisLine || syllLen == 0) {
                                if (thisLine < currLine) {
                                    g.setColor(0xFFFF30);
                                } else {
                                    g.setColor(0x909090);
                                }
                                g.drawString(lines[thisLine], 0, currTop, 20);
                            } else {
                                String currText;
                                int xPos = 0;
                                if (currLinePos > 0) {
                                    currText = lines[thisLine].substring(0, currLinePos);
                                    g.setColor(0xFFFF30);
                                    g.drawString(currText, 0, currTop, 20);
                                    xPos += g.getFont().stringWidth(currText);
                                }
                                g.setColor(0xFFFF30);
                                currText = lines[thisLine].substring(currLinePos, currLinePos + syllLen);
                                g.drawString(currText, xPos, currTop, 20);
                                if (currLinePos + syllLen < lines[thisLine].length()) {
                                    xPos += g.getFont().stringWidth(currText);
                                    currText = lines[thisLine].substring(currLinePos + syllLen);
                                    g.setColor(0x909090);
                                    g.drawString(currText, xPos, currTop, 20);
                                }
                            }
                            currTop += this.textHeight + KARAOKE_GAP;
                            ++thisLine;
                        }
                    }
                }
                if (this.intersects(clipY, clipHeight, this.feedbackTop, this.textHeight)) {
                    g.setColor(0xE0E0FF);
                    g.drawString(this.feedback, 0, this.feedbackTop, 20);
                }
                if (this.intersects(clipY, clipHeight, this.displayHeight - this.textHeight, this.textHeight)) {
                    g.setColor(0xFAFAFA);
                    g.drawString(this.status, 0, this.displayHeight, 36);
                }
            }
        }
        catch (Throwable t) {
            SimplePlayerCanvas.debugOut("in paint(): " + Utils.friendlyException(t));
        }
    }

    public void showHelp() {
        List list = new List("Simple Player Help", 3);
        list.append("1: Skip back", null);
        list.append("2: Start/Stop", null);
        list.append("3: Skip forward", null);
        list.append("4: Slower", null);
        list.append("5: Stop (and rewind)", null);
        list.append("6: Faster", null);
        list.append("7: Prev. video frame", null);
        list.append("8: Fullscreen on/off", null);
        list.append("9: Next video frame", null);
        list.append("*: quieter", null);
        list.append("0: Mute on/off", null);
        list.append("#: louder", null);
        list.append("Left: skip back", null);
        list.append("Right: skip forward", null);
        list.append("Up: Pitch up", null);
        list.append("Down: Pitch down", null);
        list.append("Fire: Start/Stop", null);
        list.addCommand(this.gui.backCommand);
        list.setCommandListener((CommandListener)this.gui);
        this.go((Displayable)list);
    }

    public synchronized void pauseApp() {
        if (this.gui != null) {
            this.gui.pauseApp();
        }
    }

    public synchronized void resumeApp() {
        if (this.gui != null) {
            this.gui.resumeApp();
        }
    }

    public String toString() {
        return "SimplePlayerCanvas";
    }
}

