/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.BaseListMidlet;
import example.SoccerQ.RingToneConverter;
import example.SoccerQ.SimpleHttpBrowser;
import example.SoccerQ.SimplePlayerCanvas;
import example.SoccerQ.SimpleRmsBrowser;
import example.SoccerQ.Utils;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class SimplePlayer
extends BaseListMidlet
implements Utils.BreadCrumbTrail,
Utils.QueryListener {
    private static final String manualEnterURL = "manual";
    private static final String manualEnterTitle = "[enter URL]";
    private String lastManualURL = "";
    private Vector titles;
    private Vector urls;
    private static final String httpSupportedList = SimplePlayer.getSupportedList("http");
    private static final String allSupportedList = SimplePlayer.getSupportedList(null);
    private SimplePlayerCanvas simplePlayerCanvas = new SimplePlayerCanvas("MMAPI Player", this);
    private Utils.ContentHandler[] handlers = new Utils.ContentHandler[]{new SimpleHttpBrowser("MMAPI HTTP Browser", this), new SimpleRmsBrowser("MMAPI RMS Browser", this), this.simplePlayerCanvas};

    private static String getSupportedList(String protocol) {
        String[] list = Manager.getSupportedContentTypes((String)protocol);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            buffer.append(list[i]).append(",");
        }
        if (list.length > 0) {
            return buffer.toString();
        }
        return "";
    }

    public SimplePlayer() {
        super("MMAPI Player");
    }

    protected static final boolean isSupported(String url) {
        if (!url.startsWith("capture:")) {
            String contentType;
            try {
                contentType = Utils.guessContentType(url);
            }
            catch (Exception e) {
                contentType = "";
            }
            if (contentType.equals("")) {
                return false;
            }
            if (url.startsWith("resource:") ? allSupportedList.indexOf(contentType + ",") == -1 : url.startsWith("http:") && httpSupportedList.indexOf(contentType + ",") == -1) {
                return false;
            }
        }
        return true;
    }

    protected void fillList(List list) {
        String nthURL;
        String url;
        this.titles = new Vector();
        this.urls = new Vector();
        for (int n = 1; n < 100 && (url = this.getAppProperty(nthURL = "PlayerURL-" + n)) != null && url.length() != 0; ++n) {
            if (!SimplePlayer.isSupported(url)) continue;
            String nthTitle = "PlayerTitle-" + n;
            String title = this.getAppProperty(nthTitle);
            if (title == null || title.length() == 0) {
                title = url;
            }
            this.titles.addElement(title);
            this.urls.addElement(url);
            list.append(title, null);
        }
        this.titles.addElement(manualEnterTitle);
        this.urls.addElement(manualEnterURL);
        list.append(manualEnterTitle, null);
        list.addCommand(this.exitCommand);
        list.addCommand(this.selectCommand);
    }

    public void handle(String title, String url) {
        try {
            InputStream is = null;
            String ct = "";
            if (url.equals(manualEnterURL)) {
                this.enterURL();
                return;
            }
            if (url.startsWith("resource:")) {
                is = this.getClass().getResourceAsStream(url.substring(9));
            } else if (SimpleRmsBrowser.isRmsFile(url)) {
                is = SimpleRmsBrowser.getRecordStoreStream(url);
            }
            if (Utils.guessContentType(url).equals("audio/x-txt")) {
                RingToneConverter rtc = is != null ? new RingToneConverter(is, title) : new RingToneConverter(url, title);
                Player tonePlayer = Manager.createPlayer((String)"device://tone");
                tonePlayer.realize();
                ToneControl tc = (ToneControl)tonePlayer.getControl("ToneControl");
                tc.setSequence(rtc.getSequence());
                this.go((Displayable)this.simplePlayerCanvas);
                this.simplePlayerCanvas.handle(rtc.getName(), tonePlayer);
                return;
            }
            if (is != null) {
                if (ct == "") {
                    ct = Utils.guessContentType(url);
                }
                this.go((Displayable)this.simplePlayerCanvas);
                this.simplePlayerCanvas.handle(title, is, ct);
                return;
            }
            for (int i = 0; i < this.handlers.length; ++i) {
                if (!this.handlers[i].canHandle(url)) continue;
                this.go((Displayable)this.handlers[i]);
                this.handlers[i].handle(title, url);
                return;
            }
            Utils.error("No handler available!", (Utils.BreadCrumbTrail)this);
        }
        catch (Exception e) {
            Utils.error(e, (Utils.BreadCrumbTrail)this);
        }
    }

    protected void selectCommand(int index) {
        if (index >= 0 && index < this.titles.size()) {
            this.handle((String)this.titles.elementAt(index), (String)this.urls.elementAt(index));
        }
    }

    private void enterURL() {
        Utils.query("Enter a URL", this.lastManualURL, 300, 4, this, this);
    }

    public void queryOK(String text) {
        this.handle(text, text);
        this.lastManualURL = text;
    }

    public void queryCancelled() {
    }

    public void destroyApp(boolean unconditional) {
        Utils.ContentHandler p = this.getCurrentHandler();
        if (p != null) {
            p.close();
        }
        super.destroyApp(unconditional);
    }

    private Utils.ContentHandler getCurrentHandler() {
        Displayable d = this.getDisplay().getCurrent();
        if (d instanceof Utils.ContentHandler) {
            return (Utils.ContentHandler)d;
        }
        return null;
    }

    public String toString() {
        return "SimplePlayer";
    }
}

