/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimpleRmsBrowser;
import example.SoccerQ.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStoreException;

public class SimpleHttpBrowser
extends List
implements CommandListener,
Utils.ContentHandler,
Utils.QueryListener {
    private static final boolean MASS_TEST = false;
    private Command exitCommand = new Command("Exit Browser", 7, 1);
    private Command backCommand = new Command("Back", 2, 1);
    private Command openCommand = new Command("Open", 8, 1);
    private Command selectCommand = new Command("Select", 8, 1);
    private Command saveCommand = new Command("Save in RMS", 8, 1);
    private Command menuCommand = new Command("Menu", 8, 1);
    private Command refreshCommand = new Command("Refresh", 8, 1);
    private Command[] allCommands = new Command[]{this.exitCommand, this.backCommand, this.openCommand, this.selectCommand, this.saveCommand, this.menuCommand, this.refreshCommand};
    private Vector names = new Vector();
    private Vector urls = new Vector();
    private Stack history = new Stack();
    private Stack historyIndex = new Stack();
    private String currURL = null;
    private String queryDefault;
    private String queryInputURL;
    private Utils.BreadCrumbTrail parent;
    private List menuList;

    public SimpleHttpBrowser(String title, Utils.BreadCrumbTrail parent) {
        super(title, 3);
        this.parent = parent;
    }

    public void displayHTML(String url, int selectedIndex) {
        boolean error = false;
        this.currURL = url;
        this.clearLists();
        try {
            this.readHTML(url);
        }
        catch (Exception e) {
            this.append("[" + Utils.friendlyException(e) + "]", null);
            error = true;
        }
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        if (!error) {
            for (int i = 0; i < this.names.size(); ++i) {
                this.append((String)this.names.elementAt(i), null);
            }
            this.setListIndex(selectedIndex);
            this.addCommand(this.menuCommand);
        } else {
            this.addCommand(this.refreshCommand);
        }
    }

    private void exit() {
        this.currURL = null;
        this.clearLists();
        this.parent.goBack();
    }

    private static void internalError(Throwable t, String desc) {
        if (Utils.DEBUG && desc != "") {
            System.out.println(desc);
        }
        if (Utils.DEBUG) {
            t.printStackTrace();
        }
    }

    private void clearLists() {
        this.names.setSize(0);
        this.urls.setSize(0);
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
        this.removeCommand(this.refreshCommand);
        this.removeCommand(this.menuCommand);
        System.gc();
    }

    public void close() {
        this.clearLists();
        this.history.setSize(0);
        this.historyIndex.setSize(0);
    }

    public boolean canHandle(String url) {
        return SimpleHttpBrowser.isHTML(url);
    }

    public void handle(String name, String url) {
        Utils.debugOut("SimpleHttpBrowser: handle " + url);
        this.displayHTML(url, 0);
    }

    public void commandAction(Command c, Displayable s) {
        try {
            if (s == this.menuList && this.menuList != null && this.menuList.isShown()) {
                int selIndex = this.menuList.getSelectedIndex();
                this.parent.goBack();
                if (c == this.backCommand) {
                    return;
                }
                if (c == List.SELECT_COMMAND || c == this.selectCommand) {
                    c = this.menuItem2Command(selIndex);
                }
            }
            if (c == List.SELECT_COMMAND && this.isShown() || c == this.openCommand) {
                this.gotoURL(this.getSelectedIndex());
            } else if (c == this.saveCommand) {
                this.saveToRms((String)this.urls.elementAt(this.getSelectedIndex()));
            } else if (c == this.backCommand) {
                this.goBack();
            } else if (c == this.refreshCommand) {
                this.refresh();
            } else if (c == this.menuCommand) {
                this.showMenu(this.getSelectedIndex());
            } else if (c == this.exitCommand) {
                this.exit();
            }
        }
        catch (Throwable t) {
            SimpleHttpBrowser.internalError(t, "in commandAction");
        }
    }

    private Command menuItem2Command(int index) {
        if (index < 0 || index >= this.menuList.size()) {
            return null;
        }
        String menuStr = this.menuList.getString(index);
        for (int i = 0; i < this.allCommands.length; ++i) {
            if (!this.allCommands[i].getLabel().equals(menuStr)) continue;
            return this.allCommands[i];
        }
        return null;
    }

    private void showMenu(int index) {
        String url = (String)this.urls.elementAt(index);
        boolean html = SimpleHttpBrowser.isHTML(url);
        this.menuList = new List("Menu", 3);
        this.menuList.setCommandListener((CommandListener)this);
        this.menuList.append(this.openCommand.getLabel(), null);
        this.menuList.append(this.refreshCommand.getLabel(), null);
        if (!html) {
            this.menuList.append(this.saveCommand.getLabel(), null);
        }
        this.menuList.append(this.exitCommand.getLabel(), null);
        this.menuList.addCommand(this.backCommand);
        this.menuList.addCommand(this.selectCommand);
        this.parent.go((Displayable)this.menuList);
    }

    private void gotoURL(int index) {
        String url = (String)this.urls.elementAt(index);
        this.gotoURL(url, index);
    }

    private void gotoURL(String url, int index) {
        try {
            if (index >= this.names.size() || SimpleHttpBrowser.isHTML(url)) {
                if (this.currURL != null) {
                    this.history.push(this.currURL);
                    this.historyIndex.push(new Integer(index));
                }
                this.displayHTML(url, 0);
            } else {
                this.parent.handle((String)this.names.elementAt(index), url);
            }
        }
        catch (Exception e) {
            Utils.error(e, this.parent);
        }
        if (Utils.DEBUG) {
            Utils.debugOut("SimpleHttpBrowser: after gotoURL. History contains " + this.history.size() + " entries.");
            for (int i = this.history.size() - 1; i >= 0; --i) {
                Utils.debugOut("     " + i + ": " + (String)this.history.elementAt(i));
            }
        }
    }

    private void goBack() {
        if (Utils.DEBUG) {
            Utils.debugOut("SimpleHttpBrowser: before goBack. History contains " + this.history.size() + " entries.");
            for (int i = this.history.size() - 1; i >= 0; --i) {
                Utils.debugOut("     " + i + ": " + (String)this.history.elementAt(i) + "  #" + (Integer)this.historyIndex.elementAt(i));
            }
        }
        if (!this.history.empty()) {
            String url = (String)this.history.pop();
            int index = (Integer)this.historyIndex.pop();
            this.displayHTML(url, index);
        } else {
            this.exit();
        }
    }

    private void refresh() {
        int selIndex = this.getSelectedIndex();
        Utils.debugOut("SimpleHttpBrowser.Refresh: index " + selIndex);
        this.displayHTML(this.currURL, selIndex);
    }

    private void setListIndex(int index) {
        if (index >= 0 && index < this.size()) {
            this.setSelectedIndex(index, true);
        }
    }

    public void queryOK(String text) {
        try {
            boolean queryAgain = true;
            if (text != null) {
                if (text.indexOf("/") >= 0 || text.indexOf(":") >= 0) {
                    Utils.error("record store name cannot contain / or :", this.parent);
                } else if (text.length() > 32) {
                    Utils.error("record store name cannot exceed 32 characters", this.parent);
                } else if (text.length() == 0) {
                    Utils.error("record store name empty. please try again", this.parent);
                } else {
                    queryAgain = false;
                }
            }
            if (queryAgain) {
                Utils.query("Enter record store name:", this.queryDefault, 32, this, this.parent);
            } else {
                int id = SimpleHttpBrowser.saveToRms(this.queryInputURL, "rms:/" + text);
                Utils.FYI("The file was saved successfully in RMS. The record ID is " + id + ".", this.parent);
            }
        }
        catch (Throwable t) {
            Utils.error(t, this.parent);
        }
    }

    public void queryCancelled() {
    }

    private void saveToRms(String inputURL) {
        try {
            String[] splitInputURL = Utils.splitURL(inputURL);
            this.queryDefault = "";
            for (int i = 4; i > 0; --i) {
                this.queryDefault = splitInputURL[i];
                if (this.queryDefault != "") break;
            }
            this.queryInputURL = inputURL;
            this.queryOK(null);
        }
        catch (Throwable t) {
            Utils.error(t, this.parent);
        }
    }

    private static int saveToRms(String inputURL, String outputURL) throws IOException, RecordStoreException, Exception {
        InputStream is = Connector.openInputStream((String)inputURL);
        return SimpleRmsBrowser.saveToRecordStore(is, outputURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHTML(String source) throws Exception {
        InputStream in = Connector.openInputStream((String)source);
        try {
            String url;
            String[] base = Utils.splitURL(source);
            Utils.debugOut("readHTML: source=" + Utils.mergeURL(base));
            while ((url = this.readHref(in)) != null) {
                String[] splitU = this.joinURLs(base, url);
                url = Utils.mergeURL(splitU);
                if (splitU[4].indexOf(63) == 0) continue;
                String name = this.readHrefName(in);
                this.names.addElement(name);
                this.urls.addElement(url);
            }
            if (this.names.size() == 0) {
                throw new Exception("No links found in " + source);
            }
        }
        finally {
            in.close();
        }
    }

    private static boolean isHTML(String url) {
        try {
            String[] sURL = Utils.splitURL(url);
            return sURL[0].equals("http") && (sURL[4] == "" || sURL[4].indexOf(".html") == sURL[4].length() - 5 || sURL[4].indexOf(".htm") == sURL[4].length() - 4);
        }
        catch (Exception e) {
            SimpleHttpBrowser.internalError(e, "isHTML()");
            return false;
        }
    }

    private String[] joinURLs(String[] url, String relPath) throws Exception {
        String[] rel = Utils.splitURL(relPath);
        String[] result = new String[6];
        result[0] = rel[0] == "" ? url[0] : rel[0];
        result[1] = rel[1] == "" ? url[1] : rel[1];
        String string = result[2] = rel[2] == "" ? url[2] : rel[2];
        result[3] = rel[3].length() > 0 ? (rel[3].charAt(0) == '/' ? rel[3] : url[3] + '/' + rel[3]) : url[3];
        result[4] = rel[4] == "" ? url[4] : rel[4];
        result[5] = rel[5] == "" ? url[5] : rel[5];
        return result;
    }

    private boolean charEquals(char char1, char char2, boolean caseSensitive) {
        boolean equal;
        boolean bl = equal = char1 == char2;
        if (!equal && !caseSensitive && (char1 >= 'A' && char1 <= 'Z' || char1 >= 'A' && char1 <= 'Z')) {
            equal = (char1 ^ 0x20) == char2;
        }
        return equal;
    }

    private boolean skip(InputStream is, String until, boolean onlyWhiteSpace, boolean caseSensitive) throws Exception {
        int len = until.length();
        int found = 0;
        int v = is.read();
        while (v > 0) {
            if (v == 0) {
                throw new Exception("no html file");
            }
            boolean equal = this.charEquals((char)v, until.charAt(found), caseSensitive);
            if (!equal) {
                if (onlyWhiteSpace && v > 32) {
                    throw new Exception("incorrect data format");
                }
                if (found > 0) {
                    found = 0;
                    continue;
                }
            } else {
                ++found;
            }
            if (found == len) {
                return true;
            }
            v = is.read();
        }
        return false;
    }

    private int findDelimiter(InputStream is) throws Exception {
        int v;
        do {
            if ((v = is.read()) == -1) {
                return -1;
            }
            if (v != 0) continue;
            throw new Exception("no html file");
        } while (v <= 32);
        return v;
    }

    private String readString(InputStream is, char firstChar, String delim, boolean delimCaseSensitive) throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean lastWhiteSpace = false;
        if (firstChar != '\u0000') {
            sb.append(firstChar);
            lastWhiteSpace = firstChar <= ' ';
        }
        boolean inTag = false;
        int found = 0;
        int len = delim.length();
        int appendedInDelim = 0;
        while (true) {
            int v;
            if ((v = is.read()) == -1) {
                throw new Exception("unterminated string");
            }
            if (v <= 32) {
                if (lastWhiteSpace) continue;
                v = 32;
                lastWhiteSpace = true;
            } else {
                lastWhiteSpace = false;
                if (v == 60) {
                    inTag = true;
                }
            }
            boolean equal = this.charEquals((char)v, delim.charAt(found), delimCaseSensitive);
            if (!equal && found > 0) {
                found = 0;
                appendedInDelim = 0;
                equal = this.charEquals((char)v, delim.charAt(found), delimCaseSensitive);
            }
            if (equal && ++found == len) {
                if (appendedInDelim <= 0) break;
                sb.setLength(sb.length() - appendedInDelim);
                break;
            }
            if (!inTag) {
                sb.append((char)v);
                if (found <= 0) continue;
                ++appendedInDelim;
                continue;
            }
            if (v != 62) continue;
            inTag = false;
        }
        return sb.toString();
    }

    private String readHref(InputStream is) throws Exception {
        if (!this.skip(is, "<a", false, false)) {
            return null;
        }
        if (!this.skip(is, "href", false, false)) {
            return null;
        }
        if (!this.skip(is, "=", true, true)) {
            return null;
        }
        int delim = this.findDelimiter(is);
        char endDelim = (char)delim;
        char firstChar = '\u0000';
        if (delim != 34 && delim != 39) {
            endDelim = '>';
            firstChar = (char)delim;
        }
        String ret = this.readString(is, firstChar, "" + endDelim, true);
        if (firstChar == '\u0000' && !this.skip(is, ">", true, true)) {
            return null;
        }
        return ret;
    }

    private String readHrefName(InputStream is) throws Exception {
        String ret = this.readString(is, '\u0000', "</a>", false);
        return ret;
    }

    private void massTest() {
    }

    public String toString() {
        return "SimpleHttpBrowser";
    }
}

