/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;

public class RingToneConverter {
    private byte[] inputData;
    private int readPos;
    private Vector notes;
    private Vector lengths;
    private char lastSeparator;
    private int tempo = 80;
    private String name;
    private byte[] sequence;
    private static final String[] durationStrings = new String[]{"16", "32", "1", "2", "4", "8"};
    private static final int[] durationValues = new int[]{16, 32, 1, 2, 4, 8};
    private static final String[] noteStrings = new String[]{"C#", "D#", "F#", "G#", "A#", "C", "D", "E", "F", "G", "A", "H", "B"};
    private static final int[] noteValues = new int[]{1, 3, 6, 8, 10, 0, 2, 4, 5, 7, 9, 11, 11};
    private static final String[] scaleStrings = new String[]{"4", "5", "6", "7", "8"};
    private static final int[] scaleValues = new int[]{4, 5, 6, 7, 8};

    public RingToneConverter(String url) throws IOException, Exception {
        this(url, RingToneConverter.URL2Name(url));
    }

    public RingToneConverter(String url, String name) throws IOException, Exception {
        this(Connector.openInputStream((String)url), name);
    }

    public RingToneConverter(InputStream is, String name) throws IOException, Exception {
        this(RingToneConverter.readInputStream(is), name);
    }

    public RingToneConverter(byte[] data, String name) throws Exception {
        this.inputData = data;
        this.name = name;
        this.notes = new Vector();
        this.lengths = new Vector();
        boolean success = this.parseRTTTL();
        if (!success) {
            throw new Exception("Not a supported ringtone text file");
        }
        if (this.tempo < 20 || this.tempo > 508) {
            throw new Exception("tempo is out of range");
        }
        this.inputData = null;
        System.gc();
        this.sequence = new byte[this.notes.size() * 2 + 4];
        this.sequence[0] = -2;
        this.sequence[1] = 1;
        this.sequence[2] = -3;
        this.sequence[3] = (byte)(this.tempo >> 2 & 0x7F);
        for (int i = 0; i < this.notes.size(); ++i) {
            this.sequence[2 * i + 4] = (byte)((Integer)this.notes.elementAt(i) & 0xFF);
            this.sequence[2 * i + 5] = (byte)((Integer)this.lengths.elementAt(i) & 0x7F);
        }
        this.notes = null;
        this.lengths = null;
        System.gc();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public void dumpSequence() {
        String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        for (int i = 0; i < this.sequence.length; ++i) {
            System.out.print(hexChars[(this.sequence[i] & 0xF0) >> 4] + hexChars[this.sequence[i] & 0xF] + " ");
            if (i % 8 != 7) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    private boolean parseRTTTL() {
        boolean result = true;
        try {
            this.tempo = 63;
            int defDuration = 4;
            int defScale = 6;
            String songName = this.readString(":", false, false);
            if (songName.length() > 0) {
                this.name = songName;
            }
            do {
                String def;
                if ((def = this.readString(",:", true, true)) != "") {
                    if (def.startsWith("D=")) {
                        defDuration = Integer.parseInt(def.substring(2));
                        continue;
                    }
                    if (def.startsWith("O=")) {
                        defScale = Integer.parseInt(def.substring(2));
                        continue;
                    }
                    if (def.startsWith("B=")) {
                        this.tempo = Integer.parseInt(def.substring(2));
                        continue;
                    }
                    throw new Exception("Unknown default \"" + def + "\"");
                }
                if (this.lastSeparator == ':') break;
                throw new Exception("':' excepted");
            } while (this.lastSeparator == ',');
            StringBuffer noteCommand = new StringBuffer();
            while (this.lastSeparator != 'E') {
                noteCommand.setLength(0);
                noteCommand.append(this.readString(",", true, true));
                if (noteCommand.length() == 0) break;
                int duration = RingToneConverter.tableLookup(noteCommand, durationStrings, durationValues, defDuration);
                int note = RingToneConverter.tableLookup(noteCommand, noteStrings, noteValues, -1);
                int dotCount = 0;
                if (noteCommand.length() > 0 && noteCommand.charAt(0) == '.') {
                    dotCount = 1;
                    noteCommand.deleteCharAt(0);
                }
                if (note >= 0) {
                    int scale = RingToneConverter.tableLookup(noteCommand, scaleStrings, scaleValues, defScale);
                    note = 60 + (scale - 4) * 12 + note;
                } else if (noteCommand.charAt(0) == 'P') {
                    note = -1;
                    noteCommand.deleteCharAt(0);
                } else {
                    throw new Exception("unexpected note command: '" + noteCommand.toString() + "'");
                }
                if (noteCommand.length() > 0 && noteCommand.charAt(0) == '.') {
                    dotCount = 1;
                    noteCommand.deleteCharAt(0);
                }
                if (noteCommand.length() > 0) {
                    throw new Exception("unexpected note command: '" + noteCommand.toString() + "'");
                }
                this.addNote(note, duration, dotCount);
            }
            Utils.debugOut("RingToneConverter: read " + this.notes.size() + " notes successfully.");
        }
        catch (Exception e) {
            Utils.debugOut(e);
            result = false;
        }
        return result;
    }

    private String readString(String separators, boolean stripWhiteSpace, boolean toUpperCase) {
        int start = this.readPos;
        this.lastSeparator = (char)69;
        boolean hasWhiteSpace = false;
        block0: while (this.lastSeparator == 'E' && this.readPos < this.inputData.length) {
            char input;
            if ((input = (char)this.inputData[this.readPos++]) <= ' ') {
                hasWhiteSpace = true;
            }
            for (int i = 0; i < separators.length(); ++i) {
                if (input != separators.charAt(i)) continue;
                this.lastSeparator = input;
                continue block0;
            }
        }
        int end = this.readPos - 1;
        if (this.lastSeparator != 'E') {
            --end;
        }
        String result = "";
        if (start <= end) {
            result = new String(this.inputData, start, end - start + 1);
            if (stripWhiteSpace && hasWhiteSpace) {
                StringBuffer sbResult = new StringBuffer(result);
                int i = 0;
                while (i < sbResult.length()) {
                    if (sbResult.charAt(i) <= ' ') {
                        sbResult.deleteCharAt(i);
                        continue;
                    }
                    ++i;
                }
                result = sbResult.toString();
            }
            if (toUpperCase) {
                result = result.toUpperCase();
            }
        }
        Utils.debugOut("Returning '" + result + "'  with lastSep='" + this.lastSeparator + "'");
        return result;
    }

    private static int tableLookup(StringBuffer command, String[] strings, int[] values, int defValue) {
        String sCmd = command.toString();
        int result = defValue;
        for (int i = 0; i < strings.length; ++i) {
            if (!sCmd.startsWith(strings[i])) continue;
            command.delete(0, strings[i].length());
            result = values[i];
            break;
        }
        return result;
    }

    private void addNote(int note, int duration, int dotCount) {
        int length = 64 / duration;
        int add = 0;
        int factor = 2;
        while (dotCount > 0) {
            add += length / factor;
            factor *= 2;
            --dotCount;
        }
        if ((length += add) > 127) {
            length = 127;
        }
        this.notes.addElement(new Integer(note));
        this.lengths.addElement(new Integer(length));
    }

    private static String URL2Name(String url) {
        int lastSlash = url.lastIndexOf(47);
        if (lastSlash == -1 || lastSlash == url.length() - 1) {
            lastSlash = url.lastIndexOf(58);
        }
        return url.substring(lastSlash + 1);
    }

    private static byte[] readInputStream(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        while ((read = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, read);
        }
        is.close();
        byte[] data = baos.toByteArray();
        buffer = null;
        baos = null;
        System.gc();
        return data;
    }
}

