/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.SimpleTones;
import example.SoccerQ.Utils;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.media.control.MIDIControl;

public class DrummerCanvas
extends Canvas
implements CommandListener {
    private static final String TITLE = "MMAPI Drummer";
    private static final String LOGO = "/icons/logo.png";
    private Command backCommand = new Command("Back", 2, 1);
    private Command helpCommand = new Command("Quick Help", 8, 10);
    private static int TITLE_TOP = 2;
    private static int LOGO_GAP = 2;
    private static int CURR_DRUM_GAP = 2;
    private static int STATUS_GAP = 2;
    private Image logo = null;
    private Utils.BreadCrumbTrail parent;
    private SimpleTones tones;
    private String status = "";
    private String currDrum = "";
    private int displayWidth = -1;
    private int displayHeight = -1;
    private int textHeight = 10;
    private int logoTop = 0;
    private int currDrumTop = 0;
    private int statusTop = 0;
    private MIDIControl mc;
    private static final int[] DRUM_NUMBERS = new int[]{0, 42, 46, 54, 50, 47, 43, 51, 56, 49, 36, 39, 40};
    private static final String[] DRUM_NAMES = new String[]{"", "Closed Hi-Hat", "Open Hi-Hat", "Tambourine", "Hi Tom", "Mid Tom", "Low Tom", "Ride Cymbal", "Cow Bell", "Crash Cymbal", "Bass Drum", "Hand Clap", "Snare Drum"};
    private static final String[] SHORT_DRUM_NAMES = new String[]{"", "CH", "OH", "TB", "HT", "MT", "LT", "RC", "CB", "CC", "BD", "HC", "SD"};
    private static final int[] DRUM_KEYS = new int[]{0, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};

    private static void debugOut(String s) {
        Utils.debugOut("DrummerCanvas: " + s);
    }

    public DrummerCanvas(SimpleTones tones, Utils.BreadCrumbTrail parent) {
        this.parent = parent;
        this.tones = tones;
    }

    public Displayable go(Displayable d) {
        return this.parent.go(d);
    }

    public Displayable goBack() {
        return this.parent.goBack();
    }

    public Displayable replaceCurrent(Displayable d) {
        return this.parent.replaceCurrent(d);
    }

    public Displayable getCurrentDisplayable() {
        return this.parent.getCurrentDisplayable();
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.backCommand) {
            this.goBack();
        } else if (c == this.helpCommand) {
            this.showHelp();
        } else if (s != this) {
            this.goBack();
        }
    }

    private void status(String s) {
        this.status = s;
        this.repaint(0, this.statusTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    private void setCurrDrum(int num) {
        this.currDrum = DRUM_NAMES[num];
        this.repaint(0, this.currDrumTop, this.displayWidth, this.textHeight);
        this.serviceRepaints();
    }

    public void updateDisplay() {
        this.repaint();
        this.serviceRepaints();
    }

    public void show() {
        this.addCommand(this.backCommand);
        this.addCommand(this.helpCommand);
        this.setCommandListener(this);
        this.status("Prefetching and getting MIDIControl");
        this.updateDisplay();
        new Thread(new Runnable(){

            public void run() {
                try {
                    DrummerCanvas.this.mc = DrummerCanvas.this.tones.getMIDIControl();
                    DrummerCanvas.this.status("Ready.");
                }
                catch (Exception e) {
                    DrummerCanvas.this.status(Utils.friendlyException(e));
                    DrummerCanvas.this.mc = null;
                }
            }
        }).start();
    }

    protected void keyPressed(int keycode) {
        try {
            for (int num = 1; num < DRUM_KEYS.length; ++num) {
                if (keycode != DRUM_KEYS[num]) continue;
                this.playDrum(num);
                return;
            }
        }
        catch (Throwable t) {
            Utils.error(t, this.parent);
        }
    }

    private void playDrum(int num) {
        if (this.mc == null) {
            return;
        }
        this.setCurrDrum(num);
        this.mc.shortMidiEvent(153, DRUM_NUMBERS[num], 120);
        this.mc.shortMidiEvent(153, DRUM_NUMBERS[num], 0);
    }

    private boolean intersects(int clipY, int clipHeight, int y, int h) {
        return clipY <= y + h && clipY + clipHeight >= y;
    }

    public void paint(Graphics g) {
        try {
            if (this.displayHeight == -1) {
                this.displayWidth = this.getWidth();
                this.displayHeight = this.getHeight();
                this.textHeight = g.getFont().getHeight();
                this.logo = this.getLogo();
                int currTop = TITLE_TOP + this.textHeight;
                if (this.logo != null) {
                    this.logoTop = currTop += LOGO_GAP;
                    currTop += this.logo.getHeight();
                }
                this.currDrumTop = this.displayHeight - 2 * this.textHeight - STATUS_GAP;
                this.statusTop = this.displayHeight - this.textHeight;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setColor(0);
            g.fillRect(clipX, clipY, clipWidth, clipHeight);
            if (this.intersects(clipY, clipHeight, TITLE_TOP, this.textHeight)) {
                g.setColor(0xFF7F00);
                g.drawString(TITLE, this.displayWidth >> 1, TITLE_TOP, 17);
            }
            if (this.logo != null && this.intersects(clipY, clipHeight, this.logoTop, this.logo.getHeight())) {
                g.drawImage(this.logo, this.displayWidth / 2, this.logoTop, 17);
            }
            if (this.intersects(clipY, clipHeight, this.currDrumTop, this.textHeight)) {
                g.setColor(0xE0E0FF);
                g.drawString(this.currDrum, 0, this.currDrumTop, 20);
            }
            if (this.intersects(clipY, clipHeight, this.displayHeight - this.textHeight, this.textHeight)) {
                g.setColor(0xFAFAFA);
                g.drawString(this.status, 0, this.displayHeight, 36);
            }
        }
        catch (Throwable t) {
            DrummerCanvas.debugOut("in paint(): " + Utils.friendlyException(t));
        }
    }

    public void showHelp() {
        List list = new List("Drummer Help", 3);
        list.append("Use the numeric keys", null);
        list.append("to play drums. Each", null);
        list.append("Key corresponds to a", null);
        list.append("different drum.", null);
        list.addCommand(this.backCommand);
        list.setCommandListener((CommandListener)this);
        this.go((Displayable)list);
    }

    private Image getLogo() {
        if (this.logo == null) {
            try {
                this.logo = Image.createImage((String)LOGO);
            }
            catch (Exception ex) {
                this.logo = null;
            }
            if (this.logo == null) {
                DrummerCanvas.debugOut("can not load /icons/logo.png");
            }
        }
        return this.logo;
    }
}

