/*
 * Decompiled with CFR 0.152.
 */
package example.SoccerQ;

import example.SoccerQ.Utils;
import java.util.Stack;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public abstract class BaseListMidlet
extends MIDlet
implements CommandListener {
    protected Command exitCommand = new Command("Exit", 7, 1);
    protected Command backCommand = new Command("Back", 2, 1);
    protected Command playCommand = new Command("Play", 8, 1);
    protected Command selectCommand = new Command("Select", 8, 1);
    private List list;
    private Stack history = new Stack();
    private Displayable currDisplayable;
    private boolean firstTime = true;

    public BaseListMidlet(String title) {
        this.list = new List(title, 3);
        this.list.setCommandListener((CommandListener)this);
        this.fillList(this.list);
        this.history.setSize(0);
    }

    public Displayable goBack() {
        if (Utils.DEBUG) {
            Utils.debugOut("before goBack: (" + this.history.size() + " elements)");
            for (int i = this.history.size() - 1; i >= 0; --i) {
                Utils.debugOut("   " + i + ": " + this.history.elementAt(i).toString());
            }
        }
        if (this.history.empty()) {
            this.exit();
            return null;
        }
        Displayable d = (Displayable)this.history.pop();
        Utils.debugOut("History: " + this.history.size() + " elements.");
        return this.replaceCurrent(d);
    }

    public Displayable go(Displayable d) {
        Displayable curr = this.getCurrentDisplayable();
        if (curr != null) {
            this.history.push(curr);
        }
        if (Utils.DEBUG) {
            Utils.debugOut("after go: (" + this.history.size() + " elements)");
            for (int i = this.history.size() - 1; i >= 0; --i) {
                Utils.debugOut("   " + i + ": " + this.history.elementAt(i).toString());
            }
        }
        return this.replaceCurrent(d);
    }

    public Displayable replaceCurrent(Displayable d) {
        this.getDisplay().setCurrent(d);
        if (!(d instanceof Alert)) {
            this.currDisplayable = d;
        }
        Utils.debugOut("SetCurrent: " + d.toString());
        return d;
    }

    public Displayable getCurrentDisplayable() {
        return this.currDisplayable;
    }

    protected List getList() {
        return this.list;
    }

    protected Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    protected abstract void fillList(List var1);

    protected abstract void selectCommand(int var1);

    public final void startApp() {
        if (this.firstTime) {
            this.go((Displayable)this.getList());
            this.firstTime = false;
        } else {
            Displayable curr = this.getCurrentDisplayable();
            if (curr instanceof Utils.Interruptable) {
                ((Utils.Interruptable)curr).resumeApp();
            }
        }
    }

    public final void pauseApp() {
        Displayable curr = this.getCurrentDisplayable();
        if (curr instanceof Utils.Interruptable) {
            ((Utils.Interruptable)curr).pauseApp();
        }
    }

    public void destroyApp(boolean unconditional) {
    }

    public final void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            this.exit();
        } else if (c == this.backCommand) {
            this.goBack();
        } else if (s == this.list && c == List.SELECT_COMMAND || c == this.playCommand || c == this.selectCommand) {
            this.selectCommand(this.getList().getSelectedIndex());
        }
    }
}

