/*
 * Decompiled with CFR 0.152.
 */
package example.serverscript.demo;

import example.serverscript.connector.Interface_Stub;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Demo
extends MIDlet
implements Runnable,
CommandListener {
    private Interface_Stub service;
    private ParserHandler parser;
    private boolean busy = false;
    private Screen screen;
    private Display display;
    private Hashtable commandTypes;
    private Hashtable alertTypes;
    private Hashtable constraints;
    private String requestInfo;
    private String requestCommand;
    private SAXParser saxParser;
    private static final String EXIT_STRING = "Exiting..";

    public void startApp() {
        this.service = new Interface_Stub();
        this.service._setProperty("javax.xml.rpc.session.maintain", new Boolean(true));
        this.parser = new ParserHandler();
        this.display = Display.getDisplay((MIDlet)this);
        this.commandTypes = new Hashtable(8);
        this.commandTypes.put("back", new Integer(2));
        this.commandTypes.put("cancel", new Integer(3));
        this.commandTypes.put("exit", new Integer(7));
        this.commandTypes.put("help", new Integer(5));
        this.commandTypes.put("item", new Integer(8));
        this.commandTypes.put("ok", new Integer(4));
        this.commandTypes.put("screen", new Integer(1));
        this.commandTypes.put("stop", new Integer(6));
        this.alertTypes = new Hashtable(5);
        this.alertTypes.put("alarm", AlertType.ALARM);
        this.alertTypes.put("confirmation", AlertType.CONFIRMATION);
        this.alertTypes.put("error", AlertType.ERROR);
        this.alertTypes.put("info", AlertType.INFO);
        this.alertTypes.put("warning", AlertType.WARNING);
        this.constraints = new Hashtable(6);
        this.constraints.put("any", new Integer(0));
        this.constraints.put("emailaddr", new Integer(1));
        this.constraints.put("numeric", new Integer(2));
        this.constraints.put("password", new Integer(65536));
        this.constraints.put("phonenumber", new Integer(3));
        this.constraints.put("url", new Integer(4));
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            this.error("Error initializing JSR172 features.");
            return;
        }
        this.retrieveScreen(null, null);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    private void retrieveScreen(String string, String string2) {
        System.out.println("retrieve screen: info = " + string + ", command = " + string2);
        this.busy = true;
        this.requestCommand = string2;
        this.requestInfo = string;
        new Thread(this).start();
    }

    public void run() {
        block4: {
            try {
                String string = this.service.request(this.requestInfo, this.requestCommand);
                System.out.println("screen = (((" + string + ")))");
                this.parser.reset();
                this.saxParser.parse((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), (DefaultHandler)this.parser);
                if (this.screen == null) {
                    this.error("Server error or incompatibility.\n");
                } else {
                    this.screen.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.screen);
                }
                this.busy = false;
            }
            catch (Exception exception) {
                if (EXIT_STRING.equals(exception.getMessage())) break block4;
                exception.printStackTrace();
                this.error("Connection problems.\nCheck your internet/proxy settings.");
            }
        }
    }

    public void error(String string) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        alert.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)alert);
        this.busy = false;
        this.screen = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.busy) {
            return;
        }
        String string = null;
        if (this.screen == null) {
            this.destroyApp(false);
            this.notifyDestroyed();
            return;
        }
        if (this.screen instanceof List) {
            List list = (List)this.screen;
            string = list.getString(list.getSelectedIndex());
        } else if (this.screen instanceof TextBox) {
            string = ((TextBox)this.screen).getString();
        }
        this.retrieveScreen(string, command.getLabel());
    }

    class ParserHandler
    extends DefaultHandler {
        Stack stack;
        Object current;

        ParserHandler() {
        }

        public void reset() {
            this.stack = new Stack();
            Demo.this.screen = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("Exit".equals(string3)) {
                Demo.this.screen = null;
                Demo.this.destroyApp(false);
                Demo.this.notifyDestroyed();
                throw new SAXException(Demo.EXIT_STRING);
            }
            if ("Alert".equals(string3)) {
                AlertType alertType = AlertType.INFO;
                String string4 = attributes.getValue("type");
                if (string4 != null) {
                    alertType = (AlertType)Demo.this.alertTypes.get(string4);
                }
                Alert alert = new Alert(attributes.getValue("title"), null, null, alertType);
                int n = -2;
                String string5 = attributes.getValue("timeout");
                if (string5 != null) {
                    n = Integer.parseInt(string5);
                }
                alert.setTimeout(-2);
                this.current = Demo.this.screen = (Screen)alert;
            } else if ("List".equals(string3)) {
                List list = new List(attributes.getValue("title"), 3);
                this.current = Demo.this.screen = (Screen)list;
            } else if ("TextBox".equals(string3)) {
                int n = 0;
                String string6 = attributes.getValue("constraints");
                if (string6 != null) {
                    n = (Integer)Demo.this.constraints.get(string6);
                }
                int n2 = 20;
                String string7 = attributes.getValue("size");
                if (string7 != null) {
                    n2 = Integer.parseInt(string7);
                }
                TextBox textBox = new TextBox(attributes.getValue("title"), null, n2, n);
                this.current = Demo.this.screen = (Screen)textBox;
            } else if ("Item".equals(string3)) {
                this.current = "Item";
            } else if ("Command".equals(string3)) {
                int n = 4;
                String string8 = attributes.getValue("type");
                if (string8 != null) {
                    n = (Integer)Demo.this.commandTypes.get(string8);
                }
                int n3 = 1;
                String string9 = attributes.getValue("priority");
                if (string9 != null) {
                    n3 = Integer.parseInt(string9);
                }
                Command command = new Command(attributes.getValue("title"), n, n3);
                Demo.this.screen.addCommand(command);
                if ("true".equals(attributes.getValue("select")) && Demo.this.screen instanceof List) {
                    ((List)Demo.this.screen).setSelectCommand(command);
                }
                this.current = command;
            } else {
                this.current = new Object();
            }
            this.stack.push(this.current);
        }

        public void characters(char[] cArray, int n, int n2) {
            Object e = this.stack.peek();
            if (e instanceof Alert) {
                ((Alert)this.stack.peek()).setString(new String(cArray, n, n2));
            } else if ("Item".equals(e)) {
                if (Demo.this.screen instanceof List) {
                    ((List)Demo.this.screen).append(new String(cArray, n, n2), null);
                }
            } else if (e instanceof TextBox) {
                ((TextBox)this.stack.peek()).setString(new String(cArray, n, n2));
            }
        }

        public void endElement(String string, String string2, String string3) {
            this.stack.pop();
        }
    }
}

