file_id = H5F_OPEN('diag_conv_spd_anl.2022092700.nc4') 
;% Loaded DLM: HDF5.
;get the ids ...
;%date_id = H5D_OPEN(file_id, 'time_coverage_start')   
wspd_id = H5D_OPEN(file_id, '/Observation')   
lat_id = H5D_OPEN(file_id, '/Latitude')   
lon_id = H5D_OPEN(file_id, '/Longitude')   
;
aflg_id= H5D_OPEN(file_id, '/Analysis_Use_Flag')
Obs_for_id= H5D_OPEN(file_id, '/Obs_Minus_Forecast_adjusted')
obs_class_id= H5D_OPEN(file_id, '/Observation_Class')
obs_sub_id= H5D_OPEN(file_id,'/Observation_Subtype') 
obs_type_id= H5D_OPEN(file_id,'/Observation_Type') 
prep_qc_id= H5D_OPEN(file_id,'/Prep_Use_Flag') 
station_id= H5D_OPEN(file_id,'/Station_ID') 
;load the variables ...
wnd = H5D_READ(wspd_id)
lat = H5D_READ(lat_id)
lon = H5D_READ(lon_id)
obs_sub=H5D_READ(obs_sub_id)
obs_type=H5D_READ(obs_type_id)
prep_qc=H5D_READ(prep_qc_id)
station=H5D_READ(station_id)
Obs_for=H5D_READ(Obs_for_id)
obs_class=H5D_READ(obs_class_id)
;--------------------------------------------------------------

bin1= where((wnd le 3) and (obs_type eq 283))
bin2= where(((wnd gt 3) and (wnd le 6)) and (obs_type eq 283))
bin3= where(((wnd gt 6) and (wnd le 9)) and (obs_type eq 283))
bin4= where(((wnd gt 9) and (wnd le 12)) and (obs_type eq 283))
bin5= where(((wnd gt 12) and (wnd le 15)) and (obs_type eq 283))
bin6= where((wnd gt 15) and (obs_type eq 283))
;
print,max(wnd)
set_plot,'Z'
restore,'colors1.idl' & tvlct,red,green,blue
set_plot,'ps',/copy
device,/close
;***********************************************************************************************************************
nlt=[21.0,21.0] & nlg=[-54.5,-54.5]
set_plot,'ps'
device,xsize=40,ysize=40,xoffset=1,yoffset=1,/portrait,/color,filename='2700.ps'
lats = [ 1,5,10,15,20,25,30] 
;lats = [ -80, -45, -30, -20, 0, 15, 27, 35, 45, 55, 75]
; Create string equivalents of latitudes:
;latnames = strtrim(lats, 2)
; Label the equator:
lons=[ -30,-35,-40,-45,-50,-55]
map_set,/isotropic,limit=[-5.0,-55.0,20.0,-25.0],latdel=5,londel=5,xmargin=[3,3],ymargin=[3,3],TITLE = 'CYG V3.1 - SAM'
;***********************************************************************************************************************
;nlt=[21.0,21.0] & nlg=[-54.5,-54.5]
;set_plot,'ps'
;device,xsize=40,ysize=40,xoffset=1,yoffset=1,/portrait,/color,filename='2700.ps'
;lons=[ -110,-105,-100,-95,-90,-85,-80,-75,-70,-65,-60,-50]
;lats = [ 1,5,10,15,20,25,30]
;map_set,/isotropic,limit=[5.0,-100.0,30.0,-70.0],latdel=5,londel=5,xmargin=[3,3],ymargin=[3,3],TITLE = 'CYG V3.1 - IDA'
;*************************Different domain for IDA*********************************************************************
MAP_GRID, LABEL=1, LATS=lats,LONS=lons,LATLAB=-50,LONLAB=20, LATDEL=5, LONDEL=5
oplot,lon(bin1),lat(bin1),psym=2,thick=7,color=1   ;deep blue                         
oplot,lon(bin2),lat(bin2),psym=2,thick=7,color=133 ;red                           
oplot,lon(bin3),lat(bin3),psym=2,thick=7,color=190 ;violet                           
oplot,lon(bin4),lat(bin4),psym=2,thick=7,color=23  ;clear blue                          
oplot,lon(bin5),lat(bin5),psym=2,thick=7,color=40  ; turquoise            
oplot,lon(bin6),lat(bin6),psym=2,thick=7           ;black             

map_continents,/hires,/coasts,mlinethick=4                                            
save,/all,filename='2700.idl'
device,/close
exit

