function [ mslp wind londist latdist ] = get_mslp_10mwind(filename);

r_earth = 6371.220;
deg2rad = pi/180;
eps1    = 1e-6;
sqrt2   = 1/sqrt(2);

cdfid=netcdf.open(filename,'NC_NOWRITE');

ixid = netcdf.inqDimID(cdfid, 'west_east');
[dim, ie] = netcdf.inqDim(cdfid,ixid);
jyid = netcdf.inqDimID(cdfid, 'south_north');
[dim, je] = netcdf.inqDim(cdfid,jyid);
kid = netcdf.inqDimID(cdfid, 'bottom_top');
[dim, ke] = netcdf.inqDim(cdfid,kid);

ie = ie - 1;
ia = ie;
je = je - 1;
ja = je/2;
ka = ke - 1;

irange    = 1:ia;
jrange    = 1:ja;
irangeabs = 1:ia;
jrangeabs = 1:ja;
   
isearchrange = 1:ia;
jsearchrange = 1:ja;
[longrid,latgrid] = get_hwrf_griddist(filename, 1);

[londist,latdist] = get_hwrf_totaldist(longrid,latgrid);


[theta,r] = cart2pol(londist,latdist);
%londist           = londist / 1000;
%latdist           = latdist / 1000;

mslp   = get_hwrf_mslp(filename);
mslpij = mslp(isearchrange,jsearchrange);
[rmin cmin] = find(mslpij == min(min(mslp(isearchrange,jsearchrange))));
ilocationmean = mean(isearchrange(rmin));
jlocationmean = mean(jsearchrange(cmin));
stormi=ilocationmean;
stormj=jlocationmean;

londist = londist - londist(stormi,stormj);
latdist = latdist - latdist(stormi,stormj);
[theta,r] = cart2pol(londist,latdist);


%londist = londist - londist(ilocationmean,jlocationmean);
%latdist = latdist - latdist(ilocationmean,jlocationmean);
%500km maximum radius
horrange = 200;
curmaxdisti = londist(ilocationmean,jlocationmean ) + horrange;
curmindisti = londist(ilocationmean,jlocationmean) - horrange;
curmaxdistj = latdist(ilocationmean,jlocationmean) + horrange;
curmindistj = latdist(ilocationmean,jlocationmean) - horrange;

londist           = londist / 1000;
latdist           = latdist / 1000;
irangeplot1 = ceil(interp1(squeeze(londist(:,jlocationmean)),irange,curmindisti));
irangeplot1 = min([irangeplot1 ia]);
irangeplot2 = floor(interp1(squeeze(londist(:,jlocationmean)),irange,curmaxdisti));
irangeplot2 = max([irangeplot2 1]);
jrangeplot1 = ceil(interp1(squeeze(latdist(ilocationmean,:)),jrange,curmindistj));
jrangeplot1 = min([jrangeplot1 ja]);
jrangeplot2 = floor(interp1(squeeze(latdist(ilocationmean,:)),jrange,curmaxdistj));
jrangeplot2 = max([jrangeplot2 1]);
irangeplot = irangeplot1:irangeplot2;
jrangeplot = jrangeplot1:jrangeplot2;

totdist = sqrt(londist(irangeplot,jrangeplot).^2+latdist(irangeplot,jrangeplot).^2);
totdistvect = unique(reshape(totdist,[1 numel(totdist)]));
distinc1 = sqrt( mean(mean(diff(londist,1,2)))^2 + mean(mean(diff(latdist,1,1))) );
distinc2 = totdistvect(2);
distinc  = max([distinc1 distinc2]);
hordistsearchvect = [0 (distinc/2):distinc:(horrange-(distinc/2)) horrange];
numdist = length(0:distinc:horrange);
distinc  = max([distinc1 distinc2]);
horvector  = 0:distinc:distinc*(numdist-1);

varid=netcdf.inqVarID(cdfid,'U');
vartempU = netcdf.getVar(cdfid,varid);
varid=netcdf.inqVarID(cdfid,'V');
vartempV = netcdf.getVar(cdfid, varid);
vartempU = wind2agrid(vartempU,1);
vartempV = wind2agrid(vartempV,1);
vartempS = sqrt(vartempU.^2 + vartempV.^2);
varid=netcdf.inqVarID(cdfid,'USTAR');
ustar = netcdf.getVar(cdfid, varid);
ustar = wind2agrid(ustar,1);
vartempH = get_hwrf_hgt(filename,1,1,1);
vartempS10 = convert_to_10m(vartempS,ustar,vartempH);
usfc = vartempS10./vartempS.*vartempU;
vsfc = vartempS10./vartempS.*vartempV;
wind = sqrt(usfc.^2 + vsfc.^2);

[theta,r] = cart2pol(londist,latdist);

% -------------------------------------------------------------------------


function [x10] = convert_to_10m(x1,xstar,h1);

% Extrapolates down from level 1 to 10-m, assuming neutral stability

vk = 0.4;

x10 = x1 - xstar./vk.*log(h1/10);


% -------------------------------------------------------------------------


