%fv3dynvars files
%ncid2=netcdf.open("fv3_dynvars_prior");
%ncid1=netcdf.open("grid_spec.nest02.tile2.nc");
ncid1=netcdf.open("grid_spec_altius_onqc");
%ncid2=netcdf.open("fv3_dynvars_post_altius_newrh_newens");
%ncid2=netcdf.open("fv3_dynvars_altius_hybens")
%ncid2=netcdf.open("fv3_dynvars_post_hafsb_newrh");
ncid2=netcdf.open("fv3_dynvars_altius_onqc");
%ncid2=netcdf.open("fv3_dynvars_bufrdrops_hlevs");
ncid3=netcdf.open("fv3_dynvars_hafsb_first_guess");
%ncid3=netcdf.open("fv3_dynvars_altius_hybens")
%ncid2=netcdf.open("fv3_dynvars_prior")
%ncid2=netcdf.open("fv3_dynvars_hafsb_newens_first_guess.nc")
%ncid3=netcdf.open("fv3_dynvars_hafsb_norh");
%ncid3=netcdf.open("20220928.120000.fv_core.res.nest02.tile2.nc");
%ncid3=netcdf.open("fv3_dynvars_hafsb_control");
%ncid3=netcdf.open("fv3_dynvars_altius_bufrdrops_hlevs");
%var ids u=6 v=7 W=8 DZ=9 T=10 delp=11 phis=12 ua=13 va=14
%lat=5 lon=6 latt=7 lont=8

lat1=netcdf.getVar(ncid1,6);
lon1=netcdf.getVar(ncid1,5);
lat1t=netcdf.getVar(ncid1,8);
lon1t=netcdf.getVar(ncid1,7);

u1=netcdf.getVar(ncid2,6);
v1=netcdf.getVar(ncid2,7);
w1=netcdf.getVar(ncid2,8);
t1=netcdf.getVar(ncid2, 10);
dz1=netcdf.getVar(ncid2,9);
delp1=netcdf.getVar(ncid2,11);
phis1=netcdf.getVar(ncid2,12);
u1t=netcdf.getVar(ncid2,13);
v1t=netcdf.getVar(ncid2,14);

u2=netcdf.getVar(ncid3,6);
v2=netcdf.getVar(ncid3,7);
w2=netcdf.getVar(ncid3,8);
t2=netcdf.getVar(ncid3, 10);
dz2=netcdf.getVar(ncid3,9);
delp2=netcdf.getVar(ncid3,11);
phis2=netcdf.getVar(ncid3,12);
u2t=netcdf.getVar(ncid3,13);
v2t=netcdf.getVar(ncid3,14);


%atmf000 files
%levels 175:25:1000:10m:
% variables (VAR_PPPmb) VVEL DZDT, UGRD, VGRD, ABSV, ICMR, RWMR, SNMR,GRLE,
% REFD, HGT, TMP, RH, SPFH
% Vertical velocity (pressure), Vertical velocity (geometric), U wind, V wind, 
%Absolute vorticity, ice, rain, snow, grauple mixing ratio, reflectivity,
%geopotential height, temperature, relative humidity, specific humidity
%ncid=netcdf.open("09l.2022092812.hfsa_altius_prior.storm.atm.f000.nc");
%ncid2=netcdf.open("09l.2022092812.hfsa_altius_2kmnorh_cyerr.storm.atm.f000.nc")

%varid=netcdf.inqVarID(ncid,"UGRD_10maboveground");
%u10=netcdf.getVar(ncid,varid);
%varid=netcdf.inq:q
% VarID(ncid,"VGRD_10maboveground");
%v10=netcdf.getVar(ncid,varid);
%varid=netcdf.getVar(ncid,"MSLET_meansealevel");
%mslp=netcdf.getVar(ncid,varid);
%varid=netcdf.ingVarID(ncid,"REFD_");

for k = 1:81
   for i = 1:600
      for j = 1:600
         unow1(i,j,k)=(u1(i,j,k)+u1(i,j+1,k))/2.0;
         unow2(i,j,k)=(u2(i,j,k)+u2(i,j+1,k))/2.0;
      end
   end
end

for k = 1:81
    for j = 1:600
       for i = 1:600
          vnow1(i,j,k)=(v1(i,j,k)+v1(i+1,j,k))/2.0;
          vnow2(i,j,k)=(v1(i,j,k)+v2(i+1,j,k))/2.0;
       end
    end
end


for k = 1:81
   for j = 1:600
      for i = 1:600
         %u1=u1t(i,j,k);
         %v1=v1t(i,j,k);
         u1=unow1(i,j,k);
         v1=vnow1(i,j,k);
         u2=u1.*u1;
         v2=v1.*v1;
         wind1(i,j,k)=sqrt(u2+v2);%%

         %u2=u2t(i,j,k);
         %v2=v2t(i,j,k);
         u2=unow2(i,j,k);
         v2=vnow2(i,j,k);
         u22=u2.*u2;
         v22=v2.*v2;
         wind2(i,j,k)=sqrt(u22+v22);
      end
   end
end

lon1t=lon1t - 360;
figsize = [1 1 7.25 6];
figsizenocbar = [1 1 6.10 6];
axessize = [0.45 0.5 5.25 5.25];
cbarsiz = [6.10 0.5 0.25 5.25];
fontsiz = 16;
clear cmap

%prior
windnow1=wind1(:,:,81);
tnow1=t1(:,:,81);
%lon1t=lon1t - 360.0;

figure('Units','inches','Position',figsize,'PaperUnits','inches','PaperPosition',figsize);
axes('Units','inches','Position',axessize);
%clevs=[0:2:2:60];
clevs=[0:2:2:76];
cmap = changecolormap_new(clevs,1,2);
colormap(cmap);
contourf(lon1t,lat1t,windnow1,'LevelList',clevs,'LineColor','none');
%contourf(lat1t,lonnow,windnow1,'LevelList',clevs,'LineColor','none');

hold on
colorbar('Units','inches','Position',cbarsiz,'FontName','FixedWidth','FontSize',fontsiz);

clevsadd=[33 42];
ccolsadd=[0 0 0];
[cc hh]=contour(lon1t,lat1t,windnow1,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
%[cc hh]=contour(lat1t,lonnow,windnow1,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
clabel(cc,hh);

%caxis([0 60]);
caxis([0 76]);
ylim([25 27]);
%xlim([276.2 278.2]);
xlim([-83.8 -81.8]);
%title("HAFS-B NEWRH NEWENS ANALYSIS")
clear cmap

%post
windnow2=wind2(:,:,81);

figure('Units','inches','Position',figsize,'PaperUnits','inches','PaperPosition',figsize);
axes('Units','inches','Position',axessize);
%clevs=[0:2:2:60];
clevs=[0:2:2:76];
cmap = changecolormap_new(clevs,1,2);
colormap(cmap);
contourf(lon1t,lat1t, windnow2,'LevelList',clevs,'LineColor','none');
%contourf(lat1t,lonnow, windnow2,'LevelList',clevs,'LineColor','none')
hold on
colorbar('Units','inches','Position',cbarsiz,'FontName','FixedWidth','FontSize',fontsiz);

clevsadd=[33 42];
ccolsadd=[0 0 0];
[cc hh]=contour(lon1t,lat1t,windnow2,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
%[cc hh]=contour(lat1t,lonnow,windnow2,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
clabel(cc,hh);

%caxis([0 60]);
caxis([0 76]);
ylim([25 27]);
%xlim([276.2 278.2]);
xlim([-83.8 -81.8]);
%title("HAFS-B FIRST GUESS")

winddiff=windnow1 - windnow2;
%winddiff=windnow2 - windnow1;

clear cmap

grey=[0.5 0.5 0.5];
white=[1 1 1];
%FIGURE 5
figure('Units','inches','Position',figsize,'PaperUnits','inches','PaperPosition',figsize);
axes('Units','inches','Position',axessize);   
clevs=[-8:0.5:8];
%clevs=[-30:2:30];
%clevs=[-20:1:20];
%clevs=[-5:0.25:0:0.25:5];
cmap = changecolormap_new(clevs,1,1);
colormap(cmap);
contourf(lon1t,lat1t, winddiff,'LevelList',clevs,'LineColor',grey,'LineWidth',0.1);
%contourf(lat1t,lonnow, winddiff,'LevelList',clevs,'LineColor',grey,'LineWidth',0.1);
hold on
colorbar('Units','inches','Position',cbarsiz,'FontName','FixedWidth','FontSize',fontsiz);
clevsadd=[0];
ccolsadd=[0 0 0];
[cc hh]=contour(lon1t,lat1t, winddiff,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
%[cc hh]=contour(lat1t,lonnow, winddiff,'LevelList',clevsadd,'LineColor',ccolsadd,'LineWidth',1,'LineStyle','-');
caxis([-8 8]);
%caxis([-5 5]);
ylim([25 27]);
%xlim([276.2 278.2]);
xlim([-83.8 -81.8]);
%title('LEVEL 1 WIND DIFFERENCE (ms^-^1)')
clear cmap


