close all;
clear;
clc;

work_path = 'C:\Users\ksell\Documents\MATLAB\DROPLEVS\HAFS' 
expt = 'bufrdrops';
fpath = [work_path expt '/'];
flist = dir([fpath,'20*']);

Nt = size(flist,1);
obs = 't';
obsIndex = 137;
platform = 'dropsonde';

if(strcmp(obs, 'q'))
    unit_coef = 1000;
    unit = 'g kg^{-1}';
elseif(strcmp(obs,'t'))
    unit_coef = 1;
    unit = '^o C';
elseif (strcmp(obs,'spd') || strcmp(obs,'rw'))
    unit_coef = 1;
    unit = 'm s^{-1}';
end

RR = zeros(Nt,1);
RMS_innov = zeros(Nt,1);

Bias = zeros(Nt,1);
RMS_innov_oma = zeros(Nt,1);
Bias_oma = zeros(Nt,1);
it = 1;

for ii = 1:Nt
    
    cycle_str = flist(ii).name;
    %cycle_str = '2020082412';
    filepath = [fpath,cycle_str];
    %filename1 = [filepath,'/diag_conv_',obs,'_ges.',cycle_str,'_ensmean.nc4'];
    filename1 = [filepath,'/diag_conv_',obs,'_ges.',cycle_str,'.nc4'];
    if exist(filename1,"file")
        ObsType = ncread(filename1,'Observation_Type');
        
        if strcmp(platform,'AMV')
            dataIndex = find((ObsType>=240)&(ObsType<=260));
        elseif strcmp(platform,'surface')
            if strcmp(obs,'uv')
                dataIndex = find((ObsType==280)|(ObsType==281)|(ObsType==287));
            elseif strcmp(obs,'t') || strcmp(obs,'q')
                dataIndex = find((ObsType==180)|(ObsType==181));
            else
                dataIndex = find((ObsType==180)|(ObsType==181)|(ObsType==187));
            end
        else
            dataIndex = find(ObsType==obsIndex);
        end

        tmp_data = ncread(filename1,'Errinv_Final');
        ObsErr = tmp_data(dataIndex);
        ObsErr = 1./ObsErr*unit_coef;

        tmp_data = ncread(filename1,'Errinv_Input');
        Err_Input = tmp_data(dataIndex);
        Err_Input = 1./Err_Input*unit_coef;

        if strcmp(obs,'uv')
            tmp_data = ncread(filename1,'u_Obs_Minus_Forecast_adjusted');
            uu_innov = tmp_data(dataIndex);
            tmp_data = ncread(filename1,'v_Obs_Minus_Forecast_adjusted');
            vv_innov = tmp_data(dataIndex);           
            innov_data = [uu_innov,vv_innov];
            
        else
            tmp_data = ncread(filename1,'Obs_Minus_Forecast_adjusted');
            innov_data = tmp_data(dataIndex)*unit_coef;
        end

        if strcmp(obs,'q')    
            tmp_data = ncread(filename1,'Forecast_Saturation_Spec_Hum');
            Ssh = tmp_data(dataIndex);
        else
            Ssh = 1; 
        end

        %filename2 = [filepath,'/diag_conv_',obs,'_ges.ensmean_spread.nc4']; 
        filename2 = [filepath,'/diag_conv_',obs,'_anl.'cycle_str'.nc4'];
        if strcmp(obs,'uv')
            tmp_data = ncread(filename2,'u_EnKF_spread_ges');
            uu_sprd = tmp_data(dataIndex);                    
            tmp_data = ncread(filename2,'v_EnKF_spread_ges');
            vv_sprd = tmp_data(dataIndex);
            sprd_data = [uu_sprd,vv_sprd];
               
            tmp_data = ncread(filename2,'u_EnKF_use_flag');
            u_flag_data = tmp_data(dataIndex);            
            tmp_data = ncread(filename2,'v_EnKF_use_flag');
            v_flag_data = tmp_data(dataIndex);             
            flag_data = [u_flag_data,v_flag_data]; 
            
            tmp_data = ncread(filename2,'u_EnKF_fit_anl');
            u_innov_oma = tmp_data(dataIndex);        
            tmp_data = ncread(filename2,'v_EnKF_fit_anl');
            v_innov_oma = tmp_data(dataIndex);
            innov_oma = [u_innov_oma,v_innov_oma];
        else                
            tmp_data = ncread(filename2,'EnKF_spread_ges');
            sprd_data = tmp_data(dataIndex)*(Ssh*unit_coef)^2;
        
            tmp_data = ncread(filename2,'EnKF_use_flag');
            flag_data = tmp_data(dataIndex);
            
            tmp_data = ncread(filename2,'EnKF_fit_anl');
            innov_oma = tmp_data(dataIndex)*Ssh*unit_coef;
        end

        % data cleaning 
        cIndex = find(flag_data==1);
        innov_c = innov_data(cIndex);
        sprd_c = sprd_data(cIndex);
        
        innov_oma_c = innov_oma(cIndex);
        
        ObsErr_c = ObsErr(cIndex);
        ErrInput_c = Err_Input(cIndex);      
        
        err_ratio = ObsErr_c ./ ErrInput_c;
        
       
        % remove data with err_ratio greater than cutoff ratio
        cutoff_ratio = 5;
        cut_index = find(err_ratio<=cutoff_ratio);
        sprd_c = sprd_c(cut_index);
        innov_c = innov_c(cut_index);
        innov_oma_c = innov_oma_c(cut_index);
        ObsErr_c = ObsErr_c(cut_index);

        % calculate the domain-mean ensemble spread
        ensprd_m = mean(sprd_c);

        % calculate the square of rms innovation
        innov_mean = mean(innov_c);
        Bias(it) = innov_mean;
        rms_innov_sq = mean((innov_c-innov_mean).^2);
        RMS_innov(it) = sqrt(rms_innov_sq);
        
        innov_oma_mean = mean(innov_oma_c);
        Bias_oma(it) = innov_oma_mean;
        rms_oma_sq = var(innov_oma_c);
        RMS_innov_oma(it) = sqrt(rms_oma_sq);
    
        % calculate the observation error variance
        ObsErr_var = mean(ObsErr_c.^2);
        
        % the ratio of the actual forecast ensemble spread to the optimal ensemble spread
        RR(it) = (ObsErr_var + ensprd_m)/rms_innov_sq;
        it = it + 1;

    end
    
end
