PRO CMRC_ZMAR2ZOT,zuv,zot
; This module converts marine windspeeds (m/s)
; into "open terrain" windspeeds (m/s)

compile_opt hidden
on_error,1

;...preamble
if n_params() eq 0 then begin print,'ZMAR2ZOT,zuv,zot'
return&endif

;...initializatiion, make marine winds
alp=.49 & bet=.065 & gam=.304745174 & delt=.893027211 
wm=float(sqrt(zuv*conj(zuv)))

;...direction field and 15 deg rotation for open terrain
zdir=zuv/wm & iv=where(wm eq 0.,ict) & if ict ne 0 then zdir(iv)=0.
ei15=complex(cos(!pi/12),sin(!pi/12.)) & zdir=ei15*zdir

;...open terrain winds construction
;x=sqrt(alp+bet*wm) & wot=gam*x*exp(delt/x)*wm
;...This open terrain formula (10mn mean) is the latest 08/10/06
wot=0.0318731+0.8755406*wm
itb=where(wot ge wm,ict) & if ict ne 0 then  wot(itb)=wm(itb)
zot=wot*zdir
END ;CMRC_ZMAR2ZOT.PRO
