PRO CMRC_TRACK
;...This module computes track related quantities for use by other modules.
compile_opt hidden
on_error,1
quiet=check_math(0,1)

;... read trackfile
openr,lu,'trackfile',/get_lun
string=''
readf,lu,string
zhour=-1 & zmin=-1 & elon=sqrt(-1) & nlat=sqrt(-1)
cpr=sqrt(-1) & rmx=sqrt(-1) & hdb=sqrt(-1) & lsflg=-1 & ctg=-1

while not eof(lu) do begin
readf,lu,ctgz,z,z,hrz,minz,nlz,wlz,cpz,rmz,bpz,lsz
zhour=[zhour,fix(hrz)] & zmin=[zmin,fix(minz)]
nlat=[nlat,nlz] & elon=[elon,-wlz] & cpr=[cpr,cpz] & ctg=[ctg,fix(ctgz)]
rmx=[rmx,round(rmz)] & hdb=[hdb,bpz] & lsflg=[lsflg,fix(lsz)] &$
endwhile & close,lu & free_lun,lu

;...trim initial markers
zhour=zhour(1:*) & zmin=zmin(1:*)
nlat=nlat(1:*) & elon=elon(1:*) & cpr=cpr(1:*) & cpr=cpr < 1011.
;print,'hdb....',hdb
rmx=rmx(1:*) & rmx=rmx < 111 & hdb=hdb(1:*) & hdb=hdb > 0.60
;rmx=0.9*rmx(1:*) & rmx=rmx < 111 & hdb=hdb(1:*) & hdb=hdb > 0.60
;rmx=rmx(1:*) & rmx=rmx < 111 & hdb=hdb(1:*) & hdb=hdb 
;print,'hdb....',hdb
lsflg=lsflg(1:*) & ctg=ctg(1:*)

; flag in track.pro
;print,'****before flag in track.pro****',lsflg
;...mark the fix of lowest central pressure unless it coincides with landfall
icpr=where(cpr eq min(cpr)) & if lsflg(icpr(0)) ne 1 then lsflg(icpr(0))=4
; flag in track.pro
;print,'****after flag in track.pro****',lsflg

;... adjust fix frequency according to cyclone intensity
CMRC_THINNER,lsflg,ctg,keep & entries=n_elements(keep)

;... thin out the fix data according to the adjusted fix frequency
cpr=cpr(keep) & elon=elon(keep) & nlat=nlat(keep)
hdb=hdb(keep) & lsflg=lsflg(keep) & ctg=ctg(keep)
rmx=rmx(keep) & zhour=zhour(keep) & zmin=zmin(keep)

;... generate track related tables
index=indgen(entries) & day=intarr(entries) & day(0)=1
for k=1,entries-1 do begin $
day(k)=day(k-1) & if zhour(k) lt zhour(k-1) then day(k)=1+day(k) & endfor
minz=1440*(day-1)+60*zhour+zmin & ktime=minz-minz(0) & pdf=1013-cpr

;...sample data at regular intervals prior to smoothing
ils=where(lsflg eq 1 or lsflg eq 2 or lsflg eq 4,ict)
ktout=60*indgen(max(ktime)/60+1)
pdfx=SPLINE(ktime,pdf,ktout,10)
rmwx=SPLINE(ktime,rmx,ktout,10)
elonx=SPLINE(ktime,elon,ktout,10)
nlatx=SPLINE(ktime,nlat,ktout,10)
hdbx=SPLINE(ktime,hdb,ktout,10)

;...smooth track,rmw,pdg,hdb and fbar on hourly grid
; What is the sensitivity to k? ...try different values of k here 5 to 10;
; added comment on 10/05
for k=1,5 do begin $
elonx=smooth(elonx,3) & nlatx=smooth(nlatx,3) & hdbx=smooth(hdbx,3)
rmwx=smooth(rmwx,3) & pdfx=smooth(pdfx,3) & endfor
fbrx=0.145444*sin(!dtor*nlatx)*rmwx

;subsample the smoothed input data to recover original resolution
pdfs=SPLINE(ktout,pdfx,ktime)
rms=SPLINE(ktout,rmwx,ktime)
hdbs=SPLINE(ktout,hdbx,ktime)
elons=SPLINE(ktout,elonx,ktime)
nlats=SPLINE(ktout,nlatx,ktime)
fbr=SPLINE(ktout,fbrx,ktime)

if ict ne 0 then begin elons(ils)=elon(ils) & nlats(ils)=nlat(ils)
hdbs(ils)=hdb(ils) & rms(ils)=rmx(ils) & pdfs(ils)=pdf(ils) &endif
elon=elons & nlat=nlats & hdb=hdbs & rmx=rms & pdf=pdfs

;...calculate translation speed from track fixes
dtelonx=deriv(ktout,elonx)/60 & dtnlatx=deriv(ktout,nlatx)/60
dtelonx(0)=(elonx(1)-elonx(0))/3600
dtnlatx(0)=(nlatx(1)-nlatx(0))/3600
jj=n_elements(ktout)-1
dtelonx(jj)=(elonx(jj)-elonx(jj-1))/3600
dtnlatx(jj)=(nlatx(jj)-nlatx(jj-1))/3600
dty=1.1111111111e5*dtnlatx
dtx=1.111111111e5*dtelonx*cos(!dtor*nlatx)
spdmsx=sqrt(dtx^2+dty^2) & dirx=180*atan(dty,dtx)/!pi
ing=where(dirx lt 0.,ict)
if ict ne 0 then dirx(ing)=360+dirx(ing) & bearx=90-dirx

;...smooth translation speed and bearing on hourly grid
for k=1,50 do begin
spdmsx=smooth(spdmsx,3) & bearx=smooth(bearx,3) &endfor

;evaluate smoothed translation speed and bearing at fix times
spdms=SPLINE(ktout,spdmsx,ktime)
bear=SPLINE(ktout,bearx,ktime)

;...evaluate smoothed track positions and rmw minute by minute
mink=findgen(max(ktime)+1)
elonk=SPLINE(ktout,elonx,mink)
nlatk=SPLINE(ktout,nlatx,mink)
rmwk=SPLINE(ktout,rmwx,mink)

;...save track related quantities for use by other modules
save,bear,cpr,day,elon,elonk,entries,fbr,hdb,index,ktime,lsflg,minz,$
nlat,nlatk,pdf,rmwk,rmx,spdms,string,zhour,zmin,filename='allvar.idl'
END ;CMRC_TRACK.PRO
