PRO CMRC_THINNER,lsflg,ctg,keep
;... this module reduces the number of hourly fixes depending upon the intensity

compile_opt hidden
on_error,1

;...preamble
if n_params() eq 0 then begin
print,'CMRC_THINNER,lsflg,ctg,keep'
return &endif

;... locate landfalls and seafalls; classify fixes by category
isl=where(lsflg eq 1 or lsflg eq 2 or lsflg eq 4,ict)
islm=isl-1 & islp=isl+1 & jsl=[islm,isl,islp] & jsl=jsl(uniq(jsl,sort(jsl)))

;...deal with special cases
if ict eq 0 then jsl=0 & jsl=jsl > 0 & jx=n_elements(lsflg)-1
jsl=jsl < jx & jsl=jsl(uniq(jsl,sort(jsl)))

;...classify fixes by category
jc0=where(ctg eq 0,jct0) & jc1=where(ctg eq 1,jct1)
jc2=where(ctg eq 2,jct2) & jc3=where(ctg eq 3,jct3)
jc4=where(ctg eq 4,jct4) & jc5=where(ctg eq 5,jct5)

;...category 0 fixes merit 8 hour separation
if jct0 le 1 then ic0=[max([0,jc0])] else  begin 
brk0=[where(jc0(1:*)-jc0 ne 1,i0),n_elements(jc0)-1]
if brk0(0) eq -1 then brk0(0)=brk0(1)
ic0=[jc0(0:brk0(0):8),jc0(brk0(0))]
for j=0,i0-1 do $
ic0=[ic0,jc0(brk0(j)+1:brk0(j+1):8),jc0(brk0(j+1))] &endelse

;...category 1 fixes merit 6 hour separation
if jct1 le 1 then ic1=[max([0,jc1])] else begin 
brk1=[where(jc1(1:*)-jc1 ne 1,i1),n_elements(jc1)-1]
if brk1(0) eq -1 then brk1(0)=brk1(1)
ic1=[jc1(0:brk1(0):6),jc1(brk1(0))]
for j=0,i1-1 do $
ic1=[ic1,jc1(brk1(j)+1:brk1(j+1):6),jc1(brk1(j+1))] &endelse

;...category 2 fixes merit 4 hour separation
if jct2 le 1  then ic2=[max([0,jc2])] else begin  
brk2=[where(jc2(1:*)-jc2 ne 1,i2),n_elements(jc2)-1] 
if brk2(0) eq -1 then brk2(0)=brk2(1)
ic2=[jc2(0:brk2(0):4),jc2(brk2(0))] 
for j=0,i2-1 do $
ic2=[ic2,jc2(brk2(j)+1:brk2(j+1):4),jc2(brk2(j+1))] &endelse

;...category 3 fixes merit 3 hour separation
if jct3 le 1 then ic3=[max([0,jc3])] else begin  
brk3=[where(jc3(1:*)-jc3 ne 1,i3),n_elements(jc3)-1]
if brk3(0) eq -1 then brk3(0)=brk3(1)
ic3=[jc3(0:brk3(0):3),jc3(brk3(0))]
for j=0,i3-1 do $
ic3=[ic3,jc3(brk3(j)+1:brk3(j+1):3),jc3(brk3(j+1))] &endelse

;...category 4 fixes merit 2 hour separation
if jct4 le 1 then ic4=[max([0,jc4])] else begin  
brk4=[where(jc4(1:*)-jc4 ne 1,i4),n_elements(jc4)-1]
if brk4(0) eq -1 then brk4(0)=brk4(1)
ic4=[jc4(0:brk4(0):2),jc4(brk4(0))]
for j=0,i4-1 do $
ic4=[ic4,jc4(brk4(j)+1:brk4(j+1):2),jc4(brk4(j+1))] &endelse

;...category 5 fixes merit 1 hour separation
if jct5 le 1 then ic5=[max([0,jc5])] else begin
brk5=[where(jc5(1:*)-jc5 ne 1,i5),n_elements(jc5)-1]
if brk5(0) eq -1 then brk5(0)=brk5(1)
ic5=[jc5(0:brk5(0)),jc5(brk5(0))]
for j=0,i5-1 do $
ic5=[ic5,jc5(brk5(j)+1:brk5(j+1)),jc5(brk5(j+1))] &endelse

;...merge retained fixes and additional landfall and seafall fixes 
keep=[ic0,ic1,ic2,ic3,ic4,ic5] & keep=[keep,jsl,n_elements(lsflg)-1]
keep=keep(uniq(keep,sort(keep)))
END ;CMRC_THINNER.PRO
